/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.caller;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;

public class RecordReader {
    private BufferedReader fq1 = null;
    private BufferedReader fq2 = null;
    SAMRecordIterator bam_itr = null;
    SAMRecord old_bam_rec = null;

    public RecordReader(String bam_fname, String fq1_fname, String fq2_fname) throws Exception {
        this.fq1 = new BufferedReader(new FileReader(fq1_fname));
        if (fq2_fname != null) {
            this.fq2 = new BufferedReader(new FileReader(fq2_fname));
        }
        SAMFileReader ibam = new SAMFileReader(new File(bam_fname), false);
        ibam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        this.bam_itr = ibam.iterator();
    }

    public ReadAlignment getNextReadAlignment() throws Exception {
        ReadAlignment read_al = null;
        ReadInfo read_info = this.getNextRead();
        if (read_info != null) {
            read_al = new ReadAlignment(read_info);
            for (SAMRecord rec : this.getNextSAMRecord(read_info)) {
                if (this.fq2 == null) {
                    read_al.rec_lst1.add(rec);
                    continue;
                }
                if (rec.getFirstOfPairFlag()) {
                    read_al.rec_lst1.add(rec);
                    continue;
                }
                read_al.rec_lst2.add(rec);
            }
        }
        return read_al;
    }

    private ReadInfo getNextRead() throws Exception {
        ReadInfo read_info = null;
        String header = null;
        String read1 = null;
        String read2 = null;
        header = this.fq1.readLine();
        if (header != null) {
            read1 = this.fq1.readLine();
            this.fq1.readLine();
            this.fq1.readLine();
            if (this.fq2 != null) {
                header = header.substring(0, header.length() - 2);
                String header2 = this.fq2.readLine();
                if (header.compareTo(header2 = header2.substring(0, header2.length() - 2)) != 0) {
                    System.err.println("Read name for end1 and end2 for fastq do not match " + header + " " + header2);
                    throw new Exception();
                }
                read2 = this.fq2.readLine();
                this.fq2.readLine();
                this.fq2.readLine();
            }
            read_info = new ReadInfo(header.substring(1), read1, read2);
        }
        return read_info;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayList<SAMRecord> getNextSAMRecord(ReadInfo read_info) throws Exception {
        ArrayList<SAMRecord> rec_lst = new ArrayList<SAMRecord>();
        if (this.old_bam_rec != null) {
            if (!read_info.matchSAMandFqHeader(this.old_bam_rec)) {
                System.err.println("SAM record header and fastq header do not match for old record" + this.old_bam_rec.getReadName() + " " + read_info.header);
                throw new Exception();
            }
            rec_lst.add(this.old_bam_rec);
        }
        while (this.bam_itr.hasNext()) {
            SAMRecord bam_rec = (SAMRecord)this.bam_itr.next();
            if (!read_info.matchSAMandFqHeader(bam_rec)) {
                this.old_bam_rec = bam_rec;
                return rec_lst;
            }
            rec_lst.add(bam_rec);
        }
        return rec_lst;
    }

    public static class ReadAlignment {
        ReadInfo read_info = null;
        List<SAMRecord> rec_lst1 = null;
        List<SAMRecord> rec_lst2 = null;

        public ReadAlignment(ReadInfo read_info) {
            this.read_info = read_info;
            this.rec_lst1 = new ArrayList<SAMRecord>();
            this.rec_lst2 = new ArrayList<SAMRecord>();
        }
    }

    public static class ReadInfo {
        String header = null;
        String read1 = null;
        String read2 = null;

        public ReadInfo(String header, String read1, String read2) {
            this.header = header;
            this.read1 = read1;
            this.read2 = read2;
        }

        public boolean matchSAMandFqHeader(SAMRecord rec) {
            boolean res = false;
            if (rec.getReadName().compareTo(this.header) == 0) {
                res = true;
            }
            return res;
        }
    }
}

