/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.acl.gs;

import com.jamesmurty.utils.XMLBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GranteeInterface;
import org.jets3t.service.acl.Permission;

public class GSAccessControlList
extends AccessControlList {
    private static final long serialVersionUID = -3170938665076811564L;
    public static final GSAccessControlList REST_CANNED_PRIVATE = new GSAccessControlList();
    public static final GSAccessControlList REST_CANNED_PUBLIC_READ = new GSAccessControlList();
    public static final GSAccessControlList REST_CANNED_PUBLIC_READ_WRITE = new GSAccessControlList();
    public static final GSAccessControlList REST_CANNED_AUTHENTICATED_READ = new GSAccessControlList();
    public static final GSAccessControlList REST_CANNED_BUCKET_OWNER_READ = new GSAccessControlList();
    public static final GSAccessControlList REST_CANNED_BUCKET_OWNER_FULL_CONTROL = new GSAccessControlList();

    public String toString() {
        return "GSAccessControlList [owner=" + this.owner + ", grants=" + this.getGrantAndPermissions() + "]";
    }

    public XMLBuilder toXMLBuilder() throws ServiceException, ParserConfigurationException, FactoryConfigurationError, TransformerException {
        if (this.owner == null) {
            throw new ServiceException("Invalid AccessControlList: missing an Owner");
        }
        XMLBuilder builder = XMLBuilder.create("AccessControlList");
        XMLBuilder ownerBuilder = builder.elem("Owner");
        ownerBuilder.elem("ID").text(this.owner.getId()).up();
        if (this.owner.getDisplayName() != null) {
            ownerBuilder.elem("Name").text(this.owner.getDisplayName());
        }
        XMLBuilder accessControlList = builder.elem("Entries");
        for (GrantAndPermission gap : this.grants) {
            GranteeInterface grantee = gap.getGrantee();
            Permission permission = gap.getPermission();
            accessControlList.elem("Entry").importXMLBuilder(grantee.toXMLBuilder()).elem("Permission").text(permission.toString());
        }
        return builder;
    }

    public String getValueForRESTHeaderACL() {
        if (REST_CANNED_PRIVATE.equals(this)) {
            return "private";
        }
        if (REST_CANNED_PUBLIC_READ.equals(this)) {
            return "public-read";
        }
        if (REST_CANNED_PUBLIC_READ_WRITE.equals(this)) {
            return "public-read-write";
        }
        if (REST_CANNED_AUTHENTICATED_READ.equals(this)) {
            return "authenticated-read";
        }
        if (REST_CANNED_BUCKET_OWNER_READ.equals(this)) {
            return "bucket-owner-read";
        }
        if (REST_CANNED_BUCKET_OWNER_FULL_CONTROL.equals(this)) {
            return "bucket-owner-full-control";
        }
        return null;
    }
}

