/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.bqsr.BQSRKeyManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDatum;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.recalibration.QualQuantizer;

public class QuantizationInfo {
    private List<Byte> quantizedQuals;
    private List<Long> empiricalQualCounts;
    private int quantizationLevels;

    private QuantizationInfo(List<Byte> quantizedQuals, List<Long> empiricalQualCounts, int quantizationLevels) {
        this.quantizedQuals = quantizedQuals;
        this.empiricalQualCounts = empiricalQualCounts;
        this.quantizationLevels = quantizationLevels;
    }

    public QuantizationInfo(List<Byte> quantizedQuals, List<Long> empiricalQualCounts) {
        this(quantizedQuals, empiricalQualCounts, QuantizationInfo.calculateQuantizationLevels(quantizedQuals));
    }

    public QuantizationInfo(Map<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap, int quantizationLevels) {
        Long[] qualHistogram = new Long[94];
        for (int i = 0; i < qualHistogram.length; ++i) {
            qualHistogram[i] = 0L;
        }
        Map<BitSet, RecalDatum> qualTable = null;
        for (Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> entry : keysAndTablesMap.entrySet()) {
            BQSRKeyManager keyManager = entry.getKey();
            if (keyManager.getRequiredCovariates().size() != 2) continue;
            qualTable = entry.getValue();
        }
        if (qualTable == null) {
            throw new ReviewedStingException("Could not find QualityScore table.");
        }
        for (RecalDatum datum : qualTable.values()) {
            int empiricalQual = (int)Math.round(datum.getEmpiricalQuality());
            long nObservations = datum.numObservations;
            int n = empiricalQual;
            Long.valueOf(qualHistogram[n] + nObservations);
        }
        this.empiricalQualCounts = Arrays.asList(qualHistogram);
        this.quantizeQualityScores(quantizationLevels);
        this.quantizationLevels = quantizationLevels;
    }

    public void quantizeQualityScores(int nLevels) {
        QualQuantizer quantizer = new QualQuantizer(this.empiricalQualCounts, nLevels, 6);
        this.quantizedQuals = quantizer.getOriginalToQuantizedMap();
    }

    public void noQuantization() {
        this.quantizationLevels = 93;
        for (int i = 0; i < this.quantizationLevels; ++i) {
            this.quantizedQuals.set(i, (byte)i);
        }
    }

    public List<Byte> getQuantizedQuals() {
        return this.quantizedQuals;
    }

    public int getQuantizationLevels() {
        return this.quantizationLevels;
    }

    public GATKReportTable generateReportTable() {
        GATKReportTable quantizedTable = new GATKReportTable("Quantized", "Quality quantization map");
        quantizedTable.addPrimaryKey("QualityScore");
        quantizedTable.addColumn("Count", 0L);
        quantizedTable.addColumn("QuantizedScore", (byte)0);
        for (int qual = 0; qual <= 93; ++qual) {
            quantizedTable.set(qual, "Count", this.empiricalQualCounts.get(qual));
            quantizedTable.set(qual, "QuantizedScore", this.quantizedQuals.get(qual));
        }
        return quantizedTable;
    }

    private static int calculateQuantizationLevels(List<Byte> quantizedQuals) {
        byte lastByte = -1;
        int quantizationLevels = 0;
        for (byte q : quantizedQuals) {
            if (q == lastByte) continue;
            ++quantizationLevels;
            lastByte = q;
        }
        return quantizationLevels;
    }
}

