/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.gatk.walkers.WalkerName;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

@WalkerName(value="SplitSamFile")
@Requires(value={DataSource.READS})
public class SplitSamFileWalker
extends ReadWalker<SAMRecord, Map<String, SAMFileWriter>> {
    @Argument(fullName="outputRoot", doc="output BAM file", required=false)
    public String outputRoot = null;
    @Argument(fullName="bam_compression", shortName="compress", doc="Compression level to use for writing BAM files", required=false)
    public Integer BAMcompression = 5;
    private static Logger logger = Logger.getLogger(SplitSamFileWalker.class);
    private static String VERSION = "0.0.1";

    @Override
    public void initialize() {
        logger.info("SplitSamFile version: " + VERSION);
    }

    @Override
    public SAMRecord map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        return read;
    }

    @Override
    public void onTraversalDone(Map<String, SAMFileWriter> outputs) {
        for (SAMFileWriter output : outputs.values()) {
            output.close();
        }
    }

    @Override
    public Map<String, SAMFileWriter> reduceInit() {
        HashMap<String, SAMFileHeader> headers = new HashMap<String, SAMFileHeader>();
        for (SAMReadGroupRecord readGroup : this.getToolkit().getSAMFileHeader().getReadGroups()) {
            SAMFileHeader header;
            String sample = readGroup.getSample();
            if (!headers.containsKey(sample)) {
                header = SplitSamFileWalker.duplicateSAMFileHeader(this.getToolkit().getSAMFileHeader());
                logger.debug(String.format("Creating BAM header for sample %s", sample));
                ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>();
                header.setReadGroups(readGroups);
                headers.put(sample, header);
            }
            header = (SAMFileHeader)headers.get(sample);
            ArrayList<SAMReadGroupRecord> newReadGroups = new ArrayList<SAMReadGroupRecord>(header.getReadGroups());
            newReadGroups.add(readGroup);
            header.setReadGroups(newReadGroups);
        }
        HashMap<String, SAMFileWriter> outputs = new HashMap<String, SAMFileWriter>();
        for (Map.Entry elt : headers.entrySet()) {
            String sample = (String)elt.getKey();
            String filename = this.outputRoot + sample + ".bam";
            logger.info(String.format("Creating BAM output file %s for sample %s", filename, sample));
            SAMFileWriter output = ReadUtils.createSAMFileWriterWithCompression((SAMFileHeader)elt.getValue(), true, filename, this.BAMcompression);
            outputs.put(sample, output);
        }
        return outputs;
    }

    @Override
    public Map<String, SAMFileWriter> reduce(SAMRecord read, Map<String, SAMFileWriter> outputs) {
        String sample = read.getReadGroup().getSample();
        SAMFileWriter output = outputs.get(sample);
        if (output == null) {
            throw new RuntimeException(String.format("Read group %s not present in header but found in read %s", read.getReadGroup().getReadGroupId(), read.getReadName()));
        }
        output.addAlignment(read);
        return outputs;
    }

    public static SAMFileHeader duplicateSAMFileHeader(SAMFileHeader toCopy) {
        SAMFileHeader copy = new SAMFileHeader();
        copy.setSortOrder(toCopy.getSortOrder());
        copy.setGroupOrder(toCopy.getGroupOrder());
        copy.setProgramRecords(toCopy.getProgramRecords());
        copy.setReadGroups(toCopy.getReadGroups());
        copy.setSequenceDictionary(toCopy.getSequenceDictionary());
        for (Map.Entry<String, String> e : toCopy.getAttributes()) {
            copy.setAttribute(e.getKey(), e.getValue());
        }
        return copy;
    }
}

