/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Collection;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.ReadSelector;
import org.broadinstitute.sting.utils.ReservoirDownsampler;

class NRandomReadSelector
implements ReadSelector {
    private final ReservoirDownsampler<SAMRecord> reservoir;
    private final ReadSelector chainedSelector;
    private long readsSeen = 0L;
    private int downsamplingExtent = 0;

    public NRandomReadSelector(ReadSelector chainedSelector, long readLimit) {
        this.reservoir = new ReservoirDownsampler((int)readLimit);
        this.chainedSelector = chainedSelector;
    }

    @Override
    public void submitRead(SAMRecord read) {
        SAMRecord displaced = this.reservoir.add(read);
        if (displaced != null && this.chainedSelector != null) {
            this.chainedSelector.notifyReadRejected(read);
            this.downsamplingExtent = Math.max(this.downsamplingExtent, read.getAlignmentEnd());
        }
        ++this.readsSeen;
    }

    @Override
    public void notifyReadRejected(SAMRecord read) {
        ++this.readsSeen;
    }

    @Override
    public void complete() {
        for (SAMRecord read : this.reservoir.getDownsampledContents()) {
            this.chainedSelector.submitRead(read);
        }
        if (this.chainedSelector != null) {
            this.chainedSelector.complete();
        }
    }

    @Override
    public long getNumReadsSeen() {
        return this.readsSeen;
    }

    @Override
    public long getNumReadsSelected() {
        return this.reservoir.size();
    }

    @Override
    public int getDownsamplingExtent() {
        return this.downsamplingExtent;
    }

    @Override
    public Collection<SAMRecord> getSelectedReads() {
        return this.reservoir.getDownsampledContents();
    }

    @Override
    public void reset() {
        this.reservoir.clear();
        this.downsamplingExtent = 0;
        if (this.chainedSelector != null) {
            this.chainedSelector.reset();
        }
    }
}

