/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeSet;
import net.sf.picard.PicardException;
import net.sf.samtools.SAMException;
import org.broad.tribble.TribbleException;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.gatk.CommandLineExecutable;
import org.broadinstitute.sting.gatk.HelpEntry;
import org.broadinstitute.sting.gatk.HelpEntryComparator;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.arguments.GATKArgumentCollection;
import org.broadinstitute.sting.gatk.refdata.tracks.FeatureManager;
import org.broadinstitute.sting.gatk.walkers.Attribution;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.ApplicationDetails;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.help.GATKDocUtils;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;

@DocumentedGATKFeature(groupName="GATK Engine", summary="Features and arguments for the GATK engine itself, available to all walkers.", extraDocs={UserException.class})
public class CommandLineGATK
extends CommandLineExecutable {
    @Argument(fullName="analysis_type", shortName="T", doc="Type of analysis to run")
    private String analysisName = null;
    @ArgumentCollection
    private GATKArgumentCollection argCollection = new GATKArgumentCollection();
    private static final int PACKAGE_INDENT = 1;
    private static final int WALKER_INDENT = 3;
    private static final String FIELD_SEPARATOR = "  ";

    @Override
    protected ApplicationDetails getApplicationDetails() {
        return new ApplicationDetails(CommandLineGATK.createApplicationHeader(), this.getAttribution(), ApplicationDetails.createDefaultRunningInstructions(this.getClass()), this.getAdditionalHelp());
    }

    @Override
    public String getAnalysisName() {
        return this.analysisName;
    }

    @Override
    protected GATKArgumentCollection getArgumentCollection() {
        return this.argCollection;
    }

    public static void main(String[] argv) {
        try {
            CommandLineGATK instance = new CommandLineGATK();
            CommandLineGATK.start(instance, argv);
            System.exit(CommandLineProgram.result);
        }
        catch (UserException e) {
            CommandLineGATK.exitSystemWithUserError(e);
        }
        catch (TribbleException e) {
            CommandLineGATK.exitSystemWithUserError(e);
        }
        catch (PicardException e) {
            CommandLineGATK.exitSystemWithError(e);
        }
        catch (SAMException e) {
            CommandLineGATK.checkForTooManyOpenFilesProblem(e.getMessage());
            CommandLineGATK.exitSystemWithSamError(e);
        }
        catch (OutOfMemoryError e) {
            CommandLineGATK.exitSystemWithUserError(new UserException.NotEnoughMemory());
        }
        catch (Throwable t) {
            CommandLineGATK.checkForTooManyOpenFilesProblem(t.getMessage());
            CommandLineGATK.exitSystemWithError(t);
        }
    }

    private static void checkForTooManyOpenFilesProblem(String message) {
        if (message != null && message.indexOf("Too many open files") != -1) {
            CommandLineGATK.exitSystemWithUserError(new UserException.TooManyOpenFiles());
        }
    }

    public static List<String> createApplicationHeader() {
        ArrayList<String> header = new ArrayList<String>();
        header.add(String.format("The Genome Analysis Toolkit (GATK) v%s, Compiled %s", CommandLineGATK.getVersionNumber(), CommandLineGATK.getBuildTime()));
        header.add("Copyright (c) 2010 The Broad Institute");
        header.add("Please view our documentation at http://www.broadinstitute.org/gsa/wiki");
        header.add("For support, please view our support site at http://getsatisfaction.com/gsa");
        return header;
    }

    public static String getVersionNumber() {
        ResourceBundle headerInfo = TextFormattingUtils.loadResourceBundle("StingText");
        return headerInfo.containsKey("org.broadinstitute.sting.gatk.version") ? headerInfo.getString("org.broadinstitute.sting.gatk.version") : "<unknown>";
    }

    public static String getBuildTime() {
        ResourceBundle headerInfo = TextFormattingUtils.loadResourceBundle("StingText");
        return headerInfo.containsKey("build.timestamp") ? headerInfo.getString("build.timestamp") : "<unknown>";
    }

    private List<String> getAttribution() {
        Class<? extends Walker> walkerType;
        ArrayList<String> attributionLines = new ArrayList<String>();
        WalkerManager walkerManager = this.engine.getWalkerManager();
        String analysisName = this.getAnalysisName();
        if (analysisName != null && walkerManager.exists(analysisName) && (walkerType = walkerManager.getWalkerClassByName(analysisName)).isAnnotationPresent(Attribution.class)) {
            attributionLines.addAll(Arrays.asList(walkerType.getAnnotation(Attribution.class).value()));
        }
        return attributionLines;
    }

    private String getAdditionalHelp() {
        WalkerManager walkerManager = this.engine.getWalkerManager();
        String analysisName = this.getAnalysisName();
        String additionalHelp = analysisName != null && walkerManager.exists(this.getAnalysisName()) ? this.getWalkerHelp(walkerManager.getWalkerClassByName(this.getAnalysisName())) : this.getAllWalkerHelp();
        return additionalHelp;
    }

    private String getWalkerHelp(Class<? extends Walker> walkerType) {
        StringBuilder additionalHelp = new StringBuilder();
        Formatter formatter = new Formatter(additionalHelp);
        formatter.format("Available Reference Ordered Data types:%n", new Object[0]);
        formatter.format(new FeatureManager().userFriendlyListOfAvailableFeatures(), new Object[0]);
        formatter.format("%n", new Object[0]);
        formatter.format("For a full description of this walker, see its GATKdocs at:%n", new Object[0]);
        formatter.format("%s%n", GATKDocUtils.helpLinksToGATKDocs(walkerType));
        return additionalHelp.toString();
    }

    private String getAllWalkerHelp() {
        StringBuilder additionalHelp = new StringBuilder();
        Formatter formatter = new Formatter(additionalHelp);
        WalkerManager walkerManager = this.engine.getWalkerManager();
        TreeSet<HelpEntry> helpText = new TreeSet<HelpEntry>(new HelpEntryComparator());
        int longestPackageName = 0;
        int longestWalkerName = 0;
        for (Map.Entry<String, Collection<Class<? extends Walker>>> walkersByPackage : walkerManager.getWalkerNamesByPackage(true).entrySet()) {
            String packageName = walkersByPackage.getKey();
            String packageDisplayName = walkerManager.getPackageDisplayName(walkersByPackage.getKey());
            String packageHelpText = walkerManager.getPackageSummaryText(packageName);
            longestPackageName = Math.max(longestPackageName, packageDisplayName.length());
            TreeSet<HelpEntry> walkersInPackage = new TreeSet<HelpEntry>(new HelpEntryComparator());
            for (Class<? extends Walker> walkerType : walkersByPackage.getValue()) {
                String walkerName = walkerType.getName();
                String walkerDisplayName = walkerManager.getName(walkerType);
                String walkerHelpText = walkerManager.getWalkerSummaryText(walkerType);
                longestWalkerName = Math.max(longestWalkerName, walkerManager.getName(walkerType).length());
                walkersInPackage.add(new HelpEntry(walkerName, walkerDisplayName, walkerHelpText));
            }
            helpText.add(new HelpEntry(packageName, packageDisplayName, packageHelpText, Collections.unmodifiableSortedSet(walkersInPackage)));
        }
        int headerWidth = Math.max(longestPackageName + 1, longestWalkerName + 3);
        for (HelpEntry packageHelp : helpText) {
            this.printDescriptorLine(formatter, 1, packageHelp.displayName, headerWidth, FIELD_SEPARATOR, packageHelp.summary, 120);
            for (HelpEntry walkerHelp : packageHelp.children) {
                this.printDescriptorLine(formatter, 3, walkerHelp.displayName, headerWidth, FIELD_SEPARATOR, walkerHelp.summary, 120);
            }
            this.printDescriptorLine(formatter, 0, "", headerWidth, FIELD_SEPARATOR, "", 120);
        }
        return additionalHelp.toString();
    }

    private void printDescriptorLine(Formatter formatter, int headerIndentWidth, String header, int headerWidth, String fieldSeparator, String description, int lineWidth) {
        int headerPaddingWidth = headerWidth - header.length() - headerIndentWidth;
        int descriptionWidth = lineWidth - fieldSeparator.length() - headerWidth;
        List<String> wordWrappedText = TextFormattingUtils.wordWrap(description, descriptionWidth);
        String headerIndentFormatString = headerIndentWidth > 0 ? "%" + headerIndentWidth + "s" : "%s";
        String headerPaddingFormatString = headerPaddingWidth > 0 ? "%" + headerPaddingWidth + "s" : "%s";
        String headerWidthFormatString = headerWidth > 0 ? "%" + headerWidth + "s" : "%s";
        formatter.format(headerIndentFormatString + "%s" + headerPaddingFormatString + "%s%s%n", "", header, "", fieldSeparator, wordWrappedText.size() > 0 ? wordWrappedText.get(0) : "");
        for (int i = 1; i < wordWrappedText.size(); ++i) {
            formatter.format(headerWidthFormatString + "%s%s%n", "", fieldSeparator, wordWrappedText.get(i));
        }
    }
}

