/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.filter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import net.sf.picard.PicardException;
import net.sf.picard.filter.SamRecordFilter;
import net.sf.picard.io.IoUtil;
import net.sf.samtools.SAMRecord;

public class ReadNameFilter
implements SamRecordFilter {
    private boolean includeReads = false;
    private Set<String> readNameFilterSet = new HashSet<String>();

    public ReadNameFilter(File readNameFilterFile, boolean includeReads) {
        BufferedReader is;
        IoUtil.assertFileIsReadable(readNameFilterFile);
        IoUtil.assertFileSizeNonZero(readNameFilterFile);
        try {
            is = IoUtil.openFileForBufferedReading(readNameFilterFile);
        }
        catch (IOException e) {
            throw new PicardException(e.getMessage(), e);
        }
        Scanner scanner = new Scanner(is);
        while (scanner.hasNext()) {
            String line = scanner.nextLine();
            if (line.trim().isEmpty()) continue;
            this.readNameFilterSet.add(line.split("\\s+")[0]);
        }
        scanner.close();
        this.includeReads = includeReads;
    }

    public ReadNameFilter(Set<String> readNameFilterSet, boolean includeReads) {
        this.readNameFilterSet = readNameFilterSet;
        this.includeReads = includeReads;
    }

    @Override
    public boolean filterOut(SAMRecord record) {
        return !(this.includeReads ? this.readNameFilterSet.contains(record.getReadName()) : !this.readNameFilterSet.contains(record.getReadName()));
    }

    public boolean filterOut(SAMRecord first, SAMRecord second) {
        return !(this.includeReads ? this.readNameFilterSet.contains(first.getReadName()) && this.readNameFilterSet.contains(second.getReadName()) : !this.readNameFilterSet.contains(first.getReadName()) && !this.readNameFilterSet.contains(second.getReadName()));
    }
}

