/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.caller;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Map;
import net.sf.samtools.SAMRecord;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.rbio.methyl.rrbs.caller.RecordReader;
import org.rbio.methyl.rrbs.caller.UniqueFilter;
import org.rbio.methyl.rrbs.util.Fragment;
import org.rbio.methyl.rrbs.util.MethylTable;

public class MethylCaller {
    @Option(name="-in_fq1", usage="input fastq end 1", required=true)
    private String in_fq1;
    @Option(name="-in_fq2", usage="input fastq end 2 [optional]", required=false)
    private String in_fq2 = null;
    @Option(name="-in_bam", usage="input paired end BAM file", required=true)
    private String in_bam;
    @Option(name="-frag_fa", usage="fragment fasta file [not bisulfite converted] ", required=true)
    private String ref_fa;
    @Option(name="-out_prefix", usage="output file prefix", required=true)
    private String out_prefix;
    Map<String, Fragment> frag_tab = null;

    public static void main(String[] args) throws Exception {
        MethylCaller call = new MethylCaller();
        CmdLineParser parser = new CmdLineParser(call);
        try {
            parser.parseArgument(args);
            call.process();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Call the C status on an RRBS sam/bam file");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        this.frag_tab = Fragment.read(this.ref_fa);
        this.call();
        this.collate();
    }

    public void call() throws Exception {
        BufferedWriter obuf = new BufferedWriter(new FileWriter(String.valueOf(this.out_prefix) + ".stat.txt"));
        RecordReader reader = new RecordReader(this.in_bam, this.in_fq1, this.in_fq2);
        int cntr = 0;
        RecordReader.ReadAlignment read_al = null;
        while ((read_al = reader.getNextReadAlignment()) != null) {
            UniqueFilter.UniqueRecord uniq_rec = null;
            uniq_rec = this.in_fq2 == null ? UniqueFilter.getUniqueSERecord(read_al.rec_lst1, this.frag_tab) : UniqueFilter.getUniquePERecord(read_al.rec_lst1, read_al.rec_lst2, this.frag_tab);
            if (uniq_rec != null) {
                MethylCaller.addStats(uniq_rec.rec1, read_al.read_info.read1, true, this.frag_tab.get(uniq_rec.rec1.getReferenceName()), obuf);
                if (this.in_fq2 != null) {
                    MethylCaller.addStats(uniq_rec.rec2, read_al.read_info.read2, false, this.frag_tab.get(uniq_rec.rec1.getReferenceName()), obuf);
                }
            }
            if (++cntr % 100000 != 0) continue;
            System.out.println("Step 1 : " + cntr);
        }
        obuf.close();
        System.out.println("done!");
    }

    public static void addStats(SAMRecord rec, String read_str, boolean is_first, Fragment frag, BufferedWriter obuf) throws Exception {
        int end;
        int read_len = rec.getReadLength();
        int start = 0;
        int n = end = frag.length() >= read_len ? read_len - 1 : frag.length() - 1;
        if (!is_first) {
            end = frag.length() - 1;
            int n2 = start = end - read_len + 1 >= read_len ? end - read_len + 1 : read_len;
        }
        if (is_first) {
            obuf.write("#\t" + rec.getReadName() + "/1" + "\t" + frag.getHeader() + "\n");
        } else {
            obuf.write("#\t" + rec.getReadName() + "/2" + "\t" + frag.getHeader() + "\n");
        }
        for (int pos : frag.getCList()) {
            if (pos < start || pos > end) continue;
            char bp = '$';
            if (is_first) {
                bp = read_str.charAt(pos);
            } else {
                bp = read_str.charAt(frag.length() - pos - 1);
                switch (bp) {
                    case 'G': {
                        bp = 'C';
                        break;
                    }
                    case 'C': {
                        bp = 'G';
                        break;
                    }
                    case 'A': {
                        bp = 'T';
                        break;
                    }
                    case 'T': {
                        bp = 'A';
                    }
                }
            }
            obuf.write(String.valueOf(pos) + "\t" + bp + "\n");
        }
        obuf.write("*\n");
    }

    public void collate() throws Exception {
        Map<String, Map<Character, Map<Integer, MethylTable.CpG>>> cpg_tab = MethylTable.build(this.frag_tab, String.valueOf(this.out_prefix) + ".stat.txt");
        MethylTable.write(cpg_tab, this.frag_tab, String.valueOf(this.out_prefix) + ".meth.txt");
    }
}

