/*
 * Decompiled with CFR 0.152.
 */
package org.ggf.drmaa;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.ggf.drmaa.Session;

public abstract class SessionFactory {
    private static SessionFactory thisFactory = null;
    private static final String SESSION_PROPERTY = "org.ggf.drmaa.SessionFactory";

    public abstract Session getSession();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionFactory getFactory() {
        Class clazz = SessionFactory.class;
        synchronized (clazz) {
            if (thisFactory == null) {
                NewFactoryAction action = new NewFactoryAction();
                thisFactory = (SessionFactory)AccessController.doPrivileged(action);
            }
        }
        return thisFactory;
    }

    private static SessionFactory newFactory() throws ConfigurationError {
        ClassLoader classLoader = SessionFactory.findClassLoader();
        Exception e = null;
        try {
            String systemProp = System.getProperty(SESSION_PROPERTY);
            if (systemProp != null) {
                return (SessionFactory)SessionFactory.newInstance(systemProp, classLoader);
            }
        }
        catch (SecurityException se) {
            e = se;
        }
        try {
            String javah = System.getProperty("java.home");
            String configFile = javah + File.separator + "lib" + File.separator + "drmaa.properties";
            File f = new File(configFile);
            if (f.exists()) {
                Properties props = new Properties();
                props.load(new FileInputStream(f));
                String className = props.getProperty(SESSION_PROPERTY);
                return (SessionFactory)SessionFactory.newInstance(className, classLoader);
            }
        }
        catch (SecurityException se) {
            e = se;
        }
        catch (IOException ie) {
            e = ie;
        }
        String serviceId = "META-INF/services/org.ggf.drmaa.SessionFactory";
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String className = rd.readLine();
                rd.close();
                if (className != null && !className.equals("")) {
                    return (SessionFactory)SessionFactory.newInstance(className, classLoader);
                }
            }
        }
        catch (Exception ex) {
            e = ex;
        }
        throw new ConfigurationError("Provider for org.ggf.drmaa.SessionFactory cannot be found", e);
    }

    private static ClassLoader findClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (LinkageError le) {
            classLoader = SessionFactory.class.getClassLoader();
        }
        catch (Exception ex) {
            throw new ConfigurationError(ex.toString(), ex);
        }
        return classLoader;
    }

    private static Object newInstance(String className, ClassLoader classLoader) throws ConfigurationError {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new ConfigurationError("Provider " + className + " not found", ex);
        }
        catch (Exception ex) {
            throw new ConfigurationError("Provider " + className + " could not be instantiated: " + ex, ex);
        }
    }

    private static class NewFactoryAction
    implements PrivilegedAction {
        private NewFactoryAction() {
        }

        public Object run() {
            return SessionFactory.newFactory();
        }
    }

    private static class ConfigurationError
    extends Error {
        private Exception exception;

        ConfigurationError(String msg, Exception ex) {
            super(msg);
            this.exception = ex;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

