/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.gcf;

import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.utils.gcf.GCFHeader;
import org.broadinstitute.sting.utils.variantcontext.Allele;

public class GCFHeaderBuilder {
    Map<Allele, Integer> alleles = new HashMap<Allele, Integer>();
    Map<String, Integer> strings = new HashMap<String, Integer>();
    Map<String, Integer> samples = new HashMap<String, Integer>();

    public GCFHeader createHeader() {
        return new GCFHeader(this.alleles, this.strings, this.samples);
    }

    public int encodeString(String chr) {
        return this.encode(this.strings, chr);
    }

    public int encodeAllele(Allele allele) {
        return this.encode(this.alleles, allele);
    }

    public int encodeSample(String sampleName) {
        return this.encode(this.samples, sampleName);
    }

    private <T> int encode(Map<T, Integer> map, T key) {
        Integer v = map.get(key);
        if (v == null) {
            v = map.size();
            map.put(key, v);
        }
        return v;
    }
}

