/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.table;

import java.util.Arrays;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.gatk.refdata.ReferenceDependentFeatureCodec;
import org.broadinstitute.sting.utils.codecs.table.TableCodec;
import org.broadinstitute.sting.utils.codecs.table.TableFeature;

public class BedTableCodec
extends TableCodec
implements ReferenceDependentFeatureCodec {
    @Override
    public Feature decode(String line) {
        if (line.startsWith("HEADER") || line.startsWith("#") || line.startsWith("track")) {
            return null;
        }
        String[] split = line.split("\\s+");
        if (split.length < 1) {
            throw new IllegalArgumentException("TableCodec line = " + line + " doesn't appear to be a valid table format");
        }
        return new TableFeature(this.genomeLocParser.createGenomeLoc(split[0], Integer.parseInt(split[1]) - 1, Integer.parseInt(split[2])), Arrays.asList(split), this.header);
    }
}

