/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.annotator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.ActiveRegionBasedAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatibleWalker;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.InfoFieldAnnotation;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.StandardAnnotation;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFInfoHeaderLine;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class QualByDepth
extends InfoFieldAnnotation
implements StandardAnnotation,
ActiveRegionBasedAnnotation {
    @Override
    public Map<String, Object> annotate(RefMetaDataTracker tracker, AnnotatorCompatibleWalker walker, ReferenceContext ref, Map<String, AlignmentContext> stratifiedContexts, VariantContext vc) {
        if (!vc.hasLog10PError() || stratifiedContexts.size() == 0) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        int depth = 0;
        for (Genotype genotype : genotypes) {
            AlignmentContext context;
            if (!genotype.isHet() && !genotype.isHomVar() || (context = stratifiedContexts.get(genotype.getSampleName())) == null) continue;
            depth += context.hasBasePileup() ? context.getBasePileup().depthOfCoverage() : 0;
        }
        if (depth == 0) {
            return null;
        }
        double QD = -10.0 * vc.getLog10PError() / (double)depth;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", QD));
        return map;
    }

    @Override
    public List<String> getKeyNames() {
        return Arrays.asList("QD");
    }

    @Override
    public List<VCFInfoHeaderLine> getDescriptions() {
        return Arrays.asList(new VCFInfoHeaderLine(this.getKeyNames().get(0), 1, VCFHeaderLineType.Float, "Variant Confidence/Quality by Depth"));
    }

    @Override
    public Map<String, Object> annotate(Map<String, Map<Allele, List<GATKSAMRecord>>> stratifiedContexts, VariantContext vc) {
        if (stratifiedContexts.size() == 0) {
            return null;
        }
        GenotypesContext genotypes = vc.getGenotypes();
        if (genotypes == null || genotypes.size() == 0) {
            return null;
        }
        int depth = 0;
        for (Genotype genotype : genotypes) {
            Map<Allele, List<GATKSAMRecord>> alleleBins;
            if (!genotype.isHet() && !genotype.isHomVar() || (alleleBins = stratifiedContexts.get(genotype.getSampleName())) == null) continue;
            for (Map.Entry<Allele, List<GATKSAMRecord>> alleleBin : alleleBins.entrySet()) {
                if (alleleBin.getKey().equals(Allele.NO_CALL)) continue;
                depth += alleleBin.getValue().size();
            }
        }
        if (depth == 0) {
            return null;
        }
        double QD = -10.0 * vc.getLog10PError() / (double)depth;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(this.getKeyNames().get(0), String.format("%.2f", QD));
        return map;
    }
}

