/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.io.File;
import java.util.Iterator;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.util.CloseableIterator;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class MalformedBAMErrorReformatingIterator
implements CloseableIterator<SAMRecord> {
    File source;
    CloseableIterator<SAMRecord> it;

    public MalformedBAMErrorReformatingIterator(File source, CloseableIterator<SAMRecord> it) {
        this.it = it;
        this.source = source;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.it.hasNext();
        }
        catch (RuntimeException e) {
            throw new UserException.MalformedBAM(this.source, e.getMessage());
        }
    }

    @Override
    public SAMRecord next() {
        try {
            return (SAMRecord)this.it.next();
        }
        catch (RuntimeException e) {
            throw new UserException.MalformedBAM(this.source, e.getMessage());
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove records from a SAM file via an iterator!");
    }

    @Override
    public void close() {
        this.it.close();
    }

    public Iterator<SAMRecord> iterator() {
        return this;
    }
}

