/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.illumina.parser;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import net.sf.picard.PicardException;
import net.sf.picard.illumina.parser.IlluminaData;
import net.sf.picard.illumina.parser.IlluminaFileMap;
import net.sf.picard.illumina.parser.IlluminaParser;
import net.sf.samtools.util.CloseableIterator;
import net.sf.samtools.util.StringUtil;

public abstract class PerTileParser<ILLUMINA_DATA extends IlluminaData>
implements IlluminaParser<ILLUMINA_DATA> {
    private final IlluminaFileMap tileToFiles;
    private CloseableIterator<ILLUMINA_DATA> currentIterator;
    private Integer nextTile;
    private Integer currentTile;

    protected abstract CloseableIterator<ILLUMINA_DATA> makeTileIterator(File var1);

    public PerTileParser(IlluminaFileMap tilesToFiles) {
        this.tileToFiles = tilesToFiles;
        this.nextTile = (Integer)tilesToFiles.firstKey();
        this.currentTile = null;
    }

    public PerTileParser(IlluminaFileMap tilesToFiles, int nextTile) {
        this.tileToFiles = tilesToFiles;
        this.currentTile = null;
        this.nextTile = nextTile;
        if (!tilesToFiles.containsKey(nextTile)) {
            throw new IllegalArgumentException("NextTile (" + nextTile + ") is not contained by tilesToFiles (" + StringUtil.join(",", new ArrayList(tilesToFiles.keySet())));
        }
    }

    @Override
    public int getTileOfNextCluster() {
        this.maybeAdvance();
        return this.currentTile;
    }

    private void advanceTile() {
        if (this.nextTile == null) {
            throw new NoSuchElementException("No more tiles to advance!");
        }
        if (this.currentIterator != null) {
            this.currentIterator.close();
        }
        this.currentIterator = this.makeTileIterator((File)this.tileToFiles.get(this.nextTile));
        this.currentTile = this.nextTile;
        this.nextTile = this.tileToFiles.higherKey(this.nextTile);
    }

    @Override
    public void seekToTile(int oneBasedTileNumber) {
        this.nextTile = oneBasedTileNumber;
        if (!this.tileToFiles.containsKey(oneBasedTileNumber)) {
            throw new PicardException("PerTileParser does not contain key(" + oneBasedTileNumber + ") keys available (" + StringUtil.join(",", new ArrayList(this.tileToFiles.keySet())) + ")");
        }
        if (this.currentIterator != null) {
            this.currentIterator.close();
        }
        this.currentIterator = null;
    }

    public void maybeAdvance() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            this.advanceTile();
        }
    }

    @Override
    public ILLUMINA_DATA next() {
        this.maybeAdvance();
        return (ILLUMINA_DATA)((IlluminaData)this.currentIterator.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasNext() {
        return this.nextTile != null || this.currentIterator != null && this.currentIterator.hasNext();
    }

    public void close() {
        if (this.currentIterator != null) {
            this.currentIterator.close();
        }
    }

    @Override
    public void verifyData(List<Integer> tiles, int[] cycles) {
        ArrayList mapTiles = new ArrayList(this.tileToFiles.keySet());
        if (!mapTiles.containsAll(tiles)) {
            throw new PicardException("Missing tiles in PerTileParser expected(" + StringUtil.join(",", tiles) + ") but found (" + StringUtil.join(",", mapTiles) + ")");
        }
        if (!tiles.containsAll(mapTiles)) {
            throw new PicardException("Extra tiles where found in PerTileParser  expected(" + StringUtil.join(",", tiles) + ") but found (" + StringUtil.join(",", mapTiles) + ")");
        }
    }
}

