/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.rna.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeSet;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class MergeHtseq {
    @Option(name="-config", usage="configuration file", required=true)
    private String config;
    @Option(name="-ofile", usage="output file", required=true)
    private String ofile;

    public static void main(String[] args) throws Exception {
        MergeHtseq cuff = new MergeHtseq();
        CmdLineParser parser = new CmdLineParser(cuff);
        try {
            parser.parseArgument(args);
            cuff.process();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Join htseq result from several samples\nconfiguration file format [first line is header]\nsamp file\nMAKE SURE THERE ARE SAME NUMBER OF GENES IN ALL FILES");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        ArrayList<String> samp_lst = new ArrayList<String>();
        LinkedHashMap htseq_tab = new LinkedHashMap();
        TreeSet<String> extra_set = new TreeSet<String>();
        extra_set.add("no_feature");
        extra_set.add("ambiguous");
        extra_set.add("too_low_aQual");
        extra_set.add("not_aligned");
        extra_set.add("alignment_not_unique");
        boolean is_first_samp = true;
        BufferedReader ibuf = new BufferedReader(new FileReader(this.config));
        String line = ibuf.readLine();
        while ((line = ibuf.readLine()) != null) {
            String[] arr = line.split("\t");
            String samp = arr[0];
            String samp_file = arr[1];
            System.out.println(String.valueOf(samp) + "\t" + (String)samp_file);
            BufferedReader sbuf = new BufferedReader(new FileReader(samp_file));
            String sline = sbuf.readLine();
            while ((sline = sbuf.readLine()) != null) {
                String[] sarr = sline.split("\t");
                String gene = sarr[0];
                if (extra_set.contains(gene)) break;
                HtseqCount htseq = new HtseqCount(Integer.parseInt(sarr[1]));
                List<HtseqCount> lst = null;
                if (is_first_samp) {
                    lst = new ArrayList();
                    htseq_tab.put(gene, lst);
                } else if (htseq_tab.containsKey(gene)) {
                    lst = (List)htseq_tab.get(gene);
                } else {
                    System.out.println("Gene in sample not seen : " + samp + "\t" + gene);
                }
                lst.add(htseq);
            }
            sbuf.close();
            is_first_samp = false;
            samp_lst.add(samp);
        }
        ibuf.close();
        System.out.println("number of genes : " + htseq_tab.size());
        String header = "gene";
        for (String samp : samp_lst) {
            header = String.valueOf(header) + "\t" + samp;
        }
        BufferedWriter obuf = new BufferedWriter(new FileWriter(this.ofile));
        obuf.write(String.valueOf(header) + "\n");
        Iterator iterator = htseq_tab.keySet().iterator();
        while (iterator.hasNext()) {
            String gene;
            String res = gene = (String)iterator.next();
            for (HtseqCount htseq : (List)htseq_tab.get(gene)) {
                res = String.valueOf(res) + "\t" + htseq.count;
            }
            obuf.write(String.valueOf(res) + "\n");
        }
        obuf.close();
    }

    public static class HtseqCount {
        int count;

        public HtseqCount(int count) {
            this.count = count;
        }
    }
}

