/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.walkers.bqsr.BQSRKeyManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.Covariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.EventType;
import org.broadinstitute.sting.gatk.walkers.bqsr.QuantizationInfo;
import org.broadinstitute.sting.gatk.walkers.bqsr.ReadCovariates;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDatum;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationReport;
import org.broadinstitute.sting.utils.BitSetUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class BaseRecalibration {
    private QuantizationInfo quantizationInfo;
    private LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap;
    private ArrayList<Covariate> requestedCovariates = new ArrayList();

    public BaseRecalibration(File RECAL_FILE, int quantizationLevels) {
        RecalibrationReport recalibrationReport = new RecalibrationReport(RECAL_FILE);
        this.keysAndTablesMap = recalibrationReport.getKeysAndTablesMap();
        this.requestedCovariates = recalibrationReport.getRequestedCovariates();
        this.quantizationInfo = recalibrationReport.getQuantizationInfo();
        if (quantizationLevels == 0) {
            this.quantizationInfo.noQuantization();
        } else if (quantizationLevels > 0 && quantizationLevels != this.quantizationInfo.getQuantizationLevels()) {
            this.quantizationInfo.quantizeQualityScores(quantizationLevels);
        }
    }

    protected BaseRecalibration(QuantizationInfo quantizationInfo, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap, ArrayList<Covariate> requestedCovariates) {
        this.quantizationInfo = quantizationInfo;
        this.keysAndTablesMap = keysAndTablesMap;
        this.requestedCovariates = requestedCovariates;
    }

    public void recalibrateRead(GATKSAMRecord read) {
        ReadCovariates readCovariates = RecalDataManager.computeCovariates(read, this.requestedCovariates);
        for (EventType errorModel : EventType.values()) {
            byte[] originalQuals = read.getBaseQualities(errorModel);
            byte[] recalQuals = (byte[])originalQuals.clone();
            for (int offset = 0; offset < read.getReadLength(); ++offset) {
                byte qualityScore = originalQuals[offset];
                if (qualityScore >= 6) {
                    BitSet[] keySet = readCovariates.getKeySet(offset, errorModel);
                    qualityScore = this.performSequentialQualityCalculation(keySet, errorModel);
                }
                recalQuals[offset] = qualityScore;
            }
            read.setBaseQualities(recalQuals, errorModel);
        }
    }

    protected byte performSequentialQualityCalculation(BitSet[] key, EventType errorModel) {
        String UNRECOGNIZED_REPORT_TABLE_EXCEPTION = "Unrecognized table. Did you add an extra required covariate? This is a hard check that needs propagate through the code";
        String TOO_MANY_KEYS_EXCEPTION = "There should only be one key for the RG collapsed table, something went wrong here";
        byte qualFromRead = (byte)BitSetUtils.shortFrom(key[1]);
        double globalDeltaQ = 0.0;
        double deltaQReported = 0.0;
        double deltaQCovariates = 0.0;
        block4: for (Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> mapEntry : this.keysAndTablesMap.entrySet()) {
            BQSRKeyManager keyManager = mapEntry.getKey();
            Map<BitSet, RecalDatum> table = mapEntry.getValue();
            switch (keyManager.getRequiredCovariates().size()) {
                case 1: {
                    List<BitSet> bitKeys = keyManager.bitSetsFromAllKeys(key, errorModel);
                    if (bitKeys.size() > 1) {
                        throw new ReviewedStingException("There should only be one key for the RG collapsed table, something went wrong here");
                    }
                    RecalDatum empiricalQualRG = table.get(bitKeys.get(0));
                    if (empiricalQualRG == null) continue block4;
                    double globalDeltaQEmpirical = empiricalQualRG.getEmpiricalQuality();
                    double aggregrateQReported = empiricalQualRG.getEstimatedQReported();
                    globalDeltaQ = globalDeltaQEmpirical - aggregrateQReported;
                    break;
                }
                case 2: {
                    List<BitSet> bitKeys;
                    if (keyManager.getOptionalCovariates().isEmpty()) {
                        bitKeys = keyManager.bitSetsFromAllKeys(key, errorModel);
                        if (bitKeys.size() > 1) {
                            throw new ReviewedStingException("There should only be one key for the RG collapsed table, something went wrong here");
                        }
                        RecalDatum empiricalQualQS = table.get(bitKeys.get(0));
                        if (empiricalQualQS == null) continue block4;
                        double deltaQReportedEmpirical = empiricalQualQS.getEmpiricalQuality();
                        deltaQReported = deltaQReportedEmpirical - (double)qualFromRead - globalDeltaQ;
                        break;
                    }
                    bitKeys = keyManager.bitSetsFromAllKeys(key, errorModel);
                    for (BitSet k : bitKeys) {
                        RecalDatum empiricalQualCO = table.get(k);
                        if (empiricalQualCO == null) continue;
                        double deltaQCovariateEmpirical = empiricalQualCO.getEmpiricalQuality();
                        deltaQCovariates += deltaQCovariateEmpirical - (double)qualFromRead - (globalDeltaQ + deltaQReported);
                    }
                    continue block4;
                }
                default: {
                    throw new ReviewedStingException("Unrecognized table. Did you add an extra required covariate? This is a hard check that needs propagate through the code");
                }
            }
        }
        double recalibratedQual = (double)qualFromRead + globalDeltaQ + deltaQReported + deltaQCovariates;
        recalibratedQual = QualityUtils.boundQual((int)Math.round(recalibratedQual), (byte)93);
        return this.quantizationInfo.getQuantizedQuals().get((int)recalibratedQual);
    }
}

