/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class OneBPIndel
extends VariantStratifier {
    private static final List<Object> ALL = Arrays.asList("all", "one.bp", "two.plus.bp");
    private static final List<Object> ONE_BP = Arrays.asList("all", "one.bp");
    private static final List<Object> TWO_PLUS_BP = Arrays.asList("all", "two.plus.bp");

    @Override
    public void initialize() {
        this.states.addAll(ALL);
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (eval != null && eval.isIndel()) {
            for (int l : eval.getIndelLengths()) {
                if (Math.abs(l) <= 1) continue;
                return TWO_PLUS_BP;
            }
            return ONE_BP;
        }
        return ALL;
    }
}

