/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.executive.OutputMergeTask;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.storage.Storage;
import org.broadinstitute.sting.gatk.io.storage.StorageFactory;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class ThreadLocalOutputTracker
extends OutputTracker {
    private ThreadLocal<Map<Stub, Storage>> storage = new ThreadLocal();
    private boolean bypass = false;

    public void bypassThreadLocalStorage(boolean bypass) {
        this.bypass = bypass;
    }

    @Override
    public <T> T getStorage(Stub<T> stub) {
        Storage<T> target;
        if (this.bypass) {
            target = (Storage<T>)this.outputs.get(stub);
            if (target == null) {
                target = StorageFactory.createStorage(stub);
                this.outputs.put(stub, target);
            }
        } else {
            Map<Stub, Storage> threadLocalOutputStreams = this.storage.get();
            if (threadLocalOutputStreams == null) {
                threadLocalOutputStreams = new HashMap<Stub, Storage>();
                this.storage.set(threadLocalOutputStreams);
            }
            if ((target = threadLocalOutputStreams.get(stub)) == null) {
                target = StorageFactory.createStorage(stub, this.createTempFile(stub));
                threadLocalOutputStreams.put(stub, target);
            }
        }
        return (T)target;
    }

    public OutputMergeTask closeStorage() {
        Map<Stub, Storage> threadLocalOutputStreams = this.storage.get();
        if (threadLocalOutputStreams == null || threadLocalOutputStreams.isEmpty()) {
            return null;
        }
        OutputMergeTask outputMergeTask = new OutputMergeTask();
        for (Map.Entry<Stub, Storage> entry : threadLocalOutputStreams.entrySet()) {
            Stub stub = entry.getKey();
            Storage storageEntry = entry.getValue();
            storageEntry.close();
            outputMergeTask.addMergeOperation(this.getTargetStream(stub), storageEntry);
        }
        threadLocalOutputStreams.clear();
        return outputMergeTask;
    }

    private <T> File createTempFile(Stub<T> stub) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(stub.getClass().getName(), null);
            tempFile.deleteOnExit();
        }
        catch (IOException ex) {
            throw new UserException.BadTmpDir("Unable to create temporary file for stub: " + stub.getClass().getName());
        }
        return tempFile;
    }
}

