/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads.utilities;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import net.sf.samtools.BAMIndex;
import net.sf.samtools.SAMFileReader;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.CommandLineProgram;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.instrumentation.Sizeof;

public class BAMFileStat
extends CommandLineProgram {
    @Argument(doc="Which operation to run.", required=true)
    private CommandType command;
    @Argument(doc="The BAM file to inspect.", required=true)
    private String bamFileName;
    @Argument(doc="The range to inspect.", required=false)
    private String range;

    @Override
    public int execute() {
        switch (this.command) {
            case ShowBlocks: {
                throw new ReviewedStingException("The BAM block inspector has been disabled.");
            }
            case ShowIndex: {
                this.showIndexBins(new File(this.bamFileName), this.range);
            }
        }
        return 0;
    }

    public static void main(String[] argv) {
        try {
            BAMFileStat instance = new BAMFileStat();
            BAMFileStat.start(instance, argv);
            System.exit(CommandLineProgram.result);
        }
        catch (Exception e) {
            BAMFileStat.exitSystemWithError(e);
        }
    }

    private void showIndexBins(File bamFile, String contigName) {
        SAMFileReader reader = new SAMFileReader(bamFile);
        reader.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        reader.enableIndexCaching(true);
        BAMIndex index = reader.getIndex();
        reader.queryOverlapping(contigName, 1, reader.getFileHeader().getSequence(contigName).getSequenceLength()).close();
        int numBins = 0;
        int numChunks = 0;
        int numLinearIndexEntries = 0;
        try {
            Field[] fields;
            for (Field field : fields = index.getClass().getDeclaredFields()) {
                if (field.getName().equals("mLastReferenceRetrieved")) {
                    field.setAccessible(true);
                    Integer lastReferenceRetrieved = (Integer)field.get(index);
                    System.out.printf("Last reference retrieved: %d%n", lastReferenceRetrieved);
                }
                if (!field.getName().equals("mQueriesByReference")) continue;
                field.setAccessible(true);
                Map cachedQueries = (Map)field.get(index);
                for (Object bamIndexContent : cachedQueries.values()) {
                    Field[] linearIndexFields;
                    Field[] indexContentFields;
                    List bins = null;
                    Map binToChunkMap = null;
                    Object linearIndex = null;
                    for (Field indexContentField : indexContentFields = bamIndexContent.getClass().getDeclaredFields()) {
                        if (indexContentField.getName().equals("mReferenceSequence")) {
                            indexContentField.setAccessible(true);
                            System.out.printf("Reference sequence: %d%n", indexContentField.getInt(bamIndexContent));
                        }
                        if (indexContentField.getName().equals("mBins")) {
                            indexContentField.setAccessible(true);
                            bins = (List)indexContentField.get(bamIndexContent);
                        }
                        if (indexContentField.getName().equals("mBinToChunks")) {
                            indexContentField.setAccessible(true);
                            binToChunkMap = (Map)indexContentField.get(bamIndexContent);
                        }
                        if (!indexContentField.getName().equals("mLinearIndex")) continue;
                        indexContentField.setAccessible(true);
                        linearIndex = indexContentField.get(bamIndexContent);
                    }
                    numBins = bins.size();
                    for (Object bin : bins) {
                        Field[] binFields;
                        for (Field binField : binFields = bin.getClass().getDeclaredFields()) {
                            if (!binField.getName().equals("binNumber")) continue;
                            binField.setAccessible(true);
                            int binNumber = binField.getInt(bin);
                            List chunks = (List)binToChunkMap.get(bin);
                            System.out.printf("\tBin: %d, number of chunks: %d%n", binNumber, chunks.size());
                            for (Object chunk : chunks) {
                                System.out.printf("\t\tChunk: %s%n", chunk);
                            }
                            numChunks += chunks.size();
                        }
                    }
                    for (Field linearIndexField : linearIndexFields = linearIndex.getClass().getDeclaredFields()) {
                        if (!linearIndexField.getName().equals("mIndexEntries")) continue;
                        linearIndexField.setAccessible(true);
                        long[] linearIndexEntries = (long[])linearIndexField.get(linearIndex);
                        System.out.printf("\t\tIndex entries: %d", linearIndexEntries.length);
                        for (long indexEntry : linearIndexEntries) {
                            System.out.printf("%d,", indexEntry);
                        }
                        System.out.printf("%n", new Object[0]);
                        numLinearIndexEntries = linearIndexEntries.length;
                    }
                }
            }
        }
        catch (IllegalAccessException ex) {
            throw new ReviewedStingException("Unable to examine cached index", ex);
        }
        System.out.printf("%nOverall: %d bins, %d chunks, %d linear index entries", numBins, numChunks, numLinearIndexEntries);
        if (Sizeof.isEnabled()) {
            System.out.printf(", total index size in bytes: %d", Sizeof.getObjectGraphSize(index));
        }
        System.out.println();
        reader.close();
    }

    public static enum CommandType {
        ShowBlocks,
        ShowIndex;

    }
}

