/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.methyl.rrbs.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Map;
import java.util.TreeMap;
import org.rbio.methyl.rrbs.util.Fragment;

public class MethylTable {
    public static Map<String, Map<Character, Map<Integer, CpG>>> build(Map<String, Fragment> frag_tab, String ofname) throws Exception {
        TreeMap<String, Map<Character, Map<Integer, CpG>>> cpg_tab = new TreeMap<String, Map<Character, Map<Integer, CpG>>>();
        BufferedReader ibuf = new BufferedReader(new FileReader(ofname));
        String line = null;
        int cntr = 0;
        while ((line = ibuf.readLine()) != null) {
            String[] header = line.split("\t");
            Fragment frag = frag_tab.get(header[2]);
            if (++cntr % 100000 == 0) {
                System.out.println("Step 2 : " + cntr);
            }
            line = ibuf.readLine();
            while (line.charAt(0) != '*') {
                CpG cpg;
                TreeMap<Integer, CpG> strand_tab;
                String[] cpg_dat = line.split("\t");
                int frag_pos = Integer.parseInt(cpg_dat[0]);
                int genomic_pos = frag.genomicPos(frag_pos);
                TreeMap ref_tab = (TreeMap)cpg_tab.get(frag.getRef());
                if (ref_tab == null) {
                    ref_tab = new TreeMap();
                    cpg_tab.put(frag.getRef(), ref_tab);
                }
                if ((strand_tab = (TreeMap<Integer, CpG>)ref_tab.get(Character.valueOf(frag.getStrand()))) == null) {
                    strand_tab = new TreeMap<Integer, CpG>();
                    ref_tab.put(Character.valueOf(frag.getStrand()), strand_tab);
                }
                if ((cpg = (CpG)strand_tab.get(genomic_pos)) == null) {
                    cpg = new CpG(frag.context(frag_pos));
                    strand_tab.put(genomic_pos, cpg);
                }
                cpg.addRead(cpg_dat[1].charAt(0));
                line = ibuf.readLine();
            }
        }
        ibuf.close();
        return cpg_tab;
    }

    public static void write(Map<String, Map<Character, Map<Integer, CpG>>> cpg_tab, Map<String, Fragment> frag_tab, String ofname) throws Exception {
        BufferedWriter obuf = new BufferedWriter(new FileWriter(ofname));
        obuf.write("ref\tstrand\tpos\tcontext\tm_read\tn_read\terr_read\n");
        for (String ref : cpg_tab.keySet()) {
            Map<Character, Map<Integer, CpG>> ref_tab = cpg_tab.get(ref);
            for (Character strand : ref_tab.keySet()) {
                Map<Integer, CpG> strand_tab = ref_tab.get(strand);
                for (Integer pos : strand_tab.keySet()) {
                    CpG cpg = strand_tab.get(pos);
                    if (!cpg.context.startsWith("CG")) continue;
                    obuf.write(String.valueOf(ref) + "\t" + strand + "\t" + pos + "\t" + cpg.context + "\t" + cpg.m_read + "\t" + cpg.n_read + "\t" + cpg.err_read + "\n");
                }
            }
        }
        obuf.close();
    }

    public static class CpG {
        private String context = "NA";
        private int m_read = 0;
        private int n_read = 0;
        private int err_read = 0;

        public CpG(String context) {
            this.context = context;
        }

        public void addRead(char bp) {
            switch (bp) {
                case 'C': {
                    ++this.m_read;
                    break;
                }
                case 'T': {
                    ++this.n_read;
                    break;
                }
                default: {
                    ++this.err_read;
                }
            }
        }

        public int mread() {
            return this.m_read;
        }

        public int nread() {
            return this.n_read;
        }

        public int errread() {
            return this.err_read;
        }

        public String context() {
            return this.context;
        }
    }
}

