/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.VariantEvalWalker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.RequiredStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.StandardStratification;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;
import org.broadinstitute.sting.utils.variantcontext.VariantContextUtils;

public class VariantEvalUtils {
    private final VariantEvalWalker variantEvalWalker;
    Logger logger;

    public VariantEvalUtils(VariantEvalWalker variantEvalWalker) {
        this.variantEvalWalker = variantEvalWalker;
        this.logger = variantEvalWalker.getLogger();
    }

    public void listModulesAndExit() {
        List<Class<VariantStratifier>> vsClasses = new PluginManager<VariantStratifier>(VariantStratifier.class).getPlugins();
        List<Class<VariantEvaluator>> veClasses = new PluginManager<VariantEvaluator>(VariantEvaluator.class).getPlugins();
        this.logger.info("Available stratification modules:");
        this.logger.info("(Standard modules are starred)");
        for (Class<VariantStratifier> clazz : vsClasses) {
            this.logger.info("\t" + clazz.getSimpleName() + (RequiredStratification.class.isAssignableFrom(clazz) || StandardStratification.class.isAssignableFrom(clazz) ? "*" : ""));
        }
        this.logger.info("");
        this.logger.info("Available evaluation modules:");
        this.logger.info("(Standard modules are starred)");
        for (Class<Comparable<VariantStratifier>> clazz : veClasses) {
            this.logger.info("\t" + clazz.getSimpleName() + (StandardEval.class.isAssignableFrom(clazz) ? "*" : ""));
        }
        this.logger.info("");
        System.exit(0);
    }

    public List<VariantStratifier> initializeStratificationObjects(boolean noStandardStrats, String[] modulesToUse) {
        TreeSet<VariantStratifier> strats = new TreeSet<VariantStratifier>();
        HashSet<String> stratsToUse = new HashSet<String>();
        HashMap<String, Class<VariantStratifier>> classMap = new HashMap<String, Class<VariantStratifier>>();
        for (Class<VariantStratifier> clazz : new PluginManager<VariantStratifier>(VariantStratifier.class).getPlugins()) {
            classMap.put(clazz.getSimpleName(), clazz);
        }
        for (Class<Object> clazz : new PluginManager<RequiredStratification>(RequiredStratification.class).getPlugins()) {
            if (!classMap.containsKey(clazz.getSimpleName())) continue;
            stratsToUse.add(clazz.getSimpleName());
        }
        if (!noStandardStrats) {
            for (Class<Object> clazz : new PluginManager<StandardStratification>(StandardStratification.class).getPlugins()) {
                if (!classMap.containsKey(clazz.getSimpleName())) continue;
                stratsToUse.add(clazz.getSimpleName());
            }
        }
        stratsToUse.addAll(Arrays.asList(modulesToUse));
        for (String string : stratsToUse) {
            if (!classMap.containsKey(string)) {
                throw new UserException.CommandLineException("Module " + string + " could not be found; please check that you have specified the class name correctly");
            }
            if (!classMap.containsKey(string)) continue;
            Class c = (Class)classMap.get(string);
            try {
                VariantStratifier vs = (VariantStratifier)c.newInstance();
                vs.setVariantEvalWalker(this.variantEvalWalker);
                vs.initialize();
                strats.add(vs);
            }
            catch (InstantiationException e) {
                throw new StingException("Unable to instantiate stratification module '" + c.getSimpleName() + "'");
            }
            catch (IllegalAccessException e) {
                throw new StingException("Illegal access error when trying to instantiate stratification module '" + c.getSimpleName() + "'");
            }
        }
        return new ArrayList<VariantStratifier>(strats);
    }

    public Set<Class<? extends VariantEvaluator>> initializeEvaluationObjects(boolean noStandardEvals, String[] modulesToUse) {
        HashSet<Class<? extends VariantEvaluator>> evals = new HashSet<Class<? extends VariantEvaluator>>();
        HashMap<String, Class<VariantEvaluator>> classMap = new HashMap<String, Class<VariantEvaluator>>();
        for (Class<VariantEvaluator> clazz : new PluginManager<VariantEvaluator>(VariantEvaluator.class).getPlugins()) {
            classMap.put(clazz.getSimpleName(), clazz);
        }
        if (!noStandardEvals) {
            for (Class<Object> clazz : new PluginManager<StandardEval>(StandardEval.class).getPlugins()) {
                if (!classMap.containsKey(clazz.getSimpleName())) continue;
                evals.add((Class<? extends VariantEvaluator>)classMap.get(clazz.getSimpleName()));
            }
        }
        for (String module : modulesToUse) {
            if (!classMap.containsKey(module)) {
                throw new UserException.CommandLineException("Module " + module + " could not be found; please check that you have specified the class name correctly");
            }
            if (!classMap.containsKey(module)) continue;
            evals.add((Class<? extends VariantEvaluator>)classMap.get(module));
        }
        return evals;
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, String sampleName) {
        return this.getSubsetOfVariantContext(vc, Collections.singleton(sampleName));
    }

    public VariantContext getSubsetOfVariantContext(VariantContext vc, Set<String> sampleNames) {
        int newAlleleCount;
        VariantContext vcsub = vc.subContextFromSamples(sampleNames, vc.getAlleles());
        VariantContextBuilder builder = new VariantContextBuilder(vcsub);
        int originalAlleleCount = vc.getHetCount() + 2 * vc.getHomVarCount();
        if (originalAlleleCount == (newAlleleCount = vcsub.getHetCount() + 2 * vcsub.getHomVarCount()) && newAlleleCount == 1) {
            builder.attribute("ISSINGLETON", true);
        }
        VariantContextUtils.calculateChromosomeCounts(builder, true);
        return builder.make();
    }

    public HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> bindVariantContexts(RefMetaDataTracker tracker, ReferenceContext ref, List<RodBinding<VariantContext>> tracks, boolean byFilter, boolean subsetBySample, boolean trackPerSample, boolean mergeTracks) {
        if (tracker == null) {
            return null;
        }
        HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>> bindings = new HashMap<RodBinding<VariantContext>, HashMap<String, Collection<VariantContext>>>();
        RodBinding<VariantContext> firstTrack = tracks.isEmpty() ? null : tracks.get(0);
        for (RodBinding<VariantContext> track : tracks) {
            HashMap<String, Collection<VariantContext>> mapping = new HashMap<String, Collection<VariantContext>>();
            Iterator<VariantContext> i$ = tracker.getValues(track, ref.getLocus()).iterator();
            while (i$.hasNext()) {
                VariantContext vc;
                VariantContext vcsub = vc = i$.next();
                if (subsetBySample && vc.hasGenotypes() && vc.hasGenotypes(this.variantEvalWalker.getSampleNamesForEvaluation())) {
                    vcsub = this.getSubsetOfVariantContext(vc, this.variantEvalWalker.getSampleNamesForEvaluation());
                }
                if (byFilter || !vcsub.isFiltered()) {
                    this.addMapping(mapping, VariantEvalWalker.getAllSampleName(), vcsub);
                }
                if (!vc.hasGenotypes() || !trackPerSample) continue;
                for (String sampleName : this.variantEvalWalker.getSampleNamesForEvaluation()) {
                    VariantContext samplevc = this.getSubsetOfVariantContext(vc, sampleName);
                    if (!byFilter && samplevc.isFiltered()) continue;
                    this.addMapping(mapping, sampleName, samplevc);
                }
            }
            if (mergeTracks && bindings.containsKey(firstTrack)) {
                HashMap<String, Collection<VariantContext>> firstMapping = bindings.get(firstTrack);
                for (Map.Entry elt : mapping.entrySet()) {
                    Collection<VariantContext> firstMappingSet = firstMapping.get(elt.getKey());
                    if (firstMappingSet != null) {
                        firstMappingSet.addAll((Collection)elt.getValue());
                        continue;
                    }
                    firstMapping.put((String)elt.getKey(), (Collection<VariantContext>)elt.getValue());
                }
                continue;
            }
            bindings.put(track, mapping);
        }
        return bindings;
    }

    private void addMapping(HashMap<String, Collection<VariantContext>> mappings, String sample, VariantContext vc) {
        if (!mappings.containsKey(sample)) {
            mappings.put(sample, new ArrayList(1));
        }
        mappings.get(sample).add(vc);
    }
}

