/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.bqsr.BQSRKeyManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.Covariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.EventType;
import org.broadinstitute.sting.gatk.walkers.bqsr.QuantizationInfo;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDataManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDatum;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class RecalibrationReport {
    private QuantizationInfo quantizationInfo;
    private final LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap;
    private final ArrayList<Covariate> requestedCovariates = new ArrayList();
    private final GATKReportTable argumentTable;
    private final RecalibrationArgumentCollection RAC;

    public RecalibrationReport(File RECAL_FILE) {
        Map<BitSet, RecalDatum> table;
        GATKReport report = new GATKReport(RECAL_FILE);
        this.argumentTable = report.getTable("Arguments");
        this.RAC = this.initializeArgumentCollectionTable(this.argumentTable);
        GATKReportTable quantizedTable = report.getTable("Quantized");
        this.quantizationInfo = this.initializeQuantizationTable(quantizedTable);
        Pair<ArrayList<Covariate>, ArrayList<Covariate>> covariates = RecalDataManager.initializeCovariates(this.RAC);
        ArrayList<Covariate> requiredCovariates = covariates.getFirst();
        ArrayList<Covariate> optionalCovariates = covariates.getSecond();
        this.requestedCovariates.addAll(requiredCovariates);
        this.requestedCovariates.addAll(optionalCovariates);
        for (Covariate cov : this.requestedCovariates) {
            cov.initialize(this.RAC);
        }
        this.keysAndTablesMap = new LinkedHashMap();
        ArrayList<Covariate> requiredCovariatesToAdd = new ArrayList<Covariate>(requiredCovariates.size());
        ArrayList<Covariate> optionalCovariatesToAdd = new ArrayList<Covariate>();
        for (Covariate covariate : requiredCovariates) {
            GATKReportTable reportTable;
            requiredCovariatesToAdd.add(covariate);
            BQSRKeyManager keyManager = new BQSRKeyManager(requiredCovariatesToAdd, optionalCovariatesToAdd);
            int nRequiredCovariates = requiredCovariatesToAdd.size();
            String UNRECOGNIZED_REPORT_TABLE_EXCEPTION = "Unrecognized table. Did you add an extra required covariate? This is a hard check.";
            if (nRequiredCovariates == 1) {
                reportTable = report.getTable("RecalTable0");
                table = this.parseReadGroupTable(keyManager, reportTable);
            } else if (nRequiredCovariates == 2 && optionalCovariatesToAdd.isEmpty()) {
                reportTable = report.getTable("RecalTable1");
                table = this.parseQualityScoreTable(keyManager, reportTable);
            } else {
                throw new ReviewedStingException("Unrecognized table. Did you add an extra required covariate? This is a hard check.");
            }
            this.keysAndTablesMap.put(keyManager, table);
        }
        BQSRKeyManager keyManager = new BQSRKeyManager(requiredCovariates, optionalCovariates);
        GATKReportTable reportTable = report.getTable("RecalTable2");
        table = this.parseAllCovariatesTable(keyManager, reportTable);
        this.keysAndTablesMap.put(keyManager, table);
    }

    protected RecalibrationReport(QuantizationInfo quantizationInfo, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap, GATKReportTable argumentTable, RecalibrationArgumentCollection RAC) {
        this.quantizationInfo = quantizationInfo;
        this.keysAndTablesMap = keysAndTablesMap;
        this.argumentTable = argumentTable;
        this.RAC = RAC;
    }

    public void combine(RecalibrationReport other) {
        Iterator<Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>>> thisIterator = this.keysAndTablesMap.entrySet().iterator();
        for (Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> otherEntry : other.getKeysAndTablesMap().entrySet()) {
            Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> thisEntry = thisIterator.next();
            Map<BitSet, RecalDatum> thisTable = thisEntry.getValue();
            BQSRKeyManager thisKeyManager = thisEntry.getKey();
            BQSRKeyManager otherKeyManager = otherEntry.getKey();
            for (Map.Entry<BitSet, RecalDatum> otherTableEntry : otherEntry.getValue().entrySet()) {
                RecalDatum otherDatum = otherTableEntry.getValue();
                BitSet otherBitKey = otherTableEntry.getKey();
                List<Object> otherObjectKey = otherKeyManager.keySetFrom(otherBitKey);
                BitSet thisBitKey = thisKeyManager.bitSetFromKey(otherObjectKey.toArray());
                RecalDatum thisDatum = thisTable.get(thisBitKey);
                if (thisDatum == null) {
                    thisTable.put(thisBitKey, otherDatum);
                    continue;
                }
                thisDatum.combine(otherDatum);
            }
        }
    }

    public QuantizationInfo getQuantizationInfo() {
        return this.quantizationInfo;
    }

    public LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> getKeysAndTablesMap() {
        return this.keysAndTablesMap;
    }

    public ArrayList<Covariate> getRequestedCovariates() {
        return this.requestedCovariates;
    }

    private Map<BitSet, RecalDatum> parseAllCovariatesTable(BQSRKeyManager keyManager, GATKReportTable reportTable) {
        ArrayList<String> columnNamesOrderedList = new ArrayList<String>(5);
        columnNamesOrderedList.add("ReadGroup");
        columnNamesOrderedList.add("QualityScore");
        columnNamesOrderedList.add("CovariateValue");
        columnNamesOrderedList.add("CovariateName");
        columnNamesOrderedList.add("EventType");
        return this.genericRecalTableParsing(keyManager, reportTable, columnNamesOrderedList, false);
    }

    private Map<BitSet, RecalDatum> parseQualityScoreTable(BQSRKeyManager keyManager, GATKReportTable reportTable) {
        ArrayList<String> columnNamesOrderedList = new ArrayList<String>(3);
        columnNamesOrderedList.add("ReadGroup");
        columnNamesOrderedList.add("QualityScore");
        columnNamesOrderedList.add("EventType");
        return this.genericRecalTableParsing(keyManager, reportTable, columnNamesOrderedList, false);
    }

    private Map<BitSet, RecalDatum> parseReadGroupTable(BQSRKeyManager keyManager, GATKReportTable reportTable) {
        ArrayList<String> columnNamesOrderedList = new ArrayList<String>(2);
        columnNamesOrderedList.add("ReadGroup");
        columnNamesOrderedList.add("EventType");
        return this.genericRecalTableParsing(keyManager, reportTable, columnNamesOrderedList, true);
    }

    private Map<BitSet, RecalDatum> genericRecalTableParsing(BQSRKeyManager keyManager, GATKReportTable reportTable, ArrayList<String> columnNamesOrderedList, boolean hasEstimatedQReportedColumn) {
        HashMap<BitSet, RecalDatum> result = new HashMap<BitSet, RecalDatum>(reportTable.getNumRows() * 2);
        for (Object primaryKey : reportTable.getPrimaryKeys()) {
            int nKeys = columnNamesOrderedList.size();
            Object[] keySet = new Object[nKeys];
            for (int i = 0; i < nKeys; ++i) {
                keySet[i] = reportTable.get(primaryKey, columnNamesOrderedList.get(i));
            }
            keySet[keySet.length - 1] = EventType.eventFrom((String)keySet[keySet.length - 1]);
            BitSet bitKey = keyManager.bitSetFromKey(keySet);
            long nObservations = (Long)reportTable.get(primaryKey, "Observations");
            long nErrors = (Long)reportTable.get(primaryKey, "Errors");
            double empiricalQuality = (Double)reportTable.get(primaryKey, "EmpiricalQuality");
            double estimatedQReported = hasEstimatedQReportedColumn ? (Double)reportTable.get(primaryKey, "EstimatedQReported") : (double)Byte.parseByte((String)reportTable.get(primaryKey, "QualityScore"));
            RecalDatum recalDatum = new RecalDatum(nObservations, nErrors, estimatedQReported, empiricalQuality);
            result.put(bitKey, recalDatum);
        }
        return result;
    }

    private QuantizationInfo initializeQuantizationTable(GATKReportTable table) {
        Byte[] quals = new Byte[94];
        Long[] counts = new Long[94];
        for (Object primaryKey : table.getPrimaryKeys()) {
            Object quantizedObject = table.get(primaryKey, "QuantizedScore");
            Object countObject = table.get(primaryKey, "Count");
            byte originalQual = Byte.parseByte(primaryKey.toString());
            byte quantizedQual = Byte.parseByte(quantizedObject.toString());
            long quantizedCount = Long.parseLong(countObject.toString());
            quals[originalQual] = quantizedQual;
            counts[originalQual] = quantizedCount;
        }
        return new QuantizationInfo(Arrays.asList(quals), Arrays.asList(counts));
    }

    private RecalibrationArgumentCollection initializeArgumentCollectionTable(GATKReportTable table) {
        RecalibrationArgumentCollection RAC = new RecalibrationArgumentCollection();
        for (Object primaryKey : table.getPrimaryKeys()) {
            Object value = table.get(primaryKey, "Value");
            if (value.equals("null")) {
                value = null;
            }
            if (primaryKey.equals("covariate") && value != null) {
                RAC.COVARIATES = value.toString().split(",");
                continue;
            }
            if (primaryKey.equals("standard_covs")) {
                RAC.USE_STANDARD_COVARIATES = Boolean.parseBoolean((String)value);
                continue;
            }
            if (primaryKey.equals("solid_recal_mode")) {
                RAC.SOLID_RECAL_MODE = RecalDataManager.SOLID_RECAL_MODE.recalModeFromString((String)value);
                continue;
            }
            if (primaryKey.equals("solid_nocall_strategy")) {
                RAC.SOLID_NOCALL_STRATEGY = RecalDataManager.SOLID_NOCALL_STRATEGY.nocallStrategyFromString((String)value);
                continue;
            }
            if (primaryKey.equals("mismatches_context_size")) {
                RAC.MISMATCHES_CONTEXT_SIZE = Integer.parseInt((String)value);
                continue;
            }
            if (primaryKey.equals("insertions_context_size")) {
                RAC.INSERTIONS_CONTEXT_SIZE = Integer.parseInt((String)value);
                continue;
            }
            if (primaryKey.equals("deletions_context_size")) {
                RAC.DELETIONS_CONTEXT_SIZE = Integer.parseInt((String)value);
                continue;
            }
            if (primaryKey.equals("mismatches_default_quality")) {
                RAC.MISMATCHES_DEFAULT_QUALITY = Byte.parseByte((String)value);
                continue;
            }
            if (primaryKey.equals("insertions_default_quality")) {
                RAC.INSERTIONS_DEFAULT_QUALITY = Byte.parseByte((String)value);
                continue;
            }
            if (primaryKey.equals("deletions_default_quality")) {
                RAC.DELETIONS_DEFAULT_QUALITY = Byte.parseByte((String)value);
                continue;
            }
            if (primaryKey.equals("low_quality_tail")) {
                RAC.LOW_QUAL_TAIL = Byte.parseByte((String)value);
                continue;
            }
            if (primaryKey.equals("default_platform")) {
                RAC.DEFAULT_PLATFORM = (String)value;
                continue;
            }
            if (primaryKey.equals("force_platform")) {
                RAC.FORCE_PLATFORM = (String)value;
                continue;
            }
            if (primaryKey.equals("quantizing_levels")) {
                RAC.QUANTIZING_LEVELS = Integer.parseInt((String)value);
                continue;
            }
            if (primaryKey.equals("keep_intermediate_files")) {
                RAC.KEEP_INTERMEDIATE_FILES = Boolean.parseBoolean((String)value);
                continue;
            }
            if (primaryKey.equals("no_plots")) {
                RAC.NO_PLOTS = Boolean.parseBoolean((String)value);
                continue;
            }
            if (!primaryKey.equals("recalibration_report")) continue;
            RAC.recalibrationReport = value == null ? null : new File((String)value);
        }
        return RAC;
    }

    public void calculateEmpiricalAndQuantizedQualities() {
        for (Map<BitSet, RecalDatum> table : this.keysAndTablesMap.values()) {
            for (RecalDatum datum : table.values()) {
                datum.calcCombinedEmpiricalQuality();
            }
        }
        this.quantizationInfo = new QuantizationInfo(this.keysAndTablesMap, this.RAC.QUANTIZING_LEVELS);
    }

    public void output(PrintStream output) {
        RecalDataManager.outputRecalibrationReport(this.argumentTable, this.quantizationInfo, this.keysAndTablesMap, output);
    }

    public RecalibrationArgumentCollection getRAC() {
        return this.RAC;
    }

    public boolean equals(Object o) {
        if (!(o instanceof RecalibrationReport)) {
            return false;
        }
        RecalibrationReport other = (RecalibrationReport)o;
        if (this == o) {
            return true;
        }
        return this.isEqualTable(this.keysAndTablesMap, other.keysAndTablesMap);
    }

    private boolean isEqualTable(LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> t1, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        Iterator<Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>>> t1Iterator = t1.entrySet().iterator();
        Iterator<Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>>> t2Iterator = t2.entrySet().iterator();
        while (t1Iterator.hasNext() && t2Iterator.hasNext()) {
            Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> t1MapEntry = t1Iterator.next();
            Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> t2MapEntry = t2Iterator.next();
            if (!t1MapEntry.getKey().equals(t2MapEntry.getKey())) {
                return false;
            }
            Map<BitSet, RecalDatum> table2 = t2MapEntry.getValue();
            for (Map.Entry<BitSet, RecalDatum> t1TableEntry : t1MapEntry.getValue().entrySet()) {
                BitSet t1Key = t1TableEntry.getKey();
                if (!table2.containsKey(t1Key)) {
                    return false;
                }
                RecalDatum t1Datum = t1TableEntry.getValue();
                if (t1Datum.equals(table2.get(t1Key))) continue;
                return false;
            }
        }
        return true;
    }
}

