/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.BitSet;
import java.util.EnumSet;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.StandardCovariate;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.BitSetUtils;
import org.broadinstitute.sting.utils.NGSPlatform;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class CycleCovariate
implements StandardCovariate {
    private static final EnumSet<NGSPlatform> DISCRETE_CYCLE_PLATFORMS = EnumSet.of(NGSPlatform.ILLUMINA, NGSPlatform.SOLID, NGSPlatform.PACBIO, NGSPlatform.COMPLETE_GENOMICS);
    private static final EnumSet<NGSPlatform> FLOW_CYCLE_PLATFORMS = EnumSet.of(NGSPlatform.LS454, NGSPlatform.ION_TORRENT);

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        if (RAC.DEFAULT_PLATFORM != null && !NGSPlatform.isKnown(RAC.DEFAULT_PLATFORM)) {
            throw new UserException.CommandLineException("The requested default platform (" + RAC.DEFAULT_PLATFORM + ") is not a recognized platform.");
        }
    }

    @Override
    public CovariateValues getValues(GATKSAMRecord read) {
        BitSet[] cycles = new BitSet[read.getReadLength()];
        NGSPlatform ngsPlatform = read.getNGSPlatform();
        if (DISCRETE_CYCLE_PLATFORMS.contains((Object)ngsPlatform)) {
            short increment;
            short cycle;
            short readOrderFactor;
            short s = readOrderFactor = read.getReadPairedFlag() && read.getSecondOfPairFlag() ? (short)-1 : 1;
            if (read.getReadNegativeStrandFlag()) {
                cycle = (short)(read.getReadLength() * readOrderFactor);
                increment = (short)(-1 * readOrderFactor);
            } else {
                cycle = readOrderFactor;
                increment = readOrderFactor;
            }
            int CUSHION = 4;
            int MAX_CYCLE = read.getReadLength() - 4 - 1;
            for (int i = 0; i < MAX_CYCLE; ++i) {
                cycles[i] = i < 4 || i > MAX_CYCLE ? null : BitSetUtils.bitSetFrom(cycle);
                cycle = (short)(cycle + increment);
            }
        } else if (FLOW_CYCLE_PLATFORMS.contains((Object)ngsPlatform)) {
            short cycle;
            int readLength = read.getReadLength();
            byte[] bases = read.getReadBases();
            boolean multiplyByNegative1 = read.getReadPairedFlag() && read.getSecondOfPairFlag();
            short s = cycle = multiplyByNegative1 ? (short)-1 : 1;
            if (!read.getReadNegativeStrandFlag()) {
                int iii = 0;
                while (iii < readLength) {
                    while (iii < readLength && bases[iii] == 84) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 65) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 67) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        ++iii;
                    }
                    while (iii < readLength && bases[iii] == 71) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        ++iii;
                    }
                    if (iii < readLength) {
                        cycle = multiplyByNegative1 ? (short)(cycle - 1) : (short)(cycle + 1);
                    }
                    if (iii >= readLength || BaseUtils.isRegularBase(bases[iii])) continue;
                    cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                    ++iii;
                }
            } else {
                int iii = readLength - 1;
                while (iii >= 0) {
                    while (iii >= 0 && bases[iii] == 84) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 65) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 67) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        --iii;
                    }
                    while (iii >= 0 && bases[iii] == 71) {
                        cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                        --iii;
                    }
                    if (iii >= 0) {
                        cycle = multiplyByNegative1 ? (short)(cycle - 1) : (short)(cycle + 1);
                    }
                    if (iii < 0 || BaseUtils.isRegularBase(bases[iii])) continue;
                    cycles[iii] = BitSetUtils.bitSetFrom(cycle);
                    --iii;
                }
            }
        } else {
            throw new UserException("The platform (" + read.getReadGroup().getPlatform() + ") associated with read group " + read.getReadGroup() + " is not a recognized platform. Implemented options are e.g. illumina, 454, and solid");
        }
        return new CovariateValues(cycles, cycles, cycles);
    }

    @Override
    public final Object getValue(String str) {
        return Short.parseShort(str);
    }

    @Override
    public String keyFromBitSet(BitSet key) {
        return String.format("%d", BitSetUtils.shortFrom(key));
    }

    @Override
    public BitSet bitSetFromKey(Object key) {
        return key instanceof String ? BitSetUtils.bitSetFrom(Short.parseShort((String)key)) : BitSetUtils.bitSetFrom((Short)key);
    }

    @Override
    public int numberOfBits() {
        return BitSetUtils.numberOfBitsToRepresent(65534L);
    }
}

