/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.io.File;
import org.broadinstitute.sting.commandline.Tags;

public class SAMReaderID
implements Comparable {
    protected final File samFile;
    protected final Tags tags;

    public SAMReaderID(File samFile, Tags tags) {
        this.samFile = samFile;
        this.tags = tags;
    }

    public SAMReaderID(String samFileName, Tags tags) {
        this(new File(samFileName), tags);
    }

    public String getSamFilePath() {
        if (this.samFile == null) {
            return null;
        }
        return this.samFile.getAbsolutePath();
    }

    public Tags getTags() {
        return this.tags;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SAMReaderID)) {
            return false;
        }
        SAMReaderID otherID = (SAMReaderID)other;
        return this.samFile.equals(otherID.samFile);
    }

    public int hashCode() {
        return this.samFile.hashCode();
    }

    public String toString() {
        return this.getSamFilePath();
    }

    public int compareTo(Object other) {
        return this.samFile.getAbsolutePath().compareTo(((SAMReaderID)other).samFile.getAbsolutePath());
    }
}

