/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl2.DebugInfo;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.ExpressionImpl;
import org.apache.commons.jexl2.Interpreter;
import org.apache.commons.jexl2.JexlArithmetic;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.JexlException;
import org.apache.commons.jexl2.JexlInfo;
import org.apache.commons.jexl2.Script;
import org.apache.commons.jexl2.UnifiedJEXL;
import org.apache.commons.jexl2.introspection.JexlMethod;
import org.apache.commons.jexl2.introspection.Uberspect;
import org.apache.commons.jexl2.introspection.UberspectImpl;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.ParseException;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.commons.jexl2.parser.TokenMgrError;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlEngine {
    public static final JexlContext EMPTY_CONTEXT = new JexlContext(){

        public Object get(String name) {
            return null;
        }

        public boolean has(String name) {
            return false;
        }

        public void set(String name, Object value) {
            throw new UnsupportedOperationException("Not supported in void context.");
        }
    };
    protected final Uberspect uberspect;
    protected final JexlArithmetic arithmetic;
    protected final Log logger;
    protected final Parser parser = new Parser(new StringReader(";"));
    protected boolean silent = false;
    protected boolean debug = true;
    protected Map<String, Object> functions = Collections.emptyMap();
    protected SoftCache<String, ASTJexlScript> cache = null;
    private static final float LOAD_FACTOR = 0.75f;

    public JexlEngine() {
        this(null, null, null, null);
    }

    public JexlEngine(Uberspect anUberspect, JexlArithmetic anArithmetic, Map<String, Object> theFunctions, Log log) {
        Uberspect uberspect = this.uberspect = anUberspect == null ? JexlEngine.getUberspect(log) : anUberspect;
        if (log == null) {
            log = LogFactory.getLog(JexlEngine.class);
        }
        this.logger = log;
        JexlArithmetic jexlArithmetic = this.arithmetic = anArithmetic == null ? new JexlArithmetic(true) : anArithmetic;
        if (theFunctions != null) {
            this.functions = theFunctions;
        }
    }

    public static Uberspect getUberspect(Log logger) {
        if (logger == null || logger.equals(LogFactory.getLog(JexlEngine.class))) {
            return UberspectHolder.UBERSPECT;
        }
        return new UberspectImpl(logger);
    }

    public Uberspect getUberspect() {
        return this.uberspect;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setSilent(boolean flag) {
        this.silent = flag;
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setLenient(boolean flag) {
        this.arithmetic.setLenient(flag);
    }

    public boolean isLenient() {
        return this.arithmetic.isLenient();
    }

    public void setClassLoader(ClassLoader loader) {
        this.uberspect.setClassLoader(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCache(int size) {
        Parser parser = this.parser;
        synchronized (parser) {
            if (size <= 0) {
                this.cache = null;
            } else if (this.cache == null || this.cache.size() != size) {
                this.cache = new SoftCache(size);
            }
        }
    }

    public void setFunctions(Map<String, Object> funcs) {
        this.functions = funcs != null ? funcs : Collections.emptyMap();
    }

    public Map<String, Object> getFunctions() {
        return this.functions;
    }

    protected Expression createExpression(ASTJexlScript tree, String text) {
        return new ExpressionImpl(this, text, tree);
    }

    public Expression createExpression(String expression) {
        return this.createExpression(expression, null);
    }

    public Expression createExpression(String expression, JexlInfo info) {
        ASTJexlScript tree = this.parse(expression, info);
        if (tree.jjtGetNumChildren() > 1) {
            this.logger.warn("The JEXL Expression created will be a reference to the first expression from the supplied script: \"" + expression + "\" ");
        }
        return this.createExpression(tree, expression);
    }

    public Script createScript(String scriptText) {
        return this.createScript(scriptText, null);
    }

    public Script createScript(String scriptText, JexlInfo info) {
        if (scriptText == null) {
            throw new NullPointerException("scriptText is null");
        }
        ASTJexlScript tree = this.parse(scriptText, info);
        return this.createScript(tree, scriptText);
    }

    protected Script createScript(ASTJexlScript tree, String text) {
        return new ExpressionImpl(this, text, tree);
    }

    public Script createScript(File scriptFile) throws IOException {
        if (scriptFile == null) {
            throw new NullPointerException("scriptFile is null");
        }
        if (!scriptFile.canRead()) {
            throw new IOException("Can't read scriptFile (" + scriptFile.getCanonicalPath() + ")");
        }
        BufferedReader reader = new BufferedReader(new FileReader(scriptFile));
        JexlInfo info = null;
        if (this.debug) {
            info = this.createInfo(scriptFile.getName(), 0, 0);
        }
        return this.createScript(JexlEngine.readerToString(reader), info);
    }

    public Script createScript(URL scriptUrl) throws IOException {
        if (scriptUrl == null) {
            throw new NullPointerException("scriptUrl is null");
        }
        URLConnection connection = scriptUrl.openConnection();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        JexlInfo info = null;
        if (this.debug) {
            info = this.createInfo(scriptUrl.toString(), 0, 0);
        }
        return this.createScript(JexlEngine.readerToString(reader), info);
    }

    public Object getProperty(Object bean, String expr) {
        return this.getProperty(null, bean, expr);
    }

    public Object getProperty(JexlContext context, Object bean, String expr) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        String r0 = "$0";
        int s = 0;
        while (context.has(r0)) {
            r0 = r0 + s;
            ++s;
        }
        expr = r0 + (expr.charAt(0) == '[' ? "" : ".") + expr + ";";
        try {
            ASTJexlScript tree = this.parse(expr, null);
            JexlNode node = tree.jjtGetChild(0);
            Interpreter interpreter = this.createInterpreter(context);
            Object[] r = new Object[]{r0, bean, r0, bean};
            interpreter.setRegisters(r);
            return node.jjtAccept(interpreter, null);
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn(xjexl.getMessage(), xjexl.getCause());
                return null;
            }
            throw xjexl;
        }
    }

    public void setProperty(Object bean, String expr, Object value) {
        this.setProperty(null, bean, expr, value);
    }

    public void setProperty(JexlContext context, Object bean, String expr, Object value) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        String r0 = "$0";
        String r1 = "$1";
        int s = 0;
        while (context.has(r0)) {
            r0 = r0 + s;
            ++s;
        }
        s = 0;
        while (context.has(r1)) {
            r1 = r1 + s;
            ++s;
        }
        expr = r0 + (expr.charAt(0) == '[' ? "" : ".") + expr + "=" + r1 + ";";
        try {
            ASTJexlScript tree = this.parse(expr, null);
            JexlNode node = tree.jjtGetChild(0);
            Interpreter interpreter = this.createInterpreter(context);
            Object[] r = new Object[]{r0, bean, r1, value};
            interpreter.setRegisters(r);
            node.jjtAccept(interpreter, null);
        }
        catch (JexlException xjexl) {
            if (this.silent) {
                this.logger.warn(xjexl.getMessage(), xjexl.getCause());
                return;
            }
            throw xjexl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invokeMethod(Object obj, String meth, Object ... args) {
        Object result;
        block9: {
            JexlException xjexl = null;
            result = null;
            JexlInfo info = this.debugInfo();
            try {
                JexlMethod method = this.uberspect.getMethod(obj, meth, args, info);
                if (method == null && this.arithmetic.narrowArguments(args)) {
                    method = this.uberspect.getMethod(obj, meth, args, info);
                }
                if (method != null) {
                    result = method.invoke(obj, args);
                } else {
                    xjexl = new JexlException(info, "failed finding method " + meth);
                }
            }
            catch (Exception xany) {
                xjexl = new JexlException(info, "failed executing method " + meth, (Throwable)xany);
                return xjexl;
            }
            finally {
                if (xjexl == null) break block9;
                if (this.silent) {
                    this.logger.warn(xjexl.getMessage(), xjexl.getCause());
                    return null;
                }
                throw xjexl;
            }
        }
        return result;
    }

    public <T> T newInstance(Class<? extends T> clazz, Object ... args) {
        return clazz.cast(this.doCreateInstance(clazz, args));
    }

    public Object newInstance(String clazz, Object ... args) {
        return this.doCreateInstance(clazz, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doCreateInstance(Object clazz, Object ... args) {
        Object result;
        block9: {
            JexlException xjexl = null;
            result = null;
            JexlInfo info = this.debugInfo();
            try {
                Constructor<?> ctor = this.uberspect.getConstructor(clazz, args, info);
                if (ctor == null && this.arithmetic.narrowArguments(args)) {
                    ctor = this.uberspect.getConstructor(clazz, args, info);
                }
                if (ctor != null) {
                    result = ctor.newInstance(args);
                } else {
                    xjexl = new JexlException(info, "failed finding constructor for " + clazz.toString());
                }
            }
            catch (Exception xany) {
                xjexl = new JexlException(info, "failed executing constructor for " + clazz.toString(), (Throwable)xany);
                return xjexl;
            }
            finally {
                if (xjexl == null) break block9;
                if (this.silent) {
                    this.logger.warn(xjexl.getMessage(), xjexl.getCause());
                    return null;
                }
                throw xjexl;
            }
        }
        return result;
    }

    protected Interpreter createInterpreter(JexlContext context) {
        if (context == null) {
            context = EMPTY_CONTEXT;
        }
        return new Interpreter(this, context);
    }

    protected <K, V> Map<K, V> createCache(final int cacheSize) {
        return new LinkedHashMap<K, V>(cacheSize, 0.75f, true){
            private static final long serialVersionUID = 3801124242820219131L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ASTJexlScript parse(CharSequence expression, JexlInfo info) {
        String expr = JexlEngine.cleanExpression(expression);
        ASTJexlScript tree = null;
        Parser parser = this.parser;
        synchronized (parser) {
            if (this.cache != null && (tree = this.cache.get(expr)) != null) {
                return tree;
            }
            try {
                StringReader reader = new StringReader(expr);
                if (info == null) {
                    info = this.debugInfo();
                }
                tree = this.parser.parse(reader, info);
                if (this.cache != null) {
                    this.cache.put(expr, tree);
                }
            }
            catch (TokenMgrError xtme) {
                throw new JexlException(info, "tokenization failed", (Throwable)xtme);
            }
            catch (ParseException xparse) {
                throw new JexlException(info, "parsing failed", (Throwable)xparse);
            }
        }
        return tree;
    }

    protected JexlInfo createInfo(String fn, int l, int c) {
        return new DebugInfo(fn, l, c);
    }

    protected JexlInfo debugInfo() {
        JexlInfo info = null;
        if (this.debug) {
            Throwable xinfo = new Throwable();
            xinfo.fillInStackTrace();
            StackTraceElement[] stack = xinfo.getStackTrace();
            StackTraceElement se = null;
            Class<Object> clazz = this.getClass();
            for (int s = 1; s < stack.length; ++s) {
                se = stack[s];
                String className = se.getClassName();
                if (!className.equals(clazz.getName())) {
                    if (className.equals(JexlEngine.class.getName())) {
                        clazz = JexlEngine.class;
                    } else {
                        if (!className.equals(UnifiedJEXL.class.getName())) break;
                        clazz = UnifiedJEXL.class;
                    }
                }
                se = null;
            }
            if (se != null) {
                info = this.createInfo(se.getClassName() + "." + se.getMethodName(), se.getLineNumber(), 0);
            }
        }
        return info;
    }

    public static final String cleanExpression(CharSequence str) {
        if (str != null) {
            int end = str.length();
            if (end > 0) {
                int start;
                for (start = 0; start < end && str.charAt(start) == ' '; ++start) {
                }
                while (end > 0 && str.charAt(end - 1) == ' ') {
                    --end;
                }
                return ((Object)str.subSequence(start, end)).toString();
            }
            return "";
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readerToString(Reader scriptReader) throws IOException {
        StringBuilder buffer = new StringBuilder();
        BufferedReader reader = scriptReader instanceof BufferedReader ? (BufferedReader)scriptReader : new BufferedReader(scriptReader);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                buffer.append(line).append('\n');
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException xio) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SoftCache<K, V> {
        private final int size;
        private SoftReference<Map<K, V>> ref = null;

        SoftCache(int theSize) {
            this.size = theSize;
        }

        int size() {
            return this.size;
        }

        Set<Map.Entry<K, V>> entrySet() {
            Map<K, V> map = this.ref != null ? this.ref.get() : null;
            return map != null ? map.entrySet() : Collections.emptySet();
        }

        V get(K key) {
            Map<K, V> map = this.ref != null ? this.ref.get() : null;
            return map != null ? (V)map.get(key) : null;
        }

        void put(K key, V script) {
            Map<K, V> map;
            Map<K, V> map2 = map = this.ref != null ? this.ref.get() : null;
            if (map == null) {
                map = JexlEngine.this.createCache(this.size);
                this.ref = new SoftReference<Map<K, V>>(map);
            }
            map.put(key, script);
        }
    }

    private static final class UberspectHolder {
        private static final Uberspect UBERSPECT = new UberspectImpl(LogFactory.getLog(JexlEngine.class));

        private UberspectHolder() {
        }
    }
}

