/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.exec;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broad.tribble.source.BasicFeatureSource;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.rbio.util.vcf.VCFUtil;

public class GATKVcfDB {
    public static final String header = "ref\tpos\trbp\tabp\taf\tan\tbqrank\tdels\tfs\thrun\tmq\tqd\tvqslod\tfilter\tseffect\tsimpact\tsfunc\tscod_change\tsamino_change\tsgene_name\tsgene_biotype\tstx_id\tsexon_id\tad1\tad2\tdp\tpt\tarm\ttype";

    public static void main(String[] ars) throws Exception {
        TreeMap<String, Patient> pt_tab = new TreeMap<String, Patient>();
        BufferedReader ibuf = new BufferedReader(new FileReader("/home/ablab2user/Downloads/amit/patient_info.csv"));
        String line = ibuf.readLine();
        while ((line = ibuf.readLine()) != null) {
            String[] arr = line.split("\t");
            pt_tab.put(arr[0], new Patient(arr[1], arr[2]));
        }
        ibuf.close();
        BufferedWriter obuf = new BufferedWriter(new FileWriter("/home/ablab2user/Downloads/amit/cipn.db.txt"));
        obuf.write("ref\tpos\trbp\tabp\taf\tan\tbqrank\tdels\tfs\thrun\tmq\tqd\tvqslod\tfilter\tseffect\tsimpact\tsfunc\tscod_change\tsamino_change\tsgene_name\tsgene_biotype\tstx_id\tsexon_id\tad1\tad2\tdp\tpt\tarm\ttype\n");
        File[] fileArray = new File("/home/ablab2user/Downloads/amit/gatk").listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("vcf")) {
                System.out.println(file.getPath());
                for (String res : GATKVcfDB.process(file.getPath(), pt_tab)) {
                    obuf.write(String.valueOf(res) + "\n");
                }
            }
            ++n2;
        }
        obuf.close();
    }

    public static List<String> process(String fname, Map<String, Patient> pt_tab) throws Exception {
        ArrayList<String> res_lst = new ArrayList<String>();
        BasicFeatureSource<VariantContext> fsource = VCFUtil.getFeatureSource(fname);
        CloseableTribbleIterator<VariantContext> itr = fsource.iterator();
        while (itr.hasNext()) {
            VariantContext var = (VariantContext)itr.next();
            if (var.getType() != VariantContext.Type.SNP) continue;
            String res = var.getChr();
            res = String.valueOf(res) + "\t" + var.getStart();
            res = String.valueOf(res) + "\t" + var.getReference().getBaseString();
            res = String.valueOf(res) + "\t" + var.getAlternateAllele(0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("AF", -99999.0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsInt("AN", -99999);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("BaseQRankSum", -99999.0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("Dels", -99999.0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("FS", -99999.0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsInt("HRun", -99999);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("MQ", -99999.0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("QD", -99999.0);
            res = String.valueOf(res) + "\t" + var.getAttributeAsDouble("VQSLOD", -99999.0);
            Set<String> filt_set = var.getFilters();
            String filt = "";
            if (filt_set.size() == 0) {
                filt = "NA";
            } else {
                for (String filt_str : filt_set) {
                    filt = String.valueOf(filt) + filt_str + ":";
                }
            }
            res = String.valueOf(res) + "\t" + filt;
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_EFFECT", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_IMPACT", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_FUNCTIONAL_CLASS", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_CODON_CHANGE", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_AMINO_ACID_CHANGE", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_GENE_NAME", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_GENE_BIOTYPE", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_TRANSCRIPT_ID", "NA");
            res = String.valueOf(res) + "\t" + var.getAttributeAsString("SNPEFF_EXON_ID", "NA");
            Genotype gt = var.getGenotype(0);
            String[] ad = gt.getAttributeAsString("AD", "NA").split(",");
            if (ad.length != 2) {
                System.err.println("Ad does not have 2 values " + ad);
            }
            res = String.valueOf(res) + "\t" + ad[0] + "\t" + ad[1];
            res = String.valueOf(res) + "\t" + gt.getAttributeAsInt("DP", -99999);
            String pt = gt.getSampleName();
            res = String.valueOf(res) + "\t" + pt;
            res = String.valueOf(res) + "\t" + pt_tab.get((Object)pt).arm;
            res = String.valueOf(res) + "\t" + pt_tab.get((Object)pt).type;
            res_lst.add(res);
        }
        fsource.close();
        return res_lst;
    }

    public static class Patient {
        String arm;
        String type;

        public Patient(String arm, String type) {
            this.arm = arm;
            this.type = type;
        }
    }
}

