/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diffengine;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportColumn;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffElement;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffNode;
import org.broadinstitute.sting.gatk.walkers.diffengine.DiffableReader;

public class GATKReportDiffableReader
implements DiffableReader {
    @Override
    public String getName() {
        return "GATKReport";
    }

    @Override
    public DiffElement readFromFile(File file, int maxElementsToRead) {
        DiffNode root = DiffNode.rooted(file.getName());
        try {
            GATKReport report = new GATKReport(file);
            for (GATKReportTable table : report.getTables()) {
                root.add(this.tableToNode(table, root));
            }
            return root.getBinding();
        }
        catch (Exception e) {
            return null;
        }
    }

    private DiffNode tableToNode(GATKReportTable table, DiffNode root) {
        DiffNode tableRoot = DiffNode.empty(table.getTableName(), root);
        tableRoot.add("Description", table.getTableDescription());
        tableRoot.add("NumberOfRows", table.getNumRows());
        for (GATKReportColumn column : table.getColumns().values()) {
            DiffNode columnRoot = DiffNode.empty(column.getColumnName(), tableRoot);
            columnRoot.add("Width", column.getColumnFormat().getWidth());
            columnRoot.add("Displayable", column.isDisplayable());
            int n = 1;
            for (Object elt : column.values()) {
                String name = column.getColumnName() + n++;
                columnRoot.add(name, elt.toString());
            }
            tableRoot.add(columnRoot);
        }
        return tableRoot;
    }

    @Override
    public boolean canRead(File file) {
        try {
            String HEADER = "#:GATKReport.";
            char[] buff = new char["#:GATKReport.".length()];
            new FileReader(file).read(buff, 0, "#:GATKReport.".length());
            String firstLine = new String(buff);
            return firstLine.startsWith("#:GATKReport.");
        }
        catch (IOException e) {
            return false;
        }
    }
}

