/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.datasources.reads;

import java.util.Iterator;
import net.sf.picard.util.PeekableIterator;
import net.sf.samtools.SAMSequenceDictionary;
import org.broadinstitute.sting.gatk.datasources.reads.BAMScheduler;
import org.broadinstitute.sting.gatk.datasources.reads.FilePointer;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;

public class IntervalSharder
implements Iterator<FilePointer> {
    private final PeekableIterator<FilePointer> wrappedIterator;
    private final GenomeLocParser parser;

    public static IntervalSharder shardOverAllReads(SAMDataSource dataSource, GenomeLocParser parser) {
        return new IntervalSharder(BAMScheduler.createOverAllReads(dataSource, parser), parser);
    }

    public static IntervalSharder shardOverMappedReads(SAMDataSource dataSource, SAMSequenceDictionary sequenceDictionary, GenomeLocParser parser) {
        return new IntervalSharder(BAMScheduler.createOverMappedReads(dataSource, sequenceDictionary, parser), parser);
    }

    public static IntervalSharder shardOverIntervals(SAMDataSource dataSource, GenomeLocSortedSet loci) {
        return new IntervalSharder(BAMScheduler.createOverIntervals(dataSource, loci), loci.getGenomeLocParser());
    }

    private IntervalSharder(BAMScheduler scheduler, GenomeLocParser parser) {
        this.wrappedIterator = new PeekableIterator<FilePointer>(scheduler);
        this.parser = parser;
    }

    @Override
    public boolean hasNext() {
        return this.wrappedIterator.hasNext();
    }

    @Override
    public FilePointer next() {
        FilePointer current = this.wrappedIterator.next();
        while (this.wrappedIterator.hasNext() && current.isRegionUnmapped == this.wrappedIterator.peek().isRegionUnmapped && current.minus(this.wrappedIterator.peek()) == 0L) {
            current = current.combine(this.parser, this.wrappedIterator.next());
        }
        return current;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unable to remove from an interval sharder.");
    }
}

