/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;

public class ANNWriter {
    private static final int BNS_SEED = 11;
    private static final int GI = 0;
    private final PrintStream out;

    public ANNWriter(File file) throws IOException {
        this.out = new PrintStream(file);
    }

    public ANNWriter(OutputStream stream) {
        this.out = new PrintStream(stream);
    }

    public void write(SAMSequenceDictionary dictionary) {
        long genomeLength = 0L;
        for (SAMSequenceRecord sequence : dictionary.getSequences()) {
            genomeLength += (long)sequence.getSequenceLength();
        }
        int sequences = dictionary.getSequences().size();
        this.out.printf("%d %d %d%n", genomeLength, sequences, 11);
        for (SAMSequenceRecord sequence : dictionary.getSequences()) {
            String fullSequenceName;
            String trimmedSequenceName = fullSequenceName = sequence.getSequenceName();
            String sequenceComment = "(null)";
            long offset = 0L;
            if (fullSequenceName.indexOf(32) >= 0) {
                trimmedSequenceName = fullSequenceName.substring(0, fullSequenceName.indexOf(32));
                sequenceComment = fullSequenceName.substring(fullSequenceName.indexOf(32) + 1);
            }
            this.out.printf("%d %s %s%n", 0, trimmedSequenceName, sequenceComment);
            this.out.printf("%d %d %d%n", offset, sequence.getSequenceLength(), 0);
        }
    }

    public void close() {
        this.out.close();
    }
}

