/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class FilterFastqByLength {
    @Option(name="-fq1", usage="End1 fastq [gz]", required=true)
    private String fq1;
    @Option(name="-fq2", usage="End2 fastq [gz]", required=false)
    private String fq2 = null;
    @Option(name="-out_fq1", usage="Output end1 fastq [gz]", required=true)
    private String out_fq1;
    @Option(name="-out_fq2", usage="Output end2 fastq [gz]", required=false)
    private String out_fq2;
    @Option(name="-min_len", usage="Minimum read length", required=true)
    private int min_read_len;

    public static void main(String[] args) throws Exception {
        FilterFastqByLength filter = new FilterFastqByLength();
        CmdLineParser parser = new CmdLineParser(filter);
        try {
            parser.parseArgument(args);
            filter.process();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.err.println("Filter fastq files [gz] by length");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        GZIPInputStream igzip1 = new GZIPInputStream(new FileInputStream(this.fq1));
        BufferedReader ibuf1 = new BufferedReader(new InputStreamReader(igzip1));
        BufferedReader ibuf2 = null;
        if (this.fq2 != null) {
            GZIPInputStream igzip2 = new GZIPInputStream(new FileInputStream(this.fq2));
            ibuf2 = new BufferedReader(new InputStreamReader(igzip2));
        }
        GZIPOutputStream ogzip1 = new GZIPOutputStream(new FileOutputStream(this.out_fq1));
        BufferedWriter obuf1 = new BufferedWriter(new OutputStreamWriter(ogzip1));
        BufferedWriter obuf2 = null;
        if (this.fq2 != null) {
            GZIPOutputStream ogzip2 = new GZIPOutputStream(new FileOutputStream(this.out_fq2));
            obuf2 = new BufferedWriter(new OutputStreamWriter(ogzip2));
        }
        String line = null;
        while ((line = ibuf1.readLine()) != null) {
            String header1 = line;
            String read1 = ibuf1.readLine();
            String qheader1 = ibuf1.readLine();
            String qual1 = ibuf1.readLine();
            String header2 = null;
            String read2 = null;
            String qheader2 = null;
            String qual2 = null;
            int read2_len = 100000;
            if (this.fq2 != null) {
                header2 = ibuf2.readLine();
                read2 = ibuf2.readLine();
                qheader2 = ibuf2.readLine();
                qual2 = ibuf2.readLine();
                read2_len = read2.length();
            }
            if (read1.length() < this.min_read_len || read2_len < this.min_read_len) continue;
            obuf1.write(String.valueOf(header1) + "\n");
            obuf1.write(String.valueOf(read1) + "\n");
            obuf1.write(String.valueOf(qheader1) + "\n");
            obuf1.write(String.valueOf(qual1) + "\n");
            if (this.fq2 == null) continue;
            obuf2.write(String.valueOf(header2) + "\n");
            obuf2.write(String.valueOf(read2) + "\n");
            obuf2.write(String.valueOf(qheader2) + "\n");
            obuf2.write(String.valueOf(qual2) + "\n");
        }
        ibuf1.close();
        ibuf2.close();
        obuf1.close();
        obuf2.close();
    }
}

