/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.bqsr.BQSRKeyManager;
import org.broadinstitute.sting.gatk.walkers.bqsr.Covariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.QualityScoreCovariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.QuantizationInfo;
import org.broadinstitute.sting.gatk.walkers.bqsr.ReadCovariates;
import org.broadinstitute.sting.gatk.walkers.bqsr.ReadGroupCovariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalDatum;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.bqsr.RequiredCovariate;
import org.broadinstitute.sting.gatk.walkers.bqsr.StandardCovariate;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.R.RScriptExecutor;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.classloader.PluginManager;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.DynamicClassResolutionException;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.io.Resource;
import org.broadinstitute.sting.utils.sam.GATKSAMReadGroupRecord;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;

public class RecalDataManager {
    public static final String ARGUMENT_REPORT_TABLE_TITLE = "Arguments";
    public static final String QUANTIZED_REPORT_TABLE_TITLE = "Quantized";
    public static final String READGROUP_REPORT_TABLE_TITLE = "RecalTable0";
    public static final String QUALITY_SCORE_REPORT_TABLE_TITLE = "RecalTable1";
    public static final String ALL_COVARIATES_REPORT_TABLE_TITLE = "RecalTable2";
    public static final String ARGUMENT_VALUE_COLUMN_NAME = "Value";
    public static final String QUANTIZED_VALUE_COLUMN_NAME = "QuantizedScore";
    public static final String QUANTIZED_COUNT_COLUMN_NAME = "Count";
    public static final String READGROUP_COLUMN_NAME = "ReadGroup";
    public static final String EVENT_TYPE_COLUMN_NAME = "EventType";
    public static final String EMPIRICAL_QUALITY_COLUMN_NAME = "EmpiricalQuality";
    public static final String ESTIMATED_Q_REPORTED_COLUMN_NAME = "EstimatedQReported";
    public static final String QUALITY_SCORE_COLUMN_NAME = "QualityScore";
    public static final String COVARIATE_VALUE_COLUMN_NAME = "CovariateValue";
    public static final String COVARIATE_NAME_COLUMN_NAME = "CovariateName";
    public static final String NUMBER_OBSERVATIONS_COLUMN_NAME = "Observations";
    public static final String NUMBER_ERRORS_COLUMN_NAME = "Errors";
    private static final String COLOR_SPACE_ATTRIBUTE_TAG = "CS";
    private static final String COLOR_SPACE_INCONSISTENCY_TAG = "ZC";
    private static boolean warnUserNullPlatform = false;
    private static final String SCRIPT_FILE = "BQSR.R";

    public static LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> initializeTables(ArrayList<Covariate> requiredCovariates, ArrayList<Covariate> optionalCovariates) {
        LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> tablesAndKeysMap = new LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>>();
        ArrayList<Covariate> requiredCovariatesToAdd = new ArrayList<Covariate>(requiredCovariates.size() + 1);
        ArrayList<Covariate> optionalCovariatesToAdd = new ArrayList<Covariate>();
        for (Covariate covariate : requiredCovariates) {
            requiredCovariatesToAdd.add(covariate);
            HashMap recalTable = new HashMap();
            BQSRKeyManager keyManager = new BQSRKeyManager(requiredCovariatesToAdd, optionalCovariatesToAdd);
            tablesAndKeysMap.put(keyManager, recalTable);
        }
        HashMap recalTable = new HashMap(Short.MAX_VALUE);
        BQSRKeyManager keyManager = new BQSRKeyManager(requiredCovariates, optionalCovariates);
        tablesAndKeysMap.put(keyManager, recalTable);
        return tablesAndKeysMap;
    }

    public static Pair<ArrayList<Covariate>, ArrayList<Covariate>> initializeCovariates(RecalibrationArgumentCollection argumentCollection) {
        List<Class<Covariate>> covariateClasses = new PluginManager<Covariate>(Covariate.class).getPlugins();
        List<Class<? extends RequiredCovariate>> requiredClasses = new PluginManager<RequiredCovariate>(RequiredCovariate.class).getPlugins();
        List<Class<? extends StandardCovariate>> standardClasses = new PluginManager<StandardCovariate>(StandardCovariate.class).getPlugins();
        ArrayList<Covariate> requiredCovariates = RecalDataManager.addRequiredCovariatesToList(requiredClasses);
        ArrayList<Object> optionalCovariates = new ArrayList();
        if (argumentCollection.USE_STANDARD_COVARIATES) {
            optionalCovariates = RecalDataManager.addStandardCovariatesToList(standardClasses);
        }
        if (argumentCollection.COVARIATES != null) {
            for (String requestedCovariateString : argumentCollection.COVARIATES) {
                boolean foundClass = false;
                for (Class<Covariate> covClass : covariateClasses) {
                    if (!requestedCovariateString.equalsIgnoreCase(covClass.getSimpleName())) continue;
                    foundClass = true;
                    if (requiredClasses.contains(covClass) || argumentCollection.USE_STANDARD_COVARIATES && standardClasses.contains(covClass)) continue;
                    try {
                        Covariate covariate = covClass.newInstance();
                        optionalCovariates.add(covariate);
                    }
                    catch (Exception e) {
                        throw new DynamicClassResolutionException(covClass, e);
                    }
                }
                if (foundClass) continue;
                throw new UserException.CommandLineException("The requested covariate type (" + requestedCovariateString + ") isn't a valid covariate option. Use --list to see possible covariates.");
            }
        }
        return new Pair<ArrayList<Covariate>, ArrayList<Covariate>>(requiredCovariates, optionalCovariates);
    }

    public static void listAvailableCovariates(Logger logger) {
        List<Class<Covariate>> covariateClasses = new PluginManager<Covariate>(Covariate.class).getPlugins();
        logger.info("Available covariates:");
        for (Class<Covariate> covClass : covariateClasses) {
            logger.info(covClass.getSimpleName());
        }
        logger.info("");
    }

    private static List<GATKReportTable> generateReportTables(Map<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap) {
        LinkedList<GATKReportTable> result = new LinkedList<GATKReportTable>();
        int tableIndex = 0;
        Pair<String, String> covariateValue = new Pair<String, String>(COVARIATE_VALUE_COLUMN_NAME, "%s");
        Pair<String, String> covariateName = new Pair<String, String>(COVARIATE_NAME_COLUMN_NAME, "%s");
        Pair<String, String> eventType = new Pair<String, String>(EVENT_TYPE_COLUMN_NAME, "%s");
        Pair<String, String> empiricalQuality = new Pair<String, String>(EMPIRICAL_QUALITY_COLUMN_NAME, "%.4f");
        Pair<String, String> estimatedQReported = new Pair<String, String>(ESTIMATED_Q_REPORTED_COLUMN_NAME, "%.4f");
        Pair<String, String> nObservations = new Pair<String, String>(NUMBER_OBSERVATIONS_COLUMN_NAME, "%d");
        Pair<String, String> nErrors = new Pair<String, String>(NUMBER_ERRORS_COLUMN_NAME, "%d");
        for (Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> entry : keysAndTablesMap.entrySet()) {
            BQSRKeyManager keyManager = entry.getKey();
            Map<BitSet, RecalDatum> recalTable = entry.getValue();
            boolean isReadGroupTable = tableIndex == 0;
            GATKReportTable reportTable = new GATKReportTable("RecalTable" + tableIndex++, "");
            List<Covariate> requiredList = keyManager.getRequiredCovariates();
            List<Covariate> optionalList = keyManager.getOptionalCovariates();
            ArrayList<Pair<String, String>> columnNames = new ArrayList<Pair<String, String>>();
            for (Covariate covariate : requiredList) {
                String name = covariate.getClass().getSimpleName().split("Covariate")[0];
                columnNames.add(new Pair<String, String>(name, "%s"));
            }
            if (optionalList.size() > 0) {
                columnNames.add(covariateValue);
                columnNames.add(covariateName);
            }
            columnNames.add(eventType);
            columnNames.add(empiricalQuality);
            if (isReadGroupTable) {
                columnNames.add(estimatedQReported);
            }
            columnNames.add(nObservations);
            columnNames.add(nErrors);
            reportTable.addPrimaryKey("PrimaryKey", false);
            for (Pair pair : columnNames) {
                reportTable.addColumn((String)pair.getFirst(), true, (String)pair.getSecond());
            }
            long primaryKey = 0L;
            for (Map.Entry<BitSet, RecalDatum> recalTableEntry : recalTable.entrySet()) {
                BitSet bitSetKey = recalTableEntry.getKey();
                HashMap<String, Object> columnData = new HashMap<String, Object>(columnNames.size());
                Iterator iterator = columnNames.iterator();
                for (Object key : keyManager.keySetFrom(bitSetKey)) {
                    String columnName = (String)((Pair)iterator.next()).getFirst();
                    columnData.put(columnName, key);
                }
                RecalDatum datum = recalTableEntry.getValue();
                columnData.put((String)((Pair)iterator.next()).getFirst(), datum.getEmpiricalQuality());
                if (isReadGroupTable) {
                    columnData.put((String)((Pair)iterator.next()).getFirst(), datum.getEstimatedQReported());
                }
                columnData.put((String)((Pair)iterator.next()).getFirst(), datum.numObservations);
                columnData.put((String)((Pair)iterator.next()).getFirst(), datum.numMismatches);
                for (Map.Entry dataEntry : columnData.entrySet()) {
                    String columnName = (String)dataEntry.getKey();
                    Object value = dataEntry.getValue();
                    reportTable.set(primaryKey, columnName, value.toString());
                }
                ++primaryKey;
            }
            result.add(reportTable);
        }
        return result;
    }

    public static void outputRecalibrationReport(RecalibrationArgumentCollection RAC, QuantizationInfo quantizationInfo, Map<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap, PrintStream outputFile) {
        RecalDataManager.outputRecalibrationReport(RAC.generateReportTable(), quantizationInfo.generateReportTable(), RecalDataManager.generateReportTables(keysAndTablesMap), outputFile);
    }

    public static void outputRecalibrationReport(GATKReportTable argumentTable, QuantizationInfo quantizationInfo, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> keysAndTablesMap, PrintStream outputFile) {
        RecalDataManager.outputRecalibrationReport(argumentTable, quantizationInfo.generateReportTable(), RecalDataManager.generateReportTables(keysAndTablesMap), outputFile);
    }

    private static void outputRecalibrationReport(GATKReportTable argumentTable, GATKReportTable quantizationTable, List<GATKReportTable> recalTables, PrintStream outputFile) {
        GATKReport report = new GATKReport();
        report.addTable(argumentTable);
        report.addTable(quantizationTable);
        report.addTables(recalTables);
        report.print(outputFile);
    }

    private static Pair<PrintStream, File> initializeRecalibrationPlot(File filename) {
        PrintStream deltaTableStream;
        File deltaTableFileName = new File(filename + ".csv");
        try {
            deltaTableStream = new PrintStream(deltaTableFileName);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(deltaTableFileName, "File " + deltaTableFileName + " could not be created");
        }
        return new Pair<PrintStream, File>(deltaTableStream, deltaTableFileName);
    }

    private static void outputRecalibrationPlot(Pair<PrintStream, File> files, boolean keepIntermediates) {
        File csvFileName = files.getSecond();
        File plotFileName = new File(csvFileName + ".pdf");
        files.getFirst().close();
        RScriptExecutor executor = new RScriptExecutor();
        executor.addScript(new Resource(SCRIPT_FILE, RecalDataManager.class));
        executor.addArgs(csvFileName.getAbsolutePath());
        executor.addArgs(plotFileName.getAbsolutePath());
        executor.exec();
        if (!keepIntermediates && !csvFileName.delete()) {
            throw new ReviewedStingException("Could not find file " + csvFileName.getAbsolutePath());
        }
    }

    public static void generateRecalibrationPlot(File filename, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> original, boolean keepIntermediates) {
        Pair<PrintStream, File> files = RecalDataManager.initializeRecalibrationPlot(filename);
        RecalDataManager.writeCSV(files.getFirst(), original, "ORIGINAL", true);
        RecalDataManager.outputRecalibrationPlot(files, keepIntermediates);
    }

    public static void generateRecalibrationPlot(File filename, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> original, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> recalibrated, boolean keepIntermediates) {
        Pair<PrintStream, File> files = RecalDataManager.initializeRecalibrationPlot(filename);
        RecalDataManager.writeCSV(files.getFirst(), recalibrated, "RECALIBRATED", true);
        RecalDataManager.writeCSV(files.getFirst(), original, "ORIGINAL", false);
        RecalDataManager.outputRecalibrationPlot(files, keepIntermediates);
    }

    private static void writeCSV(PrintStream deltaTableFile, LinkedHashMap<BQSRKeyManager, Map<BitSet, RecalDatum>> map, String recalibrationMode, boolean printHeader) {
        boolean QUALITY_SCORE_COVARIATE_INDEX = true;
        HashMap<BitSet, RecalDatum> deltaTable = new HashMap<BitSet, RecalDatum>();
        BQSRKeyManager deltaKeyManager = null;
        for (Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> tableEntry : map.entrySet()) {
            BQSRKeyManager keyManager = tableEntry.getKey();
            if (keyManager.getOptionalCovariates().size() <= 0) continue;
            List<Covariate> requiredCovariates = keyManager.getRequiredCovariates().subList(0, 1);
            List<Covariate> optionalCovariates = keyManager.getRequiredCovariates().subList(1, 2);
            optionalCovariates.addAll(keyManager.getOptionalCovariates());
            deltaKeyManager = new BQSRKeyManager(requiredCovariates, optionalCovariates);
        }
        if (deltaKeyManager == null) {
            throw new ReviewedStingException("Couldn't find the covariates table");
        }
        boolean readyToPrint = false;
        for (Map.Entry<BQSRKeyManager, Map<BitSet, RecalDatum>> tableEntry : map.entrySet()) {
            List<Object> covs;
            RecalDatum recalDatum;
            Map<BitSet, RecalDatum> table;
            BQSRKeyManager keyManager = tableEntry.getKey();
            if (keyManager.getRequiredCovariates().size() == 2 && keyManager.getOptionalCovariates().isEmpty()) {
                table = tableEntry.getValue();
                for (Map.Entry<BitSet, RecalDatum> entry : table.entrySet()) {
                    recalDatum = entry.getValue();
                    covs = keyManager.keySetFrom(entry.getKey());
                    ArrayList<Object> newCovs = new ArrayList<Object>(4);
                    newCovs.add(0, covs.get(0));
                    newCovs.add(1, covs.get(1));
                    newCovs.add(2, QUALITY_SCORE_COLUMN_NAME);
                    newCovs.add(3, covs.get(2));
                    BitSet deltaKey = deltaKeyManager.bitSetFromKey(newCovs.toArray());
                    RecalDataManager.addToDeltaTable(deltaTable, deltaKey, recalDatum);
                }
            } else if (keyManager.getOptionalCovariates().size() > 0) {
                table = tableEntry.getValue();
                for (Map.Entry<BitSet, RecalDatum> entry : table.entrySet()) {
                    recalDatum = entry.getValue();
                    covs = keyManager.keySetFrom(entry.getKey());
                    covs.remove(1);
                    BitSet deltaKey = deltaKeyManager.bitSetFromKey(covs.toArray());
                    RecalDataManager.addToDeltaTable(deltaTable, deltaKey, recalDatum);
                }
                readyToPrint = true;
            }
            if (!readyToPrint) continue;
            if (printHeader) {
                LinkedList<String> header = new LinkedList<String>();
                header.add(READGROUP_COLUMN_NAME);
                header.add(COVARIATE_VALUE_COLUMN_NAME);
                header.add(COVARIATE_NAME_COLUMN_NAME);
                header.add(EVENT_TYPE_COLUMN_NAME);
                header.add(NUMBER_OBSERVATIONS_COLUMN_NAME);
                header.add(NUMBER_ERRORS_COLUMN_NAME);
                header.add(EMPIRICAL_QUALITY_COLUMN_NAME);
                header.add("AverageReportedQuality");
                header.add("Accuracy");
                header.add("Recalibration");
                deltaTableFile.println(Utils.join(",", header));
            }
            for (Map.Entry deltaEntry : deltaTable.entrySet()) {
                List<Object> deltaKeys = deltaKeyManager.keySetFrom((BitSet)deltaEntry.getKey());
                RecalDatum deltaDatum = (RecalDatum)deltaEntry.getValue();
                deltaTableFile.print(Utils.join(",", deltaKeys));
                deltaTableFile.print("," + deltaDatum.stringForCSV());
                deltaTableFile.println("," + recalibrationMode);
            }
        }
    }

    private static void addToDeltaTable(Map<BitSet, RecalDatum> deltaTable, BitSet deltaKey, RecalDatum recalDatum) {
        RecalDatum deltaDatum = deltaTable.get(deltaKey);
        if (deltaDatum == null) {
            deltaTable.put(deltaKey, new RecalDatum(recalDatum));
        } else {
            deltaDatum.combine(recalDatum);
        }
    }

    public static void parsePlatformForRead(GATKSAMRecord read, RecalibrationArgumentCollection RAC) {
        GATKSAMReadGroupRecord readGroup = read.getReadGroup();
        if (!(RAC.FORCE_PLATFORM == null || readGroup.getPlatform() != null && readGroup.getPlatform().equals(RAC.FORCE_PLATFORM))) {
            readGroup.setPlatform(RAC.FORCE_PLATFORM);
        }
        if (readGroup.getPlatform() == null) {
            if (RAC.DEFAULT_PLATFORM != null) {
                if (!warnUserNullPlatform) {
                    Utils.warnUser("The input .bam file contains reads with no platform information. Defaulting to platform = " + RAC.DEFAULT_PLATFORM + ". " + "First observed at read with name = " + read.getReadName());
                    warnUserNullPlatform = true;
                }
                readGroup.setPlatform(RAC.DEFAULT_PLATFORM);
            } else {
                throw new UserException.MalformedBAM(read, "The input .bam file contains reads with no platform information. First observed at read with name = " + read.getReadName());
            }
        }
    }

    public static boolean isColorSpaceConsistent(SOLID_NOCALL_STRATEGY strategy, GATKSAMRecord read) {
        if (ReadUtils.isSOLiDRead(read) && read.getAttribute(COLOR_SPACE_INCONSISTENCY_TAG) == null) {
            Object attr = read.getAttribute(COLOR_SPACE_ATTRIBUTE_TAG);
            if (attr != null) {
                if (!(attr instanceof String)) {
                    throw new UserException.MalformedBAM(read, String.format("Value encoded by %s in %s isn't a string!", COLOR_SPACE_ATTRIBUTE_TAG, read.getReadName()));
                }
                byte[] colorSpace = ((String)attr).getBytes();
                byte[] readBases = read.getReadBases();
                if (read.getReadNegativeStrandFlag()) {
                    readBases = BaseUtils.simpleReverseComplement(read.getReadBases());
                }
                byte[] inconsistency = new byte[readBases.length];
                byte prevBase = colorSpace[0];
                for (int i = 0; i < readBases.length; ++i) {
                    byte thisBase = RecalDataManager.getNextBaseFromColor(read, prevBase, colorSpace[i + 1]);
                    inconsistency[i] = (byte)(thisBase != readBases[i] ? 1 : 0);
                    prevBase = readBases[i];
                }
                read.setAttribute(COLOR_SPACE_INCONSISTENCY_TAG, (Object)inconsistency);
            } else {
                if (strategy == SOLID_NOCALL_STRATEGY.THROW_EXCEPTION) {
                    throw new UserException.MalformedBAM(read, "Unable to find color space information in SOLiD read. First observed at read with name = " + read.getReadName() + " Unfortunately this .bam file can not be recalibrated without color space information because of potential reference bias.");
                }
                return true;
            }
        }
        return false;
    }

    private static byte getNextBaseFromColor(GATKSAMRecord read, byte prevBase, byte color) {
        switch (color) {
            case 48: {
                return prevBase;
            }
            case 49: {
                return RecalDataManager.performColorOne(prevBase);
            }
            case 50: {
                return RecalDataManager.performColorTwo(prevBase);
            }
            case 51: {
                return RecalDataManager.performColorThree(prevBase);
            }
        }
        throw new UserException.MalformedBAM(read, "Unrecognized color space in SOLID read, color = " + (char)color + " Unfortunately this bam file can not be recalibrated without full color space information because of potential reference bias.");
    }

    public static boolean isColorSpaceConsistent(GATKSAMRecord read, int offset) {
        Object attr = read.getAttribute(COLOR_SPACE_INCONSISTENCY_TAG);
        if (attr != null) {
            byte[] inconsistency = (byte[])attr;
            if (read.getReadNegativeStrandFlag()) {
                return inconsistency[inconsistency.length - offset - 1] == 0;
            }
            return inconsistency[offset] == 0;
        }
        return true;
    }

    public static ReadCovariates computeCovariates(GATKSAMRecord read, List<Covariate> requestedCovariates) {
        int numRequestedCovariates = requestedCovariates.size();
        int readLength = read.getReadLength();
        ReadCovariates readCovariates = new ReadCovariates(readLength, numRequestedCovariates);
        for (Covariate covariate : requestedCovariates) {
            readCovariates.addCovariate(covariate.getValues(read));
        }
        return readCovariates;
    }

    private static byte performColorOne(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 67;
            }
            case 67: 
            case 99: {
                return 65;
            }
            case 71: 
            case 103: {
                return 84;
            }
            case 84: 
            case 116: {
                return 71;
            }
        }
        return base;
    }

    private static byte performColorTwo(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 71;
            }
            case 67: 
            case 99: {
                return 84;
            }
            case 71: 
            case 103: {
                return 65;
            }
            case 84: 
            case 116: {
                return 67;
            }
        }
        return base;
    }

    private static byte performColorThree(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 84;
            }
            case 67: 
            case 99: {
                return 71;
            }
            case 71: 
            case 103: {
                return 67;
            }
            case 84: 
            case 116: {
                return 65;
            }
        }
        return base;
    }

    private static ArrayList<Covariate> addRequiredCovariatesToList(List<Class<? extends RequiredCovariate>> classes) {
        ArrayList<Covariate> dest = new ArrayList<Covariate>(classes.size());
        if (classes.size() != 2) {
            throw new ReviewedStingException("The number of required covariates has changed, this is a hard change in the code and needs to be inspected");
        }
        dest.add(new ReadGroupCovariate());
        dest.add(new QualityScoreCovariate());
        return dest;
    }

    private static ArrayList<Covariate> addStandardCovariatesToList(List<Class<? extends StandardCovariate>> classes) {
        ArrayList<Covariate> dest = new ArrayList<Covariate>(classes.size());
        for (Class<? extends StandardCovariate> covClass : classes) {
            try {
                Covariate covariate = covClass.newInstance();
                dest.add(covariate);
            }
            catch (Exception e) {
                throw new DynamicClassResolutionException(covClass, e);
            }
        }
        return dest;
    }

    public static enum SOLID_NOCALL_STRATEGY {
        THROW_EXCEPTION,
        LEAVE_READ_UNRECALIBRATED,
        PURGE_READ;


        public static SOLID_NOCALL_STRATEGY nocallStrategyFromString(String nocallStrategy) {
            if (nocallStrategy.equals("THROW_EXCEPTION")) {
                return THROW_EXCEPTION;
            }
            if (nocallStrategy.equals("LEAVE_READ_UNRECALIBRATED")) {
                return LEAVE_READ_UNRECALIBRATED;
            }
            if (nocallStrategy.equals("PURGE_READ")) {
                return PURGE_READ;
            }
            throw new UserException.BadArgumentValue(nocallStrategy, "is not a valid SOLID_NOCALL_STRATEGY value");
        }
    }

    public static enum SOLID_RECAL_MODE {
        DO_NOTHING,
        SET_Q_ZERO,
        SET_Q_ZERO_BASE_N,
        REMOVE_REF_BIAS;


        public static SOLID_RECAL_MODE recalModeFromString(String recalMode) {
            if (recalMode.equals("DO_NOTHING")) {
                return DO_NOTHING;
            }
            if (recalMode.equals("SET_Q_ZERO")) {
                return SET_Q_ZERO;
            }
            if (recalMode.equals("SET_Q_ZERO_BASE_N")) {
                return SET_Q_ZERO_BASE_N;
            }
            if (recalMode.equals("REMOVE_REF_BIAS")) {
                return REMOVE_REF_BIAS;
            }
            throw new UserException.BadArgumentValue(recalMode, "is not a valid SOLID_RECAL_MODE value");
        }
    }
}

