/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.reference.bwt;

import java.io.File;
import java.io.IOException;
import net.sf.picard.reference.ReferenceSequence;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFileFactory;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.BWTReader;
import org.broadinstitute.sting.alignment.reference.bwt.BWTWriter;
import org.broadinstitute.sting.alignment.reference.bwt.Bases;
import org.broadinstitute.sting.alignment.reference.bwt.Counts;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArray;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArrayReader;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class CreateBWTFromReference {
    private byte[] loadReference(File inputFile) {
        ReferenceSequenceFile reference = ReferenceSequenceFileFactory.getReferenceSequenceFile(inputFile);
        ReferenceSequence sequence = reference.nextSequence();
        return sequence.getBases();
    }

    private byte[] loadReverseReference(File inputFile) {
        ReferenceSequenceFile reference = ReferenceSequenceFileFactory.getReferenceSequenceFile(inputFile);
        ReferenceSequence sequence = reference.nextSequence();
        PackUtils.reverse(sequence.getBases());
        return sequence.getBases();
    }

    private Counts countOccurrences(byte[] sequence) {
        Counts occurrences = new Counts();
        for (byte base : sequence) {
            occurrences.increment(base);
        }
        return occurrences;
    }

    private long[] createSuffixArray(byte[] sequence) {
        return SuffixArray.createFromReferenceSequence((byte[])sequence).sequence;
    }

    private long[] invertSuffixArray(long[] suffixArray) {
        long[] inverseSuffixArray = new long[suffixArray.length];
        for (int i = 0; i < suffixArray.length; ++i) {
            inverseSuffixArray[(int)suffixArray[i]] = i;
        }
        return inverseSuffixArray;
    }

    private long[] createCompressedSuffixArray(int[] suffixArray, int[] inverseSuffixArray) {
        long[] compressedSuffixArray = new long[suffixArray.length];
        compressedSuffixArray[0] = inverseSuffixArray[0];
        for (int i = 1; i < suffixArray.length; ++i) {
            compressedSuffixArray[i] = inverseSuffixArray[suffixArray[i] + 1];
        }
        return compressedSuffixArray;
    }

    private long[] createInversedCompressedSuffixArray(int[] compressedSuffixArray) {
        long[] inverseCompressedSuffixArray = new long[compressedSuffixArray.length];
        for (int i = 0; i < compressedSuffixArray.length; ++i) {
            inverseCompressedSuffixArray[compressedSuffixArray[i]] = i;
        }
        return inverseCompressedSuffixArray;
    }

    public static void main(String[] argv) throws IOException {
        if (argv.length != 5) {
            System.out.println("USAGE: CreateBWTFromReference <input>.fasta <output bwt> <output rbwt> <output sa> <output rsa>");
            return;
        }
        String inputFileName = argv[0];
        File inputFile = new File(inputFileName);
        String bwtFileName = argv[1];
        File bwtFile = new File(bwtFileName);
        String rbwtFileName = argv[2];
        File rbwtFile = new File(rbwtFileName);
        String saFileName = argv[3];
        File saFile = new File(saFileName);
        String rsaFileName = argv[4];
        File rsaFile = new File(rsaFileName);
        CreateBWTFromReference creator = new CreateBWTFromReference();
        byte[] sequence = creator.loadReference(inputFile);
        byte[] reverseSequence = creator.loadReverseReference(inputFile);
        Counts occurrences = creator.countOccurrences(sequence);
        System.out.printf("Occurrences: a=%d, c=%d, g=%d, t=%d%n", occurrences.getCumulative(Bases.A), occurrences.getCumulative(Bases.C), occurrences.getCumulative(Bases.G), occurrences.getCumulative(Bases.T));
        long[] suffixArrayData = creator.createSuffixArray(sequence);
        long[] reverseSuffixArrayData = creator.createSuffixArray(reverseSequence);
        long[] inverseSuffixArray = creator.invertSuffixArray(suffixArrayData);
        long[] reverseInverseSuffixArray = creator.invertSuffixArray(reverseSuffixArrayData);
        SuffixArray suffixArray = new SuffixArray(inverseSuffixArray[0], occurrences, suffixArrayData);
        SuffixArray reverseSuffixArray = new SuffixArray(reverseInverseSuffixArray[0], occurrences, reverseSuffixArrayData);
        BWT bwt = BWT.createFromReferenceSequence(sequence);
        BWT reverseBWT = BWT.createFromReferenceSequence(reverseSequence);
        byte[] bwtSequence = bwt.getSequence();
        System.out.printf("BWT: %s... (length = %d)%n", new String(bwtSequence, 0, 80), bwt.length());
        BWTWriter bwtWriter = new BWTWriter(bwtFile);
        bwtWriter.write(bwt);
        bwtWriter.close();
        BWTWriter reverseBWTWriter = new BWTWriter(rbwtFile);
        reverseBWTWriter.write(reverseBWT);
        reverseBWTWriter.close();
        File existingBWTFile = new File(inputFileName + ".bwt");
        BWTReader existingBWTReader = new BWTReader(existingBWTFile);
        BWT existingBWT = existingBWTReader.read();
        byte[] existingBWTSequence = existingBWT.getSequence();
        System.out.printf("Existing BWT: %s... (length = %d)%n", new String(existingBWTSequence, 0, 80), existingBWT.length());
        int i = 0;
        while ((long)i < bwt.length()) {
            if (bwtSequence[i] != existingBWTSequence[i]) {
                throw new ReviewedStingException("BWT mismatch at " + i);
            }
            ++i;
        }
        File existingSAFile = new File(inputFileName + ".sa");
        SuffixArrayReader existingSuffixArrayReader = new SuffixArrayReader(existingSAFile, existingBWT);
        SuffixArray existingSuffixArray = existingSuffixArrayReader.read();
        int i2 = 0;
        while ((long)i2 < suffixArray.length()) {
            if (i2 % 10000 == 0) {
                System.out.printf("Validating suffix array entry %d%n", i2);
            }
            if (suffixArray.get(i2) != existingSuffixArray.get(i2)) {
                throw new ReviewedStingException(String.format("Suffix array mismatch at %d; SA is %d; should be %d", i2, existingSuffixArray.get(i2), suffixArray.get(i2)));
            }
            ++i2;
        }
    }
}

