/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.xml.core;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.simpleframework.xml.core.Context;
import org.simpleframework.xml.core.ConversionType;
import org.simpleframework.xml.core.Factory;
import org.simpleframework.xml.core.InstantiationException;
import org.simpleframework.xml.core.Type;
import org.simpleframework.xml.stream.InputNode;

class MapFactory
extends Factory {
    public MapFactory(Context context, Class field) {
        super(context, field);
    }

    public Object getInstance() throws Exception {
        Class type = this.field;
        if (!MapFactory.isInstantiable(type)) {
            type = this.getConversion(this.field);
        }
        if (!this.isMap(type)) {
            throw new InstantiationException("Type is not a collection %s", this.field);
        }
        return type.newInstance();
    }

    public Type getInstance(InputNode node) throws Exception {
        Type type = this.getOverride(node);
        if (type != null) {
            return this.getInstance(type);
        }
        if (!MapFactory.isInstantiable(this.field)) {
            this.field = this.getConversion(this.field);
        }
        if (!this.isMap(this.field)) {
            throw new InstantiationException("Type is not a map %s", this.field);
        }
        return this.context.getType(this.field);
    }

    public Type getInstance(Type type) throws Exception {
        Class real = type.getType();
        if (!MapFactory.isInstantiable(real)) {
            real = this.getConversion(real);
        }
        if (!this.isMap(real)) {
            throw new InstantiationException("Type is not a map %s", real);
        }
        return new ConversionType(type, real);
    }

    public Class getConversion(Class type) throws Exception {
        if (type.isAssignableFrom(HashMap.class)) {
            return HashMap.class;
        }
        if (type.isAssignableFrom(TreeMap.class)) {
            return TreeMap.class;
        }
        throw new InstantiationException("Cannot instantiate %s", type);
    }

    private boolean isMap(Class type) {
        return Map.class.isAssignableFrom(type);
    }
}

