/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.LinkedHashMap;
import java.util.Map;

public class FastaIO {
    public static Map<String, StringBuilder> read(String fa, int initial_capacity) throws Exception {
        return FastaIO.read(fa, initial_capacity, false);
    }

    public static Map<String, StringBuilder> read(String fa, int initial_capacity, boolean full_header) throws Exception {
        LinkedHashMap<String, StringBuilder> tab = new LinkedHashMap<String, StringBuilder>();
        BufferedReader buf = new BufferedReader(new FileReader(fa));
        String line = null;
        String ref = null;
        StringBuilder strb = null;
        while ((line = buf.readLine()) != null) {
            if (line.length() == 0) continue;
            if (line.charAt(0) == '>') {
                if (ref != null) {
                    strb.trimToSize();
                    tab.put(ref, strb);
                }
                ref = line.substring(1);
                if (!full_header) {
                    ref = line.substring(1).split(" ")[0];
                }
                strb = new StringBuilder(initial_capacity);
                continue;
            }
            strb.append(line);
        }
        tab.put(ref, strb);
        buf.close();
        return tab;
    }

    public static void write(Map<String, StringBuilder> tab, String fname, int fasta_line_size) throws Exception {
        BufferedWriter buf = new BufferedWriter(new FileWriter(fname));
        for (String ref : tab.keySet()) {
            FastaIO.writeRecord(buf, ref, tab.get(ref), fasta_line_size);
        }
        buf.close();
    }

    public static void writeRecord(BufferedWriter buf, String header, StringBuilder seq, int fasta_line_size) throws Exception {
        int str_len = seq.length();
        buf.write(">" + header + "\n");
        int start = 0;
        while (start < str_len) {
            int end = start + fasta_line_size;
            if (end > str_len) {
                end = str_len;
            }
            buf.write(String.valueOf(seq.substring(start, end)) + "\n");
            start = end;
        }
    }
}

