/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.rna.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class MergeCufflinks {
    @Option(name="-config", usage="configuration file", required=true)
    private String config;
    @Option(name="-oprefix", usage="output file prefix", required=true)
    private String oprefix;

    public static void main(String[] args) throws Exception {
        MergeCufflinks cuff = new MergeCufflinks();
        CmdLineParser parser = new CmdLineParser(cuff);
        try {
            parser.parseArgument(args);
            cuff.process();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Join cufflinks result from several samples\nconfiguration file format [first line is header]\nsamp file\nMAKE SURE THERE ARE SAME NUMBER OF GENES IN ALL FILES");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        ArrayList<String> samp_lst = new ArrayList<String>();
        LinkedHashMap fpkm_tab = new LinkedHashMap();
        boolean is_first_samp = true;
        BufferedReader ibuf = new BufferedReader(new FileReader(this.config));
        String line = ibuf.readLine();
        while ((line = ibuf.readLine()) != null) {
            String[] arr = line.split("\t");
            String samp = arr[0];
            String samp_file = arr[1];
            System.out.println(String.valueOf(samp) + "\t" + (String)samp_file);
            BufferedReader sbuf = new BufferedReader(new FileReader(samp_file));
            String sline = sbuf.readLine();
            while ((sline = sbuf.readLine()) != null) {
                String[] sarr = sline.split("\t");
                String gene = sarr[0];
                FPKM fpkm = new FPKM(Double.parseDouble(sarr[9]), Double.parseDouble(sarr[10]), Double.parseDouble(sarr[11]), sarr[12]);
                List<FPKM> lst = null;
                if (is_first_samp) {
                    lst = new ArrayList();
                    fpkm_tab.put(gene, lst);
                } else if (fpkm_tab.containsKey(gene)) {
                    lst = (List)fpkm_tab.get(gene);
                } else {
                    System.out.println("Gene in sample not seen : " + samp + "\t" + gene);
                }
                lst.add(fpkm);
            }
            sbuf.close();
            is_first_samp = false;
            samp_lst.add(samp);
        }
        ibuf.close();
        System.out.println("number of genes : " + fpkm_tab.size());
        String header = "gene";
        for (String samp : samp_lst) {
            header = String.valueOf(header) + "\t" + samp;
        }
        BufferedWriter obuf1 = new BufferedWriter(new FileWriter(String.valueOf(this.oprefix) + ".fpkm.txt"));
        obuf1.write(String.valueOf(header) + "\n");
        BufferedWriter obuf2 = new BufferedWriter(new FileWriter(String.valueOf(this.oprefix) + ".fpkm_lo.txt"));
        obuf2.write(String.valueOf(header) + "\n");
        BufferedWriter obuf3 = new BufferedWriter(new FileWriter(String.valueOf(this.oprefix) + ".fpkm_hi.txt"));
        obuf3.write(String.valueOf(header) + "\n");
        BufferedWriter obuf4 = new BufferedWriter(new FileWriter(String.valueOf(this.oprefix) + ".fpkm_status.txt"));
        obuf4.write(String.valueOf(header) + "\n");
        Iterator iterator = fpkm_tab.keySet().iterator();
        while (iterator.hasNext()) {
            String gene;
            String res1 = gene = (String)iterator.next();
            String res2 = gene;
            String res3 = gene;
            String res4 = gene;
            for (FPKM fpkm : (List)fpkm_tab.get(gene)) {
                res1 = String.valueOf(res1) + "\t" + fpkm.fpkm;
                res2 = String.valueOf(res2) + "\t" + fpkm.fpkm_lo;
                res3 = String.valueOf(res3) + "\t" + fpkm.fpkm_hi;
                res4 = String.valueOf(res4) + "\t" + fpkm.status;
            }
            obuf1.write(String.valueOf(res1) + "\n");
            obuf2.write(String.valueOf(res2) + "\n");
            obuf3.write(String.valueOf(res3) + "\n");
            obuf4.write(String.valueOf(res4) + "\n");
        }
        obuf1.close();
        obuf2.close();
        obuf3.close();
        obuf4.close();
    }

    public static class FPKM {
        double fpkm;
        double fpkm_lo;
        double fpkm_hi;
        String status;

        public FPKM(double fpkm, double fpkm_lo, double fpkm_hi, String status) {
            this.fpkm = fpkm;
            this.fpkm_lo = fpkm_lo;
            this.fpkm_hi = fpkm_hi;
            this.status = status;
        }
    }
}

