/*
 * Decompiled with CFR 0.152.
 */
package org.rbio.annotation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.rbio.util.FastaIO;

public class CpGContent {
    @Option(name="-fasta", usage="Input fasta", required=true)
    public static String fasta;
    @Option(name="-ifname", usage="Input interval file [chr start end 1 based]", required=true)
    public static String ifname;
    @Option(name="-ofname", usage="Output file with cpg and cg columns", required=true)
    public static String ofname;
    @Option(name="-ens", usage="ensembl", required=false)
    public static boolean ens;

    static {
        ens = false;
    }

    public static void main(String[] args) throws Exception {
        CpGContent cpgc = new CpGContent();
        CmdLineParser parser = new CmdLineParser(cpgc);
        try {
            parser.parseArgument(args);
            cpgc.process();
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Count CpG and CG for a list of intervals\ninput file should have the following format [first line is header] : \n[ref] [start] [end] ...\nstart and end are 1 based");
            parser.printUsage(System.err);
            return;
        }
    }

    public void process() throws Exception {
        Map<String, StringBuilder> fa = FastaIO.read(fasta, 100000000);
        String fname1 = ifname;
        String fname2 = ofname;
        BufferedReader ibuf = new BufferedReader(new FileReader(fname1));
        BufferedWriter obuf = new BufferedWriter(new FileWriter(fname2));
        String line = ibuf.readLine();
        obuf.write(String.valueOf(line) + ",cpg,gc,len\n");
        while ((line = ibuf.readLine()) != null) {
            StringBuilder ref_str;
            String[] arr = line.split(",");
            String ref = arr[0];
            if (ens) {
                if (ref.startsWith("chr")) {
                    ref = ref.substring(3);
                }
            } else if (ref.endsWith("MT")) {
                System.out.println("MT ref : " + line);
                ref = "chrM";
            }
            if ((ref_str = fa.get(ref)) == null) continue;
            int start = Integer.parseInt(arr[1]);
            int end = Integer.parseInt(arr[2]);
            if (start < 1) {
                start = 1;
            }
            if (end > ref_str.length()) {
                end = ref_str.length();
            }
            int len = end - start + 1;
            String frag = ref_str.substring(start - 1, end).toUpperCase();
            int cpg = 0;
            int i = 0;
            while (i < frag.length() - 1) {
                char ch1 = frag.charAt(i);
                char ch2 = frag.charAt(i + 1);
                if (ch1 == 'C' && ch2 == 'G') {
                    ++cpg;
                }
                ++i;
            }
            int gc = 0;
            int i2 = 0;
            while (i2 < frag.length()) {
                char bp = frag.charAt(i2);
                if (bp == 'G' || bp == 'C') {
                    ++gc;
                }
                ++i2;
            }
            obuf.write(String.valueOf(line) + "," + cpg + "," + gc + "," + len + "\n");
        }
        ibuf.close();
        obuf.close();
    }
}

