/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.activeregion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ActivityProfile {
    final GenomeLocParser parser;
    final boolean presetRegions;
    GenomeLoc regionStartLoc = null;
    final List<Double> isActiveList;
    private GenomeLoc lastLoc = null;
    private static final int FILTER_SIZE = 65;
    private static final Double[] GaussianKernel = new Double[131];

    public ActivityProfile(GenomeLocParser parser, boolean presetRegions) {
        this(parser, presetRegions, new ArrayList<Double>(), null);
    }

    protected ActivityProfile(GenomeLocParser parser, boolean presetRegions, List<Double> isActiveList, GenomeLoc regionStartLoc) {
        this.parser = parser;
        this.presetRegions = presetRegions;
        this.isActiveList = isActiveList;
        this.regionStartLoc = regionStartLoc;
    }

    public void add(GenomeLoc loc, double score) {
        if (loc.size() != 1) {
            throw new ReviewedStingException("Bad add call to ActivityProfile: loc " + loc + " size != 1");
        }
        if (this.lastLoc != null && loc.getStart() != this.lastLoc.getStop() + 1) {
            throw new ReviewedStingException("Bad add call to ActivityProfile: lastLoc added " + this.lastLoc + " and next is " + loc);
        }
        this.isActiveList.add(score);
        if (this.regionStartLoc == null) {
            this.regionStartLoc = loc;
        }
    }

    public int size() {
        return this.isActiveList.size();
    }

    public ActivityProfile bandPassFilter() {
        Object[] activeProbArray = this.isActiveList.toArray(new Double[this.isActiveList.size()]);
        Double[] filteredProbArray = new Double[activeProbArray.length];
        if (!this.presetRegions) {
            for (int iii = 0; iii < activeProbArray.length; ++iii) {
                Number[] kernel = (Double[])ArrayUtils.subarray((Object[])GaussianKernel, Math.max(65 - iii, 0), Math.min(GaussianKernel.length, 65 + activeProbArray.length - iii));
                Number[] activeProbSubArray = (Double[])ArrayUtils.subarray(activeProbArray, Math.max(0, iii - 65), Math.min(activeProbArray.length, iii + 65 + 1));
                filteredProbArray[iii] = MathUtils.dotProduct((Number[])activeProbSubArray, (Number[])kernel);
            }
        }
        return new ActivityProfile(this.parser, this.presetRegions, Arrays.asList(filteredProbArray), this.regionStartLoc);
    }

    public List<ActiveRegion> createActiveRegions(int activeRegionExtension, int maxRegionSize) {
        double ACTIVE_PROB_THRESHOLD = 0.002;
        ArrayList<ActiveRegion> returnList = new ArrayList<ActiveRegion>();
        if (this.isActiveList.size() == 0) {
            return Collections.emptyList();
        }
        if (this.isActiveList.size() == 1) {
            boolean isActive = this.isActiveList.get(0) > 0.002;
            returnList.addAll(this.createActiveRegion(isActive, 0, 0, activeRegionExtension, maxRegionSize));
        } else {
            boolean isActive = this.isActiveList.get(0) > 0.002;
            int curStart = 0;
            for (int iii = 1; iii < this.isActiveList.size(); ++iii) {
                boolean thisStatus;
                boolean bl = thisStatus = this.isActiveList.get(iii) > 0.002;
                if (isActive == thisStatus) continue;
                returnList.addAll(this.createActiveRegion(isActive, curStart, iii - 1, activeRegionExtension, maxRegionSize));
                isActive = thisStatus;
                curStart = iii;
            }
            returnList.addAll(this.createActiveRegion(isActive, curStart, this.isActiveList.size() - 1, activeRegionExtension, maxRegionSize));
        }
        return returnList;
    }

    private final List<ActiveRegion> createActiveRegion(boolean isActive, int curStart, int curEnd, int activeRegionExtension, int maxRegionSize) {
        return this.createActiveRegion(isActive, curStart, curEnd, activeRegionExtension, maxRegionSize, new ArrayList<ActiveRegion>());
    }

    private final List<ActiveRegion> createActiveRegion(boolean isActive, int curStart, int curEnd, int activeRegionExtension, int maxRegionSize, List<ActiveRegion> returnList) {
        if (!isActive || curEnd - curStart < maxRegionSize) {
            GenomeLoc loc = this.parser.createGenomeLoc(this.regionStartLoc.getContig(), this.regionStartLoc.getStart() + curStart, this.regionStartLoc.getStart() + curEnd);
            returnList.add(new ActiveRegion(loc, isActive, this.parser, activeRegionExtension));
            return returnList;
        }
        Double minProb = Double.MAX_VALUE;
        int cutPoint = -1;
        for (int iii = curStart + 50; iii < curEnd - 50; ++iii) {
            if (!(this.isActiveList.get(iii) < minProb)) continue;
            minProb = this.isActiveList.get(iii);
            cutPoint = iii;
        }
        List<ActiveRegion> leftList = this.createActiveRegion(isActive, curStart, cutPoint, activeRegionExtension, maxRegionSize, new ArrayList<ActiveRegion>());
        List<ActiveRegion> rightList = this.createActiveRegion(isActive, cutPoint + 1, curEnd, activeRegionExtension, maxRegionSize, new ArrayList<ActiveRegion>());
        returnList.addAll(leftList);
        returnList.addAll(rightList);
        return returnList;
    }

    static {
        for (int iii = 0; iii < 131; ++iii) {
            ActivityProfile.GaussianKernel[iii] = MathUtils.NormalDistribution(65.0, 40.0, iii);
        }
    }
}

