/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.recalibration;

import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.walkers.recalibration.ExperimentalCovariate;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class GCContentCovariate
implements ExperimentalCovariate {
    private int numBack = 7;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.numBack = RAC.HOMOPOLYMER_NBACK;
    }

    private Comparable getValue(SAMRecord read, int offset) {
        if (read.getReadGroup().getPlatform().equalsIgnoreCase("ILLUMINA") || read.getReadGroup().getPlatform().equalsIgnoreCase("SLX")) {
            int stopPos;
            int startPos;
            int numGC = 0;
            byte[] bases = read.getReadBases();
            if (!read.getReadNegativeStrandFlag()) {
                startPos = Math.max(offset - this.numBack, 0);
                stopPos = Math.max(offset - 1, 0);
            } else {
                startPos = Math.min(offset + 2, bases.length);
                stopPos = Math.min(offset + this.numBack + 1, bases.length);
            }
            for (int iii = startPos; iii < stopPos; ++iii) {
                if (bases[iii] != 71 && bases[iii] != 67) continue;
                ++numGC;
            }
            return Integer.valueOf(numGC);
        }
        return Integer.valueOf(-1);
    }

    @Override
    public void getValues(GATKSAMRecord read, Comparable[] comparable) {
        for (int iii = 0; iii < read.getReadLength(); ++iii) {
            comparable[iii] = this.getValue(read, iii);
        }
    }

    @Override
    public final Comparable getValue(String str) {
        return Integer.valueOf(Integer.parseInt(str));
    }
}

