/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileWriter;
import net.sf.samtools.SAMProgramRecord;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMTag;
import net.sf.samtools.util.RuntimeIOException;
import net.sf.samtools.util.SequenceUtil;
import net.sf.samtools.util.StringUtil;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.refdata.ReadMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.indels.ConstrainedMateFixingManager;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.SWPairwiseAlignment;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.NWaySAMFileWriter;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.sting.utils.text.TextFormattingUtils;
import org.broadinstitute.sting.utils.text.XReadLines;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

@BAQMode(QualityMode=BAQ.QualityMode.ADD_TAG, ApplicationTime=BAQ.ApplicationTime.ON_OUTPUT)
public class IndelRealigner
extends ReadWalker<Integer, Integer> {
    public static final String ORIGINAL_CIGAR_TAG = "OC";
    public static final String ORIGINAL_POSITION_TAG = "OP";
    public static final String PROGRAM_RECORD_NAME = "GATK IndelRealigner";
    @Input(fullName="knownAlleles", shortName="known", doc="Input VCF file(s) with known indels", required=false)
    public List<RodBinding<VariantContext>> known = Collections.emptyList();
    @Input(fullName="targetIntervals", shortName="targetIntervals", doc="intervals file output from RealignerTargetCreator", required=true)
    protected IntervalBinding<Feature> intervalsFile = null;
    @Argument(fullName="LODThresholdForCleaning", shortName="LOD", doc="LOD threshold above which the cleaner will clean", required=false)
    protected double LOD_THRESHOLD = 5.0;
    @Output(required=false, doc="Output bam")
    protected StingSAMFileWriter writer = null;
    protected ConstrainedMateFixingManager manager = null;
    protected SAMFileWriter writerToUse = null;
    @Argument(fullName="consensusDeterminationModel", shortName="model", doc="Determines how to compute the possible alternate consenses", required=false)
    public ConsensusDeterminationModel consensusModel = ConsensusDeterminationModel.USE_READS;
    @Advanced
    @Argument(fullName="entropyThreshold", shortName="entropy", doc="percentage of mismatches at a locus to be considered having high entropy", required=false)
    protected double MISMATCH_THRESHOLD = 0.15;
    @Advanced
    @Argument(fullName="maxReadsInMemory", shortName="maxInMemory", doc="max reads allowed to be kept in memory at a time by the SAMFileWriter", required=false)
    protected int MAX_RECORDS_IN_MEMORY = 150000;
    @Advanced
    @Argument(fullName="maxIsizeForMovement", shortName="maxIsize", doc="maximum insert size of read pairs that we attempt to realign", required=false)
    protected int MAX_ISIZE_FOR_MOVEMENT = 3000;
    @Advanced
    @Argument(fullName="maxPositionalMoveAllowed", shortName="maxPosMove", doc="maximum positional move in basepairs that a read can be adjusted during realignment", required=false)
    protected int MAX_POS_MOVE_ALLOWED = 200;
    @Advanced
    @Argument(fullName="maxConsensuses", shortName="maxConsensuses", doc="max alternate consensuses to try (necessary to improve performance in deep coverage)", required=false)
    protected int MAX_CONSENSUSES = 30;
    @Advanced
    @Argument(fullName="maxReadsForConsensuses", shortName="greedy", doc="max reads used for finding the alternate consensuses (necessary to improve performance in deep coverage)", required=false)
    protected int MAX_READS_FOR_CONSENSUSES = 120;
    @Advanced
    @Argument(fullName="maxReadsForRealignment", shortName="maxReads", doc="max reads allowed at an interval for realignment", required=false)
    protected int MAX_READS = 20000;
    @Advanced
    @Argument(fullName="noOriginalAlignmentTags", shortName="noTags", required=false, doc="Don't output the original cigar or alignment start tags for each realigned read in the output bam")
    protected boolean NO_ORIGINAL_ALIGNMENT_TAGS = false;
    @Argument(fullName="nWayOut", shortName="nWayOut", required=false, doc="Generate one output file for each input (-I) bam file")
    protected String N_WAY_OUT = null;
    @Hidden
    @Argument(fullName="generate_nWayOut_md5s", doc="Generate md5sums for BAMs")
    protected boolean generateMD5s = false;
    @Hidden
    @Argument(fullName="check_early", shortName="check_early", required=false, doc="Do early check of reads against existing consensuses")
    protected boolean CHECKEARLY = false;
    @Hidden
    @Argument(fullName="noPGTag", shortName="noPG", required=false, doc="Don't output the usual PG tag in the realigned bam file header. FOR DEBUGGING PURPOSES ONLY.  This option is required in order to pass integration tests.")
    protected boolean NO_PG_TAG = false;
    @Hidden
    @Argument(fullName="keepPGTags", shortName="keepPG", required=false, doc="Keep older PG tags left in the bam header by previous runs of this tool (by default, all these historical tags will be replaced by the latest tag generated in the current run).")
    protected boolean KEEP_ALL_PG_RECORDS = false;
    @Hidden
    @Output(fullName="indelsFileForDebugging", shortName="indels", required=false, doc="Output file (text) for the indels found; FOR DEBUGGING PURPOSES ONLY")
    protected String OUT_INDELS = null;
    @Hidden
    @Output(fullName="statisticsFileForDebugging", shortName="stats", doc="print out statistics (what does or doesn't get cleaned); FOR DEBUGGING PURPOSES ONLY", required=false)
    protected String OUT_STATS = null;
    @Hidden
    @Output(fullName="SNPsFileForDebugging", shortName="snps", doc="print out whether mismatching columns do or don't get cleaned out; FOR DEBUGGING PURPOSES ONLY", required=false)
    protected String OUT_SNPS = null;
    private IndexedFastaSequenceFile referenceReader;
    private Iterator<GenomeLoc> intervals = null;
    private GenomeLoc currentInterval = null;
    private boolean sawReadInCurrentInterval = false;
    private final ReadBin readsToClean = new ReadBin();
    private final ArrayList<GATKSAMRecord> readsNotToClean = new ArrayList();
    private final ArrayList<VariantContext> knownIndelsToTry = new ArrayList();
    private final HashSet<Object> indelRodsSeen = new HashSet();
    private final HashSet<GATKSAMRecord> readsActuallyCleaned = new HashSet();
    private static final int MAX_QUAL = 99;
    private static final double MISMATCH_COLUMN_CLEANED_FRACTION = 0.75;
    private static final double SW_MATCH = 30.0;
    private static final double SW_MISMATCH = -10.0;
    private static final double SW_GAP = -10.0;
    private static final double SW_GAP_EXTEND = -2.0;
    private static final int REFERENCE_PADDING = 30;
    private FileWriter indelOutput = null;
    private FileWriter statsOutput = null;
    private FileWriter snpsOutput = null;
    private long exactMatchesFound = 0L;
    private long SWalignmentRuns = 0L;
    private long SWalignmentSuccess = 0L;

    private Map<String, String> loadFileNameMap(String mapFile) {
        HashMap<String, String> fname_map = new HashMap<String, String>();
        try {
            XReadLines reader = new XReadLines(new File(mapFile), true);
            for (String line : reader) {
                if (line.length() == 0) continue;
                String[] fields = line.split("\t");
                if (fields.length != 2) {
                    throw new UserException.BadInput("Input-output map file must have exactly two columns. Offending line:\n" + line);
                }
                if (fields[0].length() == 0 || fields[1].length() == 0) {
                    throw new UserException.BadInput("Input-output map file can not have empty strings in either column. Offending line:\n" + line);
                }
                if (fname_map.containsKey(fields[0])) {
                    throw new UserException.BadInput("Input-output map file contains duplicate entries for input name " + fields[0]);
                }
                if (fname_map.containsValue(fields[1])) {
                    throw new UserException.BadInput("Input-output map file maps multiple entries onto single output name " + fields[1]);
                }
                fname_map.put(fields[0], fields[1]);
            }
        }
        catch (IOException e) {
            throw new StingException("I/O Error while reading input-output map file " + this.N_WAY_OUT + ": " + e.getMessage());
        }
        return fname_map;
    }

    @Override
    public void initialize() {
        if (this.N_WAY_OUT == null && this.writer == null) {
            throw new UserException.CommandLineException("Either -o or -nWayOut must be specified");
        }
        if (this.N_WAY_OUT != null && this.writer != null) {
            throw new UserException.CommandLineException("-o and -nWayOut can not be used simultaneously");
        }
        if (this.LOD_THRESHOLD < 0.0) {
            throw new RuntimeException("LOD threshold cannot be a negative number");
        }
        if (this.MISMATCH_THRESHOLD <= 0.0 || this.MISMATCH_THRESHOLD > 1.0) {
            throw new RuntimeException("Entropy threshold must be a fraction between 0 and 1");
        }
        try {
            this.referenceReader = new CachingIndexedFastaSequenceFile(this.getToolkit().getArguments().referenceFile);
        }
        catch (FileNotFoundException ex) {
            throw new UserException.CouldNotReadInputFile(this.getToolkit().getArguments().referenceFile, (Exception)ex);
        }
        this.intervals = this.intervalsFile.getIntervals(this.getToolkit()).iterator();
        this.currentInterval = this.intervals.hasNext() ? this.intervals.next() : null;
        this.writerToUse = this.writer;
        if (this.N_WAY_OUT != null) {
            boolean createIndex = true;
            this.writerToUse = this.N_WAY_OUT.toUpperCase().endsWith(".MAP") ? new NWaySAMFileWriter(this.getToolkit(), this.loadFileNameMap(this.N_WAY_OUT), SAMFileHeader.SortOrder.coordinate, true, createIndex, this.generateMD5s, this.createProgramRecord(), this.KEEP_ALL_PG_RECORDS) : new NWaySAMFileWriter(this.getToolkit(), this.N_WAY_OUT, SAMFileHeader.SortOrder.coordinate, true, createIndex, this.generateMD5s, this.createProgramRecord(), this.KEEP_ALL_PG_RECORDS);
        } else {
            this.setupWriter(this.getToolkit().getSAMFileHeader());
        }
        this.manager = new ConstrainedMateFixingManager(this.writerToUse, this.getToolkit().getGenomeLocParser(), this.MAX_ISIZE_FOR_MOVEMENT, this.MAX_POS_MOVE_ALLOWED, this.MAX_RECORDS_IN_MEMORY);
        if (this.OUT_INDELS != null) {
            try {
                this.indelOutput = new FileWriter(new File(this.OUT_INDELS));
            }
            catch (Exception e) {
                logger.error("Failed to create output file " + this.OUT_INDELS + ". Indel output will be suppressed");
                logger.error(e.getMessage());
                this.indelOutput = null;
            }
        }
        if (this.OUT_STATS != null) {
            try {
                this.statsOutput = new FileWriter(new File(this.OUT_STATS));
            }
            catch (Exception e) {
                logger.error("Failed to create output file " + this.OUT_STATS + ". Cleaning stats output will be suppressed");
                logger.error(e.getMessage());
                this.statsOutput = null;
            }
        }
        if (this.OUT_SNPS != null) {
            try {
                this.snpsOutput = new FileWriter(new File(this.OUT_SNPS));
            }
            catch (Exception e) {
                logger.error("Failed to create output file " + this.OUT_SNPS + ". Cleaning snps output will be suppressed");
                logger.error(e.getMessage());
                this.snpsOutput = null;
            }
        }
    }

    private void setupWriter(SAMFileHeader header) {
        if (!this.NO_PG_TAG) {
            SAMProgramRecord programRecord = this.createProgramRecord();
            List<SAMProgramRecord> oldRecords = header.getProgramRecords();
            ArrayList<SAMProgramRecord> newRecords = new ArrayList<SAMProgramRecord>(oldRecords.size() + 1);
            for (SAMProgramRecord record : oldRecords) {
                if (record.getId().startsWith(PROGRAM_RECORD_NAME) && !this.KEEP_ALL_PG_RECORDS) continue;
                newRecords.add(record);
            }
            newRecords.add(programRecord);
            header.setProgramRecords(newRecords);
        }
        this.writer.writeHeader(header);
        this.writer.setPresorted(true);
    }

    private SAMProgramRecord createProgramRecord() {
        if (this.NO_PG_TAG) {
            return null;
        }
        SAMProgramRecord programRecord = new SAMProgramRecord(PROGRAM_RECORD_NAME);
        ResourceBundle headerInfo = TextFormattingUtils.loadResourceBundle("StingText");
        try {
            String version = headerInfo.getString("org.broadinstitute.sting.gatk.version");
            programRecord.setProgramVersion(version);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        programRecord.setCommandLine(this.getToolkit().createApproximateCommandLineArgumentString(this.getToolkit(), this));
        return programRecord;
    }

    private void emit(SAMRecord read) {
        boolean wasModified = this.readsActuallyCleaned.contains(read);
        try {
            this.manager.addRead(read, wasModified);
        }
        catch (RuntimeIOException e) {
            throw new UserException.ErrorWritingBamFile(e.getMessage());
        }
    }

    private void emitReadLists() {
        this.readsNotToClean.addAll(this.readsToClean.getReads());
        ReadUtils.sortReadsByCoordinate(this.readsNotToClean);
        this.manager.addReads(this.readsNotToClean, this.readsActuallyCleaned);
        this.readsToClean.clear();
        this.readsNotToClean.clear();
        this.readsActuallyCleaned.clear();
    }

    @Override
    public Integer map(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker) {
        if (this.currentInterval == null) {
            this.emit(read);
            return 0;
        }
        if (read.getReferenceIndex() == -1) {
            this.cleanAndCallMap(ref, read, metaDataTracker, null);
            return 0;
        }
        GenomeLoc readLoc = this.getToolkit().getGenomeLocParser().createGenomeLoc(read);
        if (readLoc.getStop() == 0) {
            readLoc = this.getToolkit().getGenomeLocParser().createGenomeLoc(readLoc.getContig(), readLoc.getStart(), readLoc.getStart());
        }
        if (readLoc.isBefore(this.currentInterval)) {
            if (!this.sawReadInCurrentInterval) {
                this.emit(read);
            } else {
                this.readsNotToClean.add(read);
            }
        } else if (readLoc.overlapsP(this.currentInterval)) {
            this.sawReadInCurrentInterval = true;
            if (this.doNotTryToClean(read)) {
                this.readsNotToClean.add(read);
            } else {
                this.readsToClean.add(read);
                this.populateKnownIndels(metaDataTracker, ref);
            }
            if (this.readsToClean.size() + this.readsNotToClean.size() >= this.MAX_READS) {
                logger.info("Not attempting realignment in interval " + this.currentInterval + " because there are too many reads.");
                this.abortCleanForCurrentInterval();
            }
        } else {
            this.cleanAndCallMap(ref, read, metaDataTracker, readLoc);
        }
        return 0;
    }

    private void abortCleanForCurrentInterval() {
        this.emitReadLists();
        this.currentInterval = this.intervals.hasNext() ? this.intervals.next() : null;
        this.sawReadInCurrentInterval = false;
    }

    private boolean doNotTryToClean(SAMRecord read) {
        return read.getReadUnmappedFlag() || read.getNotPrimaryAlignmentFlag() || read.getReadFailsVendorQualityCheckFlag() || read.getMappingQuality() == 0 || read.getAlignmentStart() == 0 || ConstrainedMateFixingManager.iSizeTooBigToMove(read, this.MAX_ISIZE_FOR_MOVEMENT) || ReadUtils.is454Read(read);
    }

    private void cleanAndCallMap(ReferenceContext ref, GATKSAMRecord read, ReadMetaDataTracker metaDataTracker, GenomeLoc readLoc) {
        GenomeLoc earliestPossibleMove;
        if (this.readsToClean.size() > 0 && this.manager.canMoveReads(earliestPossibleMove = this.getToolkit().getGenomeLocParser().createGenomeLoc(this.readsToClean.getReads().get(0)))) {
            this.clean(this.readsToClean);
        }
        this.knownIndelsToTry.clear();
        this.indelRodsSeen.clear();
        this.emitReadLists();
        try {
            do {
                GenomeLoc genomeLoc = this.currentInterval = this.intervals.hasNext() ? this.intervals.next() : null;
            } while (this.currentInterval != null && (readLoc == null || this.currentInterval.isBefore(readLoc)));
        }
        catch (ReviewedStingException e) {
            throw new UserException.MissortedFile(new File(this.intervalsFile.getSource()), " *** Are you sure that your interval file is sorted? If not, you must use the --targetIntervalsAreNotSorted argument. ***", e);
        }
        this.sawReadInCurrentInterval = false;
        this.map(ref, read, metaDataTracker);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        if (this.readsToClean.size() > 0) {
            GenomeLoc earliestPossibleMove = this.getToolkit().getGenomeLocParser().createGenomeLoc(this.readsToClean.getReads().get(0));
            if (this.manager.canMoveReads(earliestPossibleMove)) {
                this.clean(this.readsToClean);
            }
            this.emitReadLists();
        } else if (this.readsNotToClean.size() > 0) {
            this.emitReadLists();
        }
        this.knownIndelsToTry.clear();
        this.indelRodsSeen.clear();
        if (this.OUT_INDELS != null) {
            try {
                this.indelOutput.close();
            }
            catch (Exception e) {
                logger.error("Failed to close " + this.OUT_INDELS + " gracefully. Data may be corrupt.");
            }
        }
        if (this.OUT_STATS != null) {
            try {
                this.statsOutput.close();
            }
            catch (Exception e) {
                logger.error("Failed to close " + this.OUT_STATS + " gracefully. Data may be corrupt.");
            }
        }
        if (this.OUT_SNPS != null) {
            try {
                this.snpsOutput.close();
            }
            catch (Exception e) {
                logger.error("Failed to close " + this.OUT_SNPS + " gracefully. Data may be corrupt.");
            }
        }
        this.manager.close();
        if (this.N_WAY_OUT != null) {
            this.writerToUse.close();
        }
        if (this.CHECKEARLY) {
            logger.info("SW alignments runs: " + this.SWalignmentRuns);
            logger.info("SW alignments successfull: " + this.SWalignmentSuccess + " (" + this.SWalignmentSuccess / this.SWalignmentRuns + "% of SW runs)");
            logger.info("SW alignments skipped (perfect match): " + this.exactMatchesFound);
            logger.info("Total reads SW worked for: " + (this.SWalignmentSuccess + this.exactMatchesFound) + " (" + (this.SWalignmentSuccess + this.exactMatchesFound) / (this.SWalignmentRuns + this.exactMatchesFound) + "% of all reads requiring SW)");
        }
    }

    private void populateKnownIndels(ReadMetaDataTracker metaDataTracker, ReferenceContext ref) {
        for (Collection<GATKFeature> rods : metaDataTracker.getContigOffsetMapping().values()) {
            Iterator<GATKFeature> rodIter = rods.iterator();
            while (rodIter.hasNext()) {
                Object rod = rodIter.next().getUnderlyingObject();
                if (this.indelRodsSeen.contains(rod)) continue;
                this.indelRodsSeen.add(rod);
                if (!(rod instanceof VariantContext)) continue;
                this.knownIndelsToTry.add((VariantContext)rod);
            }
        }
    }

    private static int mismatchQualitySumIgnoreCigar(AlignedRead aRead, byte[] refSeq, int refIndex, int quitAboveThisValue) {
        byte[] readSeq = aRead.getReadBases();
        byte[] quals = aRead.getBaseQualities();
        int sum = 0;
        for (int readIndex = 0; readIndex < readSeq.length; ++readIndex) {
            if (refIndex >= refSeq.length) {
                if ((sum += 99) > quitAboveThisValue) {
                    return sum;
                }
            } else {
                byte refChr = refSeq[refIndex];
                byte readChr = readSeq[readIndex];
                if (BaseUtils.isRegularBase(readChr) && BaseUtils.isRegularBase(refChr) && readChr != refChr && (sum += quals[readIndex]) > quitAboveThisValue) {
                    return sum;
                }
            }
            ++refIndex;
        }
        return sum;
    }

    private void clean(ReadBin readsToClean) {
        double improvement;
        List<GATKSAMRecord> reads = readsToClean.getReads();
        if (reads.size() == 0) {
            return;
        }
        byte[] reference = readsToClean.getReference(this.referenceReader);
        int leftmostIndex = readsToClean.getLocation().getStart();
        ArrayList<GATKSAMRecord> refReads = new ArrayList<GATKSAMRecord>();
        ArrayList<AlignedRead> altReads = new ArrayList<AlignedRead>();
        LinkedList<AlignedRead> altAlignmentsToTest = new LinkedList<AlignedRead>();
        LinkedHashSet<Consensus> altConsenses = new LinkedHashSet<Consensus>();
        this.generateAlternateConsensesFromKnownIndels(altConsenses, leftmostIndex, reference);
        long totalRawMismatchSum = this.determineReadsThatNeedCleaning(reads, refReads, altReads, altAlignmentsToTest, altConsenses, leftmostIndex, reference);
        if (this.consensusModel == ConsensusDeterminationModel.USE_SW) {
            this.generateAlternateConsensesFromReads(altAlignmentsToTest, altConsenses, reference, leftmostIndex);
        }
        Consensus bestConsensus = null;
        for (Consensus consensus : altConsenses) {
            for (int j = 0; j < altReads.size(); ++j) {
                AlignedRead toTest = altReads.get(j);
                Pair<Integer, Integer> altAlignment = this.findBestOffset(consensus.str, toTest, leftmostIndex);
                int myScore = (Integer)altAlignment.second;
                if ((long)myScore > toTest.getAlignerMismatchScore() || myScore >= toTest.getMismatchScoreToReference()) {
                    myScore = toTest.getMismatchScoreToReference();
                } else {
                    consensus.readIndexes.add(new Pair(j, altAlignment.first));
                }
                if (!toTest.getRead().getDuplicateReadFlag()) {
                    consensus.mismatchSum += myScore;
                }
                if (bestConsensus != null && consensus.mismatchSum > bestConsensus.mismatchSum) break;
            }
            if (bestConsensus == null || bestConsensus.mismatchSum > consensus.mismatchSum) {
                if (bestConsensus != null) {
                    bestConsensus.readIndexes.clear();
                }
                bestConsensus = consensus;
                continue;
            }
            consensus.readIndexes.clear();
        }
        double d = improvement = bestConsensus == null ? -1.0 : (double)(totalRawMismatchSum - (long)bestConsensus.mismatchSum) / 10.0;
        if (improvement >= this.LOD_THRESHOLD) {
            bestConsensus.cigar = AlignmentUtils.leftAlignIndel(bestConsensus.cigar, reference, bestConsensus.str, bestConsensus.positionOnReference, bestConsensus.positionOnReference);
            for (Pair<Integer, Integer> indexPair : bestConsensus.readIndexes) {
                AlignedRead aRead = altReads.get((Integer)indexPair.first);
                if (this.updateRead(bestConsensus.cigar, bestConsensus.positionOnReference, (Integer)indexPair.second, aRead, leftmostIndex)) continue;
                return;
            }
            if (this.consensusModel != ConsensusDeterminationModel.KNOWNS_ONLY && !this.alternateReducesEntropy(altReads, reference, leftmostIndex)) {
                if (this.statsOutput != null) {
                    try {
                        this.statsOutput.write(this.currentInterval.toString());
                        this.statsOutput.write("\tFAIL (bad indel)\t");
                        this.statsOutput.write(Double.toString(improvement));
                        this.statsOutput.write("\n");
                        this.statsOutput.flush();
                    }
                    catch (Exception e) {
                        throw new UserException.CouldNotCreateOutputFile("statsOutput", "Failed to write stats output file", e);
                    }
                }
            } else {
                if (this.indelOutput != null && bestConsensus.cigar.numCigarElements() > 1) {
                    int i;
                    StringBuilder str = new StringBuilder();
                    str.append(reads.get(0).getReferenceName());
                    int position = bestConsensus.positionOnReference + bestConsensus.cigar.getCigarElement(0).getLength();
                    str.append("\t" + (leftmostIndex + position - 1));
                    CigarElement ce = bestConsensus.cigar.getCigarElement(1);
                    str.append("\t" + ce.getLength() + "\t" + (Object)((Object)ce.getOperator()) + "\t");
                    int length = ce.getLength();
                    if (ce.getOperator() == CigarOperator.D) {
                        for (i = 0; i < length; ++i) {
                            str.append((char)reference[position + i]);
                        }
                    } else {
                        for (i = 0; i < length; ++i) {
                            str.append((char)bestConsensus.str[position + i]);
                        }
                    }
                    str.append("\t" + (double)(totalRawMismatchSum - (long)bestConsensus.mismatchSum) / 10.0 + "\n");
                    try {
                        this.indelOutput.write(str.toString());
                        this.indelOutput.flush();
                    }
                    catch (Exception e) {
                        throw new UserException.CouldNotCreateOutputFile("indelOutput", "Failed to write indel output file", e);
                    }
                }
                if (this.statsOutput != null) {
                    try {
                        this.statsOutput.write(this.currentInterval.toString());
                        this.statsOutput.write("\tCLEAN");
                        if (bestConsensus.cigar.numCigarElements() > 1) {
                            this.statsOutput.write(" (found indel)");
                        }
                        this.statsOutput.write("\t");
                        this.statsOutput.write(Double.toString(improvement));
                        this.statsOutput.write("\n");
                        this.statsOutput.flush();
                    }
                    catch (Exception e) {
                        throw new UserException.CouldNotCreateOutputFile("statsOutput", "Failed to write stats output file", e);
                    }
                }
                for (Pair<Integer, Integer> indexPair : bestConsensus.readIndexes) {
                    int neededBasesToRight;
                    int neededBasesToLeft;
                    int neededBases;
                    AlignedRead aRead = altReads.get((Integer)indexPair.first);
                    if (!aRead.finalizeUpdate()) continue;
                    GATKSAMRecord read = aRead.getRead();
                    if (read.getMappingQuality() != 255) {
                        read.setMappingQuality(Math.min(aRead.getRead().getMappingQuality() + 10, 254));
                    }
                    if ((neededBases = Math.max(neededBasesToLeft = leftmostIndex - read.getAlignmentStart(), neededBasesToRight = read.getAlignmentEnd() - leftmostIndex - reference.length + 1)) > 0) {
                        int padLeft = Math.max(leftmostIndex - neededBases, 1);
                        int padRight = Math.min(leftmostIndex + reference.length + neededBases, this.referenceReader.getSequenceDictionary().getSequence(this.currentInterval.getContig()).getSequenceLength());
                        reference = this.referenceReader.getSubsequenceAt(this.currentInterval.getContig(), padLeft, padRight).getBases();
                        leftmostIndex = padLeft;
                    }
                    try {
                        if (read.getAttribute(SAMTag.NM.name()) != null) {
                            read.setAttribute(SAMTag.NM.name(), (Object)SequenceUtil.calculateSamNmTag((SAMRecord)read, reference, leftmostIndex - 1));
                        }
                        if (read.getAttribute(SAMTag.UQ.name()) != null) {
                            read.setAttribute(SAMTag.UQ.name(), (Object)SequenceUtil.sumQualitiesOfMismatches((SAMRecord)read, reference, leftmostIndex - 1));
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (read.getAttribute(SAMTag.MD.name()) != null) {
                        read.setAttribute(SAMTag.MD.name(), null);
                    }
                    this.readsActuallyCleaned.add(read);
                }
            }
        } else if (this.statsOutput != null) {
            try {
                this.statsOutput.write(String.format("%s\tFAIL\t%.1f%n", this.currentInterval.toString(), improvement));
                this.statsOutput.flush();
            }
            catch (Exception e) {
                throw new UserException.CouldNotCreateOutputFile("statsOutput", "Failed to write stats output file", e);
            }
        }
    }

    private void generateAlternateConsensesFromKnownIndels(Set<Consensus> altConsensesToPopulate, int leftmostIndex, byte[] reference) {
        for (VariantContext knownIndel : this.knownIndelsToTry) {
            byte[] indelStr;
            if (knownIndel == null || !knownIndel.isIndel() || knownIndel.isComplexIndel()) continue;
            byte[] byArray = indelStr = knownIndel.isSimpleInsertion() ? knownIndel.getAlternateAllele(0).getBases() : Utils.dupBytes((byte)45, knownIndel.getReference().length());
            int start = knownIndel.getStart() - leftmostIndex + 1;
            Consensus c = this.createAlternateConsensus(start, reference, indelStr, knownIndel);
            if (c == null) continue;
            altConsensesToPopulate.add(c);
        }
    }

    private long determineReadsThatNeedCleaning(List<GATKSAMRecord> reads, ArrayList<GATKSAMRecord> refReadsToPopulate, ArrayList<AlignedRead> altReadsToPopulate, LinkedList<AlignedRead> altAlignmentsToTest, Set<Consensus> altConsenses, int leftmostIndex, byte[] reference) {
        long totalRawMismatchSum = 0L;
        for (GATKSAMRecord read : reads) {
            int startOnRef;
            int rawMismatchScore;
            if (read.getCigar().numCigarElements() == 0) {
                refReadsToPopulate.add(read);
                continue;
            }
            AlignedRead aRead = new AlignedRead(read);
            int numBlocks = AlignmentUtils.getNumAlignmentBlocks(read);
            if (numBlocks == 2) {
                Cigar newCigar = AlignmentUtils.leftAlignIndel(IndelRealigner.unclipCigar(read.getCigar()), reference, read.getReadBases(), read.getAlignmentStart() - leftmostIndex, 0);
                aRead.setCigar(newCigar, false);
            }
            if ((rawMismatchScore = IndelRealigner.mismatchQualitySumIgnoreCigar(aRead, reference, startOnRef = read.getAlignmentStart() - leftmostIndex, Integer.MAX_VALUE)) > 0) {
                altReadsToPopulate.add(aRead);
                if (!read.getDuplicateReadFlag()) {
                    totalRawMismatchSum += (long)rawMismatchScore;
                }
                aRead.setMismatchScoreToReference(rawMismatchScore);
                aRead.setAlignerMismatchScore(AlignmentUtils.mismatchingQualities(aRead.getRead(), reference, startOnRef));
                if (this.consensusModel != ConsensusDeterminationModel.KNOWNS_ONLY && numBlocks == 2) {
                    Consensus c = this.createAlternateConsensus(startOnRef, aRead.getCigar(), reference, aRead.getReadBases());
                    if (c == null) continue;
                    altConsenses.add(c);
                    continue;
                }
                altAlignmentsToTest.add(aRead);
                continue;
            }
            refReadsToPopulate.add(read);
        }
        return totalRawMismatchSum;
    }

    private void generateAlternateConsensesFromReads(LinkedList<AlignedRead> altAlignmentsToTest, Set<Consensus> altConsensesToPopulate, byte[] reference, int leftmostIndex) {
        if (altAlignmentsToTest.size() <= this.MAX_READS_FOR_CONSENSUSES) {
            for (AlignedRead aRead : altAlignmentsToTest) {
                if (this.CHECKEARLY) {
                    this.createAndAddAlternateConsensus1(aRead, altConsensesToPopulate, reference, leftmostIndex);
                    continue;
                }
                this.createAndAddAlternateConsensus(aRead.getReadBases(), altConsensesToPopulate, reference);
            }
        } else {
            int readsSeen = 0;
            while (readsSeen++ < this.MAX_READS_FOR_CONSENSUSES && altConsensesToPopulate.size() <= this.MAX_CONSENSUSES) {
                int index = GenomeAnalysisEngine.getRandomGenerator().nextInt(altAlignmentsToTest.size());
                AlignedRead aRead = altAlignmentsToTest.remove(index);
                if (this.CHECKEARLY) {
                    this.createAndAddAlternateConsensus1(aRead, altConsensesToPopulate, reference, leftmostIndex);
                    continue;
                }
                this.createAndAddAlternateConsensus(aRead.getReadBases(), altConsensesToPopulate, reference);
            }
        }
    }

    private void createAndAddAlternateConsensus(byte[] read, Set<Consensus> altConsensesToPopulate, byte[] reference) {
        SWPairwiseAlignment swConsensus = new SWPairwiseAlignment(reference, read, 30.0, -10.0, -10.0, -2.0);
        Consensus c = this.createAlternateConsensus(swConsensus.getAlignmentStart2wrt1(), swConsensus.getCigar(), reference, read);
        if (c != null) {
            altConsensesToPopulate.add(c);
        }
    }

    private void createAndAddAlternateConsensus1(AlignedRead read, Set<Consensus> altConsensesToPopulate, byte[] reference, int leftmostIndex) {
        for (Consensus known : altConsensesToPopulate) {
            Pair<Integer, Integer> altAlignment = this.findBestOffset(known.str, read, leftmostIndex);
            int myScore = (Integer)altAlignment.second;
            if (myScore != 0) continue;
            ++this.exactMatchesFound;
            return;
        }
        ++this.SWalignmentRuns;
        SWPairwiseAlignment swConsensus = new SWPairwiseAlignment(reference, read.getReadBases(), 30.0, -10.0, -10.0, -2.0);
        Consensus c = this.createAlternateConsensus(swConsensus.getAlignmentStart2wrt1(), swConsensus.getCigar(), reference, read.getReadBases());
        if (c != null) {
            altConsensesToPopulate.add(c);
            ++this.SWalignmentSuccess;
        }
    }

    private Consensus createAlternateConsensus(int indexOnRef, Cigar c, byte[] reference, byte[] readStr) {
        int i;
        if (indexOnRef < 0) {
            return null;
        }
        if (c.numCigarElements() == 1 && c.getCigarElement(0).getOperator() == CigarOperator.M) {
            return null;
        }
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(c.numCigarElements() - 1);
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < indexOnRef; ++i2) {
            sb.append((char)reference[i2]);
        }
        int indelCount = 0;
        int altIdx = 0;
        int refIdx = indexOnRef;
        boolean ok_flag = true;
        block7: for (i = 0; i < c.numCigarElements(); ++i) {
            CigarElement ce = c.getCigarElement(i);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case D: {
                    refIdx += elementLength;
                    ++indelCount;
                    elements.add(ce);
                    continue block7;
                }
                case M: {
                    altIdx += elementLength;
                }
                case N: {
                    int j;
                    if (reference.length < refIdx + elementLength) {
                        ok_flag = false;
                    } else {
                        for (j = 0; j < elementLength; ++j) {
                            sb.append((char)reference[refIdx + j]);
                        }
                    }
                    refIdx += elementLength;
                    elements.add(new CigarElement(elementLength, CigarOperator.M));
                    continue block7;
                }
                case I: {
                    int j;
                    for (j = 0; j < elementLength; ++j) {
                        if (!BaseUtils.isRegularBase(readStr[altIdx + j])) {
                            ok_flag = false;
                            break;
                        }
                        sb.append((char)readStr[altIdx + j]);
                    }
                    altIdx += elementLength;
                    ++indelCount;
                    elements.add(ce);
                    continue block7;
                }
            }
        }
        if (!ok_flag || indelCount != 1 || reference.length < refIdx) {
            return null;
        }
        for (i = refIdx; i < reference.length; ++i) {
            sb.append((char)reference[i]);
        }
        byte[] altConsensus = StringUtil.stringToBytes(sb.toString());
        return new Consensus(altConsensus, new Cigar(elements), indexOnRef);
    }

    private Consensus createAlternateConsensus(int indexOnRef, byte[] reference, byte[] indelStr, VariantContext indel) {
        int refIdx;
        if (indexOnRef < 0 || indexOnRef >= reference.length) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Cigar cigar = new Cigar();
        for (refIdx = 0; refIdx < indexOnRef; ++refIdx) {
            sb.append((char)reference[refIdx]);
        }
        if (indexOnRef > 0) {
            cigar.add(new CigarElement(indexOnRef, CigarOperator.M));
        }
        if (indel.isSimpleDeletion()) {
            refIdx += indelStr.length;
            cigar.add(new CigarElement(indelStr.length, CigarOperator.D));
        } else if (indel.isSimpleInsertion()) {
            for (byte b : indelStr) {
                sb.append((char)b);
            }
            cigar.add(new CigarElement(indelStr.length, CigarOperator.I));
        } else {
            throw new IllegalStateException("Creating an alternate consensus from a complex indel is not allows");
        }
        if (reference.length - refIdx > 0) {
            cigar.add(new CigarElement(reference.length - refIdx, CigarOperator.M));
        }
        while (refIdx < reference.length) {
            sb.append((char)reference[refIdx]);
            ++refIdx;
        }
        byte[] altConsensus = StringUtil.stringToBytes(sb.toString());
        return new Consensus(altConsensus, cigar, 0);
    }

    private Pair<Integer, Integer> findBestOffset(byte[] ref, AlignedRead read, int leftmostIndex) {
        int originalAlignment = read.getOriginalAlignmentStart() - leftmostIndex;
        int bestScore = IndelRealigner.mismatchQualitySumIgnoreCigar(read, ref, originalAlignment, Integer.MAX_VALUE);
        int bestIndex = originalAlignment;
        if (bestScore == 0) {
            return new Pair<Integer, Integer>(bestIndex, 0);
        }
        for (int i = 0; i < originalAlignment; ++i) {
            int score = IndelRealigner.mismatchQualitySumIgnoreCigar(read, ref, i, bestScore);
            if (score < bestScore) {
                bestScore = score;
                bestIndex = i;
            }
            if (bestScore != 0) continue;
            return new Pair<Integer, Integer>(bestIndex, 0);
        }
        int maxPossibleStart = ref.length - read.getReadLength();
        for (int i = originalAlignment + 1; i <= maxPossibleStart; ++i) {
            int score = IndelRealigner.mismatchQualitySumIgnoreCigar(read, ref, i, bestScore);
            if (score < bestScore) {
                bestScore = score;
                bestIndex = i;
            }
            if (bestScore != 0) continue;
            return new Pair<Integer, Integer>(bestIndex, 0);
        }
        return new Pair<Integer, Integer>(bestIndex, bestScore);
    }

    private boolean updateRead(Cigar altCigar, int altPosOnRef, int myPosOnAlt, AlignedRead aRead, int leftmostIndex) {
        CigarElement indelCE;
        Cigar readCigar = new Cigar();
        if (altCigar.getCigarElements().size() == 1) {
            aRead.setAlignmentStart(leftmostIndex + myPosOnAlt);
            readCigar.add(new CigarElement(aRead.getReadLength(), CigarOperator.M));
            aRead.setCigar(readCigar);
            return true;
        }
        CigarElement altCE1 = altCigar.getCigarElement(0);
        CigarElement altCE2 = altCigar.getCigarElement(1);
        int leadingMatchingBlockLength = 0;
        if (altCE1.getOperator() == CigarOperator.I) {
            indelCE = altCE1;
            if (altCE2.getOperator() != CigarOperator.M) {
                logger.warn("When the first element of the alt consensus is I, the second one must be M. Actual: " + altCigar.toString() + ".  Skipping this site...");
                return false;
            }
        } else {
            if (altCE1.getOperator() != CigarOperator.M) {
                logger.warn("First element of the alt consensus cigar must be M or I. Actual: " + altCigar.toString() + ".  Skipping this site...");
                return false;
            }
            if (altCE2.getOperator() != CigarOperator.I && altCE2.getOperator() != CigarOperator.D) {
                logger.warn("When first element of the alt consensus is M, the second one must be I or D. Actual: " + altCigar.toString() + ".  Skipping this site...");
                return false;
            }
            indelCE = altCE2;
            leadingMatchingBlockLength = altCE1.getLength();
        }
        int endOfFirstBlock = altPosOnRef + leadingMatchingBlockLength;
        boolean sawAlignmentStart = false;
        if (myPosOnAlt < endOfFirstBlock) {
            aRead.setAlignmentStart(leftmostIndex + myPosOnAlt);
            sawAlignmentStart = true;
            if (myPosOnAlt + aRead.getReadLength() <= endOfFirstBlock) {
                aRead.setCigar(null);
                return true;
            }
            readCigar.add(new CigarElement(endOfFirstBlock - myPosOnAlt, CigarOperator.M));
        }
        if (indelCE.getOperator() == CigarOperator.I) {
            if (myPosOnAlt + aRead.getReadLength() < endOfFirstBlock + indelCE.getLength()) {
                int partialInsertionLength = myPosOnAlt + aRead.getReadLength() - endOfFirstBlock;
                if (!sawAlignmentStart) {
                    partialInsertionLength = aRead.getReadLength();
                }
                readCigar.add(new CigarElement(partialInsertionLength, CigarOperator.I));
                aRead.setCigar(readCigar);
                return true;
            }
            if (!sawAlignmentStart && myPosOnAlt < endOfFirstBlock + indelCE.getLength()) {
                aRead.setAlignmentStart(leftmostIndex + endOfFirstBlock);
                readCigar.add(new CigarElement(indelCE.getLength() - (myPosOnAlt - endOfFirstBlock), CigarOperator.I));
                sawAlignmentStart = true;
            } else if (sawAlignmentStart) {
                readCigar.add(indelCE);
            }
        } else if (indelCE.getOperator() == CigarOperator.D && sawAlignmentStart) {
            readCigar.add(indelCE);
        }
        if (!sawAlignmentStart) {
            aRead.setCigar(null);
            return true;
        }
        int readRemaining = aRead.getReadBases().length;
        for (CigarElement ce : readCigar.getCigarElements()) {
            if (ce.getOperator() == CigarOperator.D) continue;
            readRemaining -= ce.getLength();
        }
        if (readRemaining > 0) {
            readCigar.add(new CigarElement(readRemaining, CigarOperator.M));
        }
        aRead.setCigar(readCigar);
        return true;
    }

    private boolean alternateReducesEntropy(List<AlignedRead> reads, byte[] reference, int leftmostIndex) {
        boolean reduces;
        int i;
        int[] originalMismatchBases = new int[reference.length];
        int[] cleanedMismatchBases = new int[reference.length];
        int[] totalOriginalBases = new int[reference.length];
        int[] totalCleanedBases = new int[reference.length];
        for (i = 0; i < reference.length; ++i) {
            totalCleanedBases[i] = 0;
            cleanedMismatchBases[i] = 0;
            totalOriginalBases[i] = 0;
            originalMismatchBases[i] = 0;
        }
        for (i = 0; i < reads.size(); ++i) {
            AlignedRead read = reads.get(i);
            if (read.getRead().getAlignmentBlocks().size() > 1) continue;
            int refIdx = read.getOriginalAlignmentStart() - leftmostIndex;
            byte[] readStr = read.getReadBases();
            byte[] quals = read.getBaseQualities();
            for (int j = 0; j < readStr.length && refIdx >= 0 && refIdx < reference.length; ++j, ++refIdx) {
                int n = refIdx;
                totalOriginalBases[n] = totalOriginalBases[n] + quals[j];
                if (readStr[j] == reference[refIdx]) continue;
                int n2 = refIdx;
                originalMismatchBases[n2] = originalMismatchBases[n2] + quals[j];
            }
            refIdx = read.getAlignmentStart() - leftmostIndex;
            int altIdx = 0;
            Cigar c = read.getCigar();
            block10: for (int j = 0; j < c.numCigarElements(); ++j) {
                CigarElement ce = c.getCigarElement(j);
                int elementLength = ce.getLength();
                switch (ce.getOperator()) {
                    case M: {
                        int k = 0;
                        while (k < elementLength && refIdx < reference.length) {
                            int n = refIdx;
                            totalCleanedBases[n] = totalCleanedBases[n] + quals[altIdx];
                            if (readStr[altIdx] != reference[refIdx]) {
                                int n3 = refIdx;
                                cleanedMismatchBases[n3] = cleanedMismatchBases[n3] + quals[altIdx];
                            }
                            ++k;
                            ++refIdx;
                            ++altIdx;
                        }
                        continue block10;
                    }
                    case I: {
                        altIdx += elementLength;
                        continue block10;
                    }
                    case D: {
                        refIdx += elementLength;
                        continue block10;
                    }
                }
            }
        }
        int originalMismatchColumns = 0;
        int cleanedMismatchColumns = 0;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < reference.length; ++i2) {
            if (cleanedMismatchBases[i2] == originalMismatchBases[i2]) continue;
            boolean didMismatch = false;
            boolean stillMismatches = false;
            if ((double)originalMismatchBases[i2] > (double)totalOriginalBases[i2] * this.MISMATCH_THRESHOLD) {
                didMismatch = true;
                ++originalMismatchColumns;
                if (totalCleanedBases[i2] > 0 && (double)cleanedMismatchBases[i2] / (double)totalCleanedBases[i2] > (double)originalMismatchBases[i2] / (double)totalOriginalBases[i2] * 0.25) {
                    stillMismatches = true;
                    ++cleanedMismatchColumns;
                }
            } else if ((double)cleanedMismatchBases[i2] > (double)totalCleanedBases[i2] * this.MISMATCH_THRESHOLD) {
                ++cleanedMismatchColumns;
            }
            if (this.snpsOutput == null || !didMismatch) continue;
            sb.append(reads.get(0).getRead().getReferenceName() + ":");
            sb.append(leftmostIndex + i2);
            if (stillMismatches) {
                sb.append(" SAME_SNP\n");
                continue;
            }
            sb.append(" NOT_SNP\n");
        }
        boolean bl = reduces = originalMismatchColumns == 0 || cleanedMismatchColumns < originalMismatchColumns;
        if (reduces && this.snpsOutput != null) {
            try {
                this.snpsOutput.write(sb.toString());
                this.snpsOutput.flush();
            }
            catch (Exception e) {
                throw new UserException.CouldNotCreateOutputFile("snpsOutput", "Failed to write SNPs output file", e);
            }
        }
        return reduces;
    }

    protected static Cigar unclipCigar(Cigar cigar) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(cigar.numCigarElements());
        for (CigarElement ce : cigar.getCigarElements()) {
            if (IndelRealigner.isClipOperator(ce.getOperator())) continue;
            elements.add(ce);
        }
        return new Cigar(elements);
    }

    private static boolean isClipOperator(CigarOperator op) {
        return op == CigarOperator.S || op == CigarOperator.H || op == CigarOperator.P;
    }

    protected static Cigar reclipCigar(Cigar cigar, SAMRecord read) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        int i = 0;
        int n = read.getCigar().numCigarElements();
        while (i < n && IndelRealigner.isClipOperator(read.getCigar().getCigarElement(i).getOperator())) {
            elements.add(read.getCigar().getCigarElement(i++));
        }
        elements.addAll(cigar.getCigarElements());
        ++i;
        while (i < n && !IndelRealigner.isClipOperator(read.getCigar().getCigarElement(i).getOperator())) {
            ++i;
        }
        while (i < n && IndelRealigner.isClipOperator(read.getCigar().getCigarElement(i).getOperator())) {
            elements.add(read.getCigar().getCigarElement(i++));
        }
        return new Cigar(elements);
    }

    private class ReadBin
    implements HasGenomeLocation {
        private final ArrayList<GATKSAMRecord> reads = new ArrayList();
        private byte[] reference = null;
        private GenomeLoc loc = null;

        public void add(GATKSAMRecord read) {
            GenomeLoc locForRead = IndelRealigner.this.getToolkit().getGenomeLocParser().createGenomeLoc(read);
            if (this.loc == null) {
                this.loc = locForRead;
            } else if (locForRead.getStop() > this.loc.getStop()) {
                this.loc = IndelRealigner.this.getToolkit().getGenomeLocParser().createGenomeLoc(this.loc.getContig(), this.loc.getStart(), locForRead.getStop());
            }
            this.reads.add(read);
        }

        public List<GATKSAMRecord> getReads() {
            return this.reads;
        }

        public byte[] getReference(IndexedFastaSequenceFile referenceReader) {
            if (this.reference == null) {
                int padLeft = Math.max(this.loc.getStart() - 30, 1);
                int padRight = Math.min(this.loc.getStop() + 30, referenceReader.getSequenceDictionary().getSequence(this.loc.getContig()).getSequenceLength());
                this.loc = IndelRealigner.this.getToolkit().getGenomeLocParser().createGenomeLoc(this.loc.getContig(), padLeft, padRight);
                this.reference = referenceReader.getSubsequenceAt(this.loc.getContig(), this.loc.getStart(), this.loc.getStop()).getBases();
                StringUtil.toUpperCase(this.reference);
            }
            return this.reference;
        }

        @Override
        public GenomeLoc getLocation() {
            return this.loc;
        }

        public int size() {
            return this.reads.size();
        }

        public void clear() {
            this.reads.clear();
            this.reference = null;
            this.loc = null;
        }
    }

    private static class Consensus {
        public final byte[] str;
        public final ArrayList<Pair<Integer, Integer>> readIndexes;
        public final int positionOnReference;
        public int mismatchSum;
        public Cigar cigar;

        public Consensus(byte[] str, Cigar cigar, int positionOnReference) {
            this.str = str;
            this.cigar = cigar;
            this.positionOnReference = positionOnReference;
            this.mismatchSum = 0;
            this.readIndexes = new ArrayList();
        }

        public boolean equals(Object o) {
            return this == o || o instanceof Consensus && Arrays.equals(this.str, ((Consensus)o).str);
        }

        public boolean equals(Consensus c) {
            return this == c || Arrays.equals(this.str, c.str);
        }

        public int hashCode() {
            return Arrays.hashCode(this.str);
        }
    }

    private class AlignedRead {
        private final GATKSAMRecord read;
        private byte[] readBases = null;
        private byte[] baseQuals = null;
        private Cigar newCigar = null;
        private int newStart = -1;
        private int mismatchScoreToReference = 0;
        private long alignerMismatchScore = 0L;

        public AlignedRead(GATKSAMRecord read) {
            this.read = read;
            this.mismatchScoreToReference = 0;
        }

        public GATKSAMRecord getRead() {
            return this.read;
        }

        public int getReadLength() {
            return this.readBases != null ? this.readBases.length : this.read.getReadLength();
        }

        public byte[] getReadBases() {
            if (this.readBases == null) {
                this.getUnclippedBases();
            }
            return this.readBases;
        }

        public byte[] getBaseQualities() {
            if (this.baseQuals == null) {
                this.getUnclippedBases();
            }
            return this.baseQuals;
        }

        private void getUnclippedBases() {
            this.readBases = new byte[this.getReadLength()];
            this.baseQuals = new byte[this.getReadLength()];
            byte[] actualReadBases = this.read.getReadBases();
            byte[] actualBaseQuals = this.read.getBaseQualities();
            int fromIndex = 0;
            int toIndex = 0;
            for (CigarElement ce : this.read.getCigar().getCigarElements()) {
                int elementLength = ce.getLength();
                switch (ce.getOperator()) {
                    case S: {
                        fromIndex += elementLength;
                        break;
                    }
                    case M: 
                    case I: {
                        System.arraycopy(actualReadBases, fromIndex, this.readBases, toIndex, elementLength);
                        System.arraycopy(actualBaseQuals, fromIndex, this.baseQuals, toIndex, elementLength);
                        fromIndex += elementLength;
                        toIndex += elementLength;
                    }
                }
            }
            if (fromIndex != toIndex) {
                byte[] trimmedRB = new byte[toIndex];
                byte[] trimmedBQ = new byte[toIndex];
                System.arraycopy(this.readBases, 0, trimmedRB, 0, toIndex);
                System.arraycopy(this.baseQuals, 0, trimmedBQ, 0, toIndex);
                this.readBases = trimmedRB;
                this.baseQuals = trimmedBQ;
            }
        }

        public Cigar getCigar() {
            return this.newCigar != null ? this.newCigar : this.read.getCigar();
        }

        public void setCigar(Cigar cigar) {
            this.setCigar(cigar, true);
        }

        public void setCigar(Cigar cigar, boolean fixClippedCigar) {
            if (cigar == null) {
                this.newCigar = null;
                return;
            }
            if (fixClippedCigar && this.getReadBases().length < this.read.getReadLength()) {
                cigar = this.reclipCigar(cigar);
            }
            if (this.read.getCigar().equals(cigar)) {
                this.newCigar = null;
                return;
            }
            String str = cigar.toString();
            if (!str.contains("D") && !str.contains("I")) {
                logger.debug("Modifying a read with no associated indel; although this is possible, it is highly unlikely.  Perhaps this region should be double-checked: " + this.read.getReadName() + " near " + this.read.getReferenceName() + ":" + this.read.getAlignmentStart());
            }
            this.newCigar = cigar;
        }

        private Cigar reclipCigar(Cigar cigar) {
            return IndelRealigner.reclipCigar(cigar, this.read);
        }

        public void setAlignmentStart(int start) {
            this.newStart = start;
        }

        public int getAlignmentStart() {
            return this.newStart != -1 ? this.newStart : this.read.getAlignmentStart();
        }

        public int getOriginalAlignmentStart() {
            return this.read.getAlignmentStart();
        }

        public boolean finalizeUpdate() {
            if (this.newCigar == null) {
                return false;
            }
            if (this.newStart == -1) {
                this.newStart = this.read.getAlignmentStart();
            } else if (Math.abs(this.newStart - this.read.getAlignmentStart()) > IndelRealigner.this.MAX_POS_MOVE_ALLOWED) {
                logger.debug(String.format("Attempting to realign read %s at %d more than %d bases to %d.", this.read.getReadName(), this.read.getAlignmentStart(), IndelRealigner.this.MAX_POS_MOVE_ALLOWED, this.newStart));
                return false;
            }
            if (!IndelRealigner.this.NO_ORIGINAL_ALIGNMENT_TAGS) {
                this.read.setAttribute(IndelRealigner.ORIGINAL_CIGAR_TAG, (Object)this.read.getCigar().toString());
                if (this.newStart != this.read.getAlignmentStart()) {
                    this.read.setAttribute(IndelRealigner.ORIGINAL_POSITION_TAG, (Object)this.read.getAlignmentStart());
                }
            }
            this.read.setCigar(this.newCigar);
            this.read.setAlignmentStart(this.newStart);
            return true;
        }

        public void setMismatchScoreToReference(int score) {
            this.mismatchScoreToReference = score;
        }

        public int getMismatchScoreToReference() {
            return this.mismatchScoreToReference;
        }

        public void setAlignerMismatchScore(long score) {
            this.alignerMismatchScore = score;
        }

        public long getAlignerMismatchScore() {
            return this.alignerMismatchScore;
        }
    }

    public static enum ConsensusDeterminationModel {
        KNOWNS_ONLY,
        USE_READS,
        USE_SW;

    }
}

