/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.genotyper.AlleleFrequencyCalculationResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public abstract class AlleleFrequencyCalculationModel
implements Cloneable {
    protected int N;
    protected int MAX_ALTERNATE_ALLELES_TO_GENOTYPE;
    protected Logger logger;
    protected PrintStream verboseWriter;
    protected static final double VALUE_NOT_CALCULATED = Double.NEGATIVE_INFINITY;

    protected AlleleFrequencyCalculationModel(UnifiedArgumentCollection UAC, int N, Logger logger, PrintStream verboseWriter) {
        this.N = N;
        this.MAX_ALTERNATE_ALLELES_TO_GENOTYPE = UAC.MAX_ALTERNATE_ALLELES;
        this.logger = logger;
        this.verboseWriter = verboseWriter;
    }

    protected static ArrayList<double[]> getGLs(GenotypesContext GLs) {
        ArrayList<double[]> genotypeLikelihoods = new ArrayList<double[]>(GLs.size());
        genotypeLikelihoods.add(new double[]{0.0, 0.0, 0.0});
        for (Genotype sample : GLs.iterateInSampleNameOrder()) {
            double[] gls;
            if (!sample.hasLikelihoods() || !(MathUtils.sum(gls = sample.getLikelihoods().getAsVector()) < -0.1)) continue;
            genotypeLikelihoods.add(gls);
        }
        return genotypeLikelihoods;
    }

    protected abstract List<Allele> getLog10PNonRef(VariantContext var1, double[] var2, AlleleFrequencyCalculationResult var3);

    protected abstract GenotypesContext subsetAlleles(VariantContext var1, List<Allele> var2, boolean var3, int var4);

    protected static final class LikelihoodSum
    implements Comparable<LikelihoodSum> {
        public double sum = 0.0;
        public Allele allele;

        public LikelihoodSum(Allele allele) {
            this.allele = allele;
        }

        @Override
        public int compareTo(LikelihoodSum other) {
            double diff = this.sum - other.sum;
            return diff < 0.0 ? 1 : (diff > 0.0 ? -1 : 0);
        }
    }

    protected static enum GenotypeType {
        AA,
        AB,
        BB;

    }

    public static enum Model {
        EXACT,
        POOL;

    }
}

