/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.filters;

import java.util.HashSet;
import java.util.Set;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class PlatformUnitFilter
extends ReadFilter {
    private static Set<String> blackListedLanes = new HashSet<String>();

    @Override
    public boolean filterOut(SAMRecord samRecord) {
        if (blackListedLanes.size() == 0) {
            return false;
        }
        Object pu_attr = samRecord.getAttribute("PU");
        if (pu_attr == null) {
            SAMReadGroupRecord rgr = samRecord.getReadGroup();
            if (rgr == null) {
                throw new UserException.MalformedBAM(samRecord, "Read " + samRecord.getReadName() + " has NO associated read group record");
            }
            pu_attr = rgr.getAttribute("PU");
        }
        if (pu_attr == null) {
            return false;
        }
        return blackListedLanes.contains((String)pu_attr);
    }

    public static void setBlackListedLanes(String arg) {
        String[] lanes = arg.split(",");
        for (int i = 0; i < lanes.length; ++i) {
            blackListedLanes.add(lanes[i].trim());
        }
    }

    public static void addBlackListedLane(String arg) {
        blackListedLanes.add(arg.trim());
    }
}

