/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.sf.picard.reference.IndexedFastaSequenceFile;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMSequenceDictionary;
import org.apache.log4j.Logger;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.ArgumentException;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.CommandLineUtils;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.sting.gatk.DownsamplingMethod;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.WalkerManager;
import org.broadinstitute.sting.gatk.arguments.GATKArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.ValidationExclusion;
import org.broadinstitute.sting.gatk.datasources.reads.LocusShardBalancer;
import org.broadinstitute.sting.gatk.datasources.reads.ReadShardBalancer;
import org.broadinstitute.sting.gatk.datasources.reads.SAMDataSource;
import org.broadinstitute.sting.gatk.datasources.reads.SAMReaderID;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.datasources.reference.ReferenceDataSource;
import org.broadinstitute.sting.gatk.datasources.rmd.ReferenceOrderedDataSource;
import org.broadinstitute.sting.gatk.executive.MicroScheduler;
import org.broadinstitute.sting.gatk.filters.FilterManager;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.gatk.filters.ReadGroupBlackListFilter;
import org.broadinstitute.sting.gatk.io.OutputTracker;
import org.broadinstitute.sting.gatk.io.stubs.Stub;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.RMDTriplet;
import org.broadinstitute.sting.gatk.resourcemanagement.ThreadAllocation;
import org.broadinstitute.sting.gatk.samples.SampleDB;
import org.broadinstitute.sting.gatk.samples.SampleDBBuilder;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.DuplicateWalker;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.gatk.walkers.ReadPairWalker;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.SequenceDictionaryUtils;
import org.broadinstitute.sting.utils.baq.BAQ;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;
import org.broadinstitute.sting.utils.interval.IntervalUtils;
import org.broadinstitute.sting.utils.recalibration.BaseRecalibration;

public class GenomeAnalysisEngine {
    private static Logger logger = Logger.getLogger(GenomeAnalysisEngine.class);
    private ParsingEngine parsingEngine;
    private GenomeLocParser genomeLocParser;
    private SAMDataSource readsDataSource = null;
    private ReferenceDataSource referenceDataSource = null;
    private SampleDB sampleDB = null;
    private List<ReferenceOrderedDataSource> rodDataSources;
    private GATKArgumentCollection argCollection;
    private GenomeLocSortedSet intervals = null;
    private Map<ArgumentSource, Object> inputs = new HashMap<ArgumentSource, Object>();
    private Collection<Stub<?>> outputs = new ArrayList();
    private Collection<ReadFilter> filters;
    private ThreadAllocation threadAllocation;
    private String myName = "GATK_" + Math.abs(GenomeAnalysisEngine.getRandomGenerator().nextInt());
    private final WalkerManager walkerManager = new WalkerManager();
    private Walker<?, ?> walker;
    private Collection<SAMReaderID> samReaderIDs = Collections.emptyList();
    private Collection<RMDTriplet> referenceMetaDataFiles;
    private static final long GATK_RANDOM_SEED = 47382911L;
    private static Random randomGenerator = new Random(47382911L);
    private BaseRecalibration baseRecalibration = null;
    private final FilterManager filterManager = new FilterManager();
    private Date startTime = null;

    public void setIntervals(GenomeLocSortedSet intervals) {
        this.intervals = intervals;
    }

    public void setWalker(Walker<?, ?> walker) {
        this.walker = walker;
    }

    public void setSAMFileIDs(Collection<SAMReaderID> samReaderIDs) {
        this.samReaderIDs = samReaderIDs;
    }

    public void setReferenceMetaDataFiles(Collection<RMDTriplet> referenceMetaDataFiles) {
        this.referenceMetaDataFiles = referenceMetaDataFiles;
    }

    public static Random getRandomGenerator() {
        return randomGenerator;
    }

    public static void resetRandomGenerator() {
        randomGenerator.setSeed(47382911L);
    }

    public static void resetRandomGenerator(long seed) {
        randomGenerator.setSeed(seed);
    }

    public BaseRecalibration getBaseRecalibration() {
        return this.baseRecalibration;
    }

    public boolean hasBaseRecalibration() {
        return this.baseRecalibration != null;
    }

    public void setBaseRecalibration(File recalFile, int quantizationLevels) {
        this.baseRecalibration = new BaseRecalibration(recalFile, quantizationLevels);
    }

    public Object execute() {
        this.setStartTime(new Date());
        if (this.getArguments() == null) {
            throw new ReviewedStingException("The GATKArgumentCollection passed to GenomeAnalysisEngine can not be null.");
        }
        if (this.walker == null) {
            throw new ReviewedStingException("The walker passed to GenomeAnalysisEngine can not be null.");
        }
        if (this.getArguments().nonDeterministicRandomSeed) {
            GenomeAnalysisEngine.resetRandomGenerator(System.currentTimeMillis());
        }
        if (this.getArguments().BQSR_RECAL_FILE != null) {
            this.setBaseRecalibration(this.getArguments().BQSR_RECAL_FILE, this.getArguments().quantizationLevels);
        }
        this.determineThreadAllocation();
        this.initializeDataSources();
        this.initializeSampleDB();
        this.initializeIntervals();
        this.validateSuppliedIntervals();
        MicroScheduler microScheduler = this.createMicroscheduler();
        this.initializeTempDirectory();
        this.initializeOutputStreams(microScheduler.getOutputTracker());
        Iterable<Shard> shardStrategy = this.getShardStrategy(this.readsDataSource, microScheduler.getReference(), this.intervals);
        return microScheduler.execute(this.walker, shardStrategy);
    }

    public Walker<?, ?> getWalkerByName(String walkerName) {
        return (Walker)this.walkerManager.createByName(walkerName);
    }

    public String getWalkerName(Class<? extends Walker> walkerType) {
        return this.walkerManager.getName(walkerType);
    }

    public String getName() {
        return this.myName;
    }

    public Collection<ReadFilter> createFilters() {
        List<ReadFilter> filters = WalkerManager.getReadFilters(this.walker, this.getFilterManager());
        if (this.getArguments().readGroupBlackList != null && this.getArguments().readGroupBlackList.size() > 0) {
            filters.add(new ReadGroupBlackListFilter(this.getArguments().readGroupBlackList));
        }
        for (String filterName : this.getArguments().readFilters) {
            filters.add((ReadFilter)this.getFilterManager().createByName(filterName));
        }
        return Collections.unmodifiableList(filters);
    }

    private void determineThreadAllocation() {
        Tags tags = this.parsingEngine.getTags(this.argCollection.numberOfThreads);
        Integer numCPUThreads = null;
        if (tags.containsKey("cpu") && this.argCollection.numberOfCPUThreads != null) {
            throw new UserException("Number of CPU threads specified both directly on the command-line and as a tag to the nt argument.  Please specify only one or the other.");
        }
        if (tags.containsKey("cpu")) {
            numCPUThreads = Integer.parseInt(tags.getValue("cpu"));
        } else if (this.argCollection.numberOfCPUThreads != null) {
            numCPUThreads = this.argCollection.numberOfCPUThreads;
        }
        Integer numIOThreads = null;
        if (tags.containsKey("io") && this.argCollection.numberOfIOThreads != null) {
            throw new UserException("Number of IO threads specified both directly on the command-line and as a tag to the nt argument.  Please specify only one or the other.");
        }
        if (tags.containsKey("io")) {
            numIOThreads = Integer.parseInt(tags.getValue("io"));
        } else if (this.argCollection.numberOfIOThreads != null) {
            numIOThreads = this.argCollection.numberOfIOThreads;
        }
        this.threadAllocation = new ThreadAllocation(this.argCollection.numberOfThreads, numCPUThreads, numIOThreads);
    }

    protected WalkerManager getWalkerManager() {
        return this.walkerManager;
    }

    private MicroScheduler createMicroscheduler() {
        if ((this.walker instanceof ReadWalker || this.walker instanceof DuplicateWalker || this.walker instanceof ReadPairWalker) && this.getArguments().referenceFile == null) {
            throw new UserException.CommandLineException("Read-based traversals require a reference file but none was given");
        }
        return MicroScheduler.create(this, this.walker, this.getReadsDataSource(), this.getReferenceDataSource().getReference(), this.getRodDataSources(), this.threadAllocation);
    }

    protected DownsamplingMethod getDownsamplingMethod() {
        GATKArgumentCollection argCollection = this.getArguments();
        DownsamplingMethod method = argCollection.getDownsamplingMethod() != null ? argCollection.getDownsamplingMethod() : (WalkerManager.getDownsamplingMethod(this.walker) != null ? WalkerManager.getDownsamplingMethod(this.walker) : GATKArgumentCollection.getDefaultDownsamplingMethod());
        return method;
    }

    protected void setDownsamplingMethod(DownsamplingMethod method) {
        this.argCollection.setDownsamplingMethod(method);
    }

    public BAQ.QualityMode getWalkerBAQQualityMode() {
        return WalkerManager.getBAQQualityMode(this.walker);
    }

    public BAQ.ApplicationTime getWalkerBAQApplicationTime() {
        return WalkerManager.getBAQApplicationTime(this.walker);
    }

    protected boolean includeReadsWithDeletionAtLoci() {
        return this.walker.includeReadsWithDeletionAtLoci();
    }

    protected void validateSuppliedReads() {
        GATKArgumentCollection arguments = this.getArguments();
        if (WalkerManager.isRequired(this.walker, DataSource.READS) && (arguments.samFiles == null || arguments.samFiles.size() == 0)) {
            throw new ArgumentException("Walker requires reads but none were provided.");
        }
        if (arguments.samFiles != null && arguments.samFiles.size() > 0 && !WalkerManager.isAllowed(this.walker, DataSource.READS)) {
            throw new ArgumentException("Walker does not allow reads but reads were provided.");
        }
        this.checkForDuplicateSamFiles();
    }

    protected void checkForDuplicateSamFiles() {
        HashSet<SAMReaderID> encounteredSamFiles = new HashSet<SAMReaderID>();
        LinkedHashSet<String> duplicateSamFiles = new LinkedHashSet<String>();
        for (SAMReaderID samFile : this.samReaderIDs) {
            if (encounteredSamFiles.contains(samFile)) {
                duplicateSamFiles.add(samFile.getSamFilePath());
                continue;
            }
            encounteredSamFiles.add(samFile);
        }
        if (duplicateSamFiles.size() > 0) {
            throw new ArgumentException("The following BAM files appear multiple times in the list of input files: " + duplicateSamFiles + " BAM files may be specified at most once.");
        }
    }

    protected void validateSuppliedReference() {
        GATKArgumentCollection arguments = this.getArguments();
        if (arguments.referenceFile == null) {
            throw new ArgumentException("Walker requires a reference but none was provided.");
        }
        if (arguments.referenceFile != null && !WalkerManager.isAllowed(this.walker, DataSource.REFERENCE)) {
            throw new ArgumentException("Walker does not allow a reference but one was provided.");
        }
    }

    protected void validateSuppliedIntervals() {
        GenomeLocSortedSet intervals;
        if (!(this.walker instanceof ReadWalker) && (intervals = this.getIntervals()) != null && this.getIntervals().contains(GenomeLoc.UNMAPPED)) {
            throw new ArgumentException("Interval list specifies unmapped region.  Only read walkers may include the unmapped region.");
        }
        if (this.intervals != null && this.intervals.isEmpty()) {
            logger.warn("The given combination of -L and -XL options results in an empty set.  No intervals to process.");
        }
    }

    protected Iterable<Shard> getShardStrategy(SAMDataSource readsDataSource, ReferenceSequenceFile drivingDataSource, GenomeLocSortedSet intervals) {
        int SHARD_SIZE;
        ValidationExclusion exclusions = readsDataSource != null ? readsDataSource.getReadsInfo().getValidationExclusionList() : null;
        ReferenceDataSource referenceDataSource = this.getReferenceDataSource();
        if (!readsDataSource.isEmpty()) {
            if (!readsDataSource.hasIndex() && !exclusions.contains(ValidationExclusion.TYPE.ALLOW_UNINDEXED_BAM)) {
                throw new UserException.CommandLineException("Cannot process the provided BAM file(s) because they were not indexed.  The GATK does offer limited processing of unindexed BAMs in --unsafe mode, but this GATK feature is currently unsupported.");
            }
            if (!readsDataSource.hasIndex() && intervals != null && !this.argCollection.allowIntervalsWithUnindexedBAM) {
                throw new UserException.CommandLineException("Cannot perform interval processing when reads are present but no index is available.");
            }
            if (this.walker instanceof LocusWalker) {
                if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                    throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, "Locus walkers can only traverse coordinate-sorted data.  Please resort your input BAM file(s) or set the Sort Order tag in the header appropriately.");
                }
                if (intervals == null) {
                    return readsDataSource.createShardIteratorOverMappedReads(referenceDataSource.getReference().getSequenceDictionary(), new LocusShardBalancer());
                }
                return readsDataSource.createShardIteratorOverIntervals(intervals, new LocusShardBalancer());
            }
            if (this.walker instanceof ActiveRegionWalker) {
                if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.coordinate) {
                    throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.coordinate, "Active region walkers can only traverse coordinate-sorted data.  Please resort your input BAM file(s) or set the Sort Order tag in the header appropriately.");
                }
                if (intervals == null) {
                    return readsDataSource.createShardIteratorOverMappedReads(referenceDataSource.getReference().getSequenceDictionary(), new LocusShardBalancer());
                }
                return readsDataSource.createShardIteratorOverIntervals(((ActiveRegionWalker)this.walker).extendIntervals(intervals, this.genomeLocParser, this.getReferenceDataSource().getReference()), new LocusShardBalancer());
            }
            if (this.walker instanceof ReadWalker || this.walker instanceof ReadPairWalker || this.walker instanceof DuplicateWalker) {
                if (this.walker instanceof ReadPairWalker) {
                    if (readsDataSource.getSortOrder() != SAMFileHeader.SortOrder.queryname) {
                        throw new UserException.MissortedBAM(SAMFileHeader.SortOrder.queryname, "Read pair walkers are exceptions in that they cannot be run on coordinate-sorted BAMs but instead require query name-sorted files.  You will need to resort your input BAM file in query name order to use this walker.");
                    }
                    if (intervals != null && !intervals.isEmpty()) {
                        throw new UserException.CommandLineException("Pairs traversal cannot be used in conjunction with intervals.");
                    }
                }
                if (intervals == null) {
                    return readsDataSource.createShardIteratorOverAllReads(new ReadShardBalancer());
                }
                return readsDataSource.createShardIteratorOverIntervals(intervals, new ReadShardBalancer());
            }
            throw new ReviewedStingException("Unable to determine walker type for walker " + this.walker.getClass().getName());
        }
        int n = SHARD_SIZE = this.walker instanceof RodWalker ? 1000000 : 100000;
        if (intervals == null) {
            return referenceDataSource.createShardsOverEntireReference(readsDataSource, this.genomeLocParser, SHARD_SIZE);
        }
        return referenceDataSource.createShardsOverIntervals(readsDataSource, intervals, SHARD_SIZE);
    }

    protected boolean flashbackData() {
        return this.walker instanceof ReadWalker;
    }

    private void initializeTempDirectory() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.exists() && !tempDir.mkdirs()) {
            throw new UserException.BadTmpDir("Unable to create directory");
        }
    }

    private void initializeOutputStreams(OutputTracker outputTracker) {
        for (Map.Entry<ArgumentSource, Object> entry : this.getInputs().entrySet()) {
            outputTracker.addInput(entry.getKey(), entry.getValue());
        }
        for (Stub stub : this.getOutputs()) {
            outputTracker.addOutput(stub);
        }
        outputTracker.prepareWalker(this.walker, this.getArguments().strictnessLevel);
    }

    public ReferenceDataSource getReferenceDataSource() {
        return this.referenceDataSource;
    }

    public GenomeLocParser getGenomeLocParser() {
        return this.genomeLocParser;
    }

    public void setParser(ParsingEngine parsingEngine) {
        this.parsingEngine = parsingEngine;
    }

    public void setGenomeLocParser(GenomeLocParser genomeLocParser) {
        this.genomeLocParser = genomeLocParser;
    }

    protected void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    protected void initializeIntervals() {
        GenomeLocSortedSet includeSortedSet;
        if (this.argCollection.intervals == null && this.argCollection.excludeIntervals == null) {
            return;
        }
        GenomeLocSortedSet genomeLocSortedSet = includeSortedSet = this.argCollection.intervals == null ? GenomeLocSortedSet.createSetFromSequenceDictionary(this.referenceDataSource.getReference().getSequenceDictionary()) : this.loadIntervals(this.argCollection.intervals, this.argCollection.intervalSetRule);
        if (this.argCollection.excludeIntervals == null) {
            this.intervals = includeSortedSet;
        } else {
            GenomeLocSortedSet excludeSortedSet = this.loadIntervals(this.argCollection.excludeIntervals, IntervalSetRule.UNION);
            this.intervals = includeSortedSet.subtractRegions(excludeSortedSet);
            long toPruneSize = includeSortedSet.coveredSize();
            long toExcludeSize = excludeSortedSet.coveredSize();
            long intervalSize = this.intervals.coveredSize();
            logger.info(String.format("Initial include intervals span %d loci; exclude intervals span %d loci", toPruneSize, toExcludeSize));
            logger.info(String.format("Excluding %d loci from original intervals (%.2f%% reduction)", toPruneSize - intervalSize, (double)(toPruneSize - intervalSize) / (0.01 * (double)toPruneSize)));
        }
    }

    protected GenomeLocSortedSet loadIntervals(List<IntervalBinding<Feature>> argList, IntervalSetRule rule) {
        List<GenomeLoc> allIntervals = new ArrayList<GenomeLoc>();
        for (IntervalBinding<Feature> intervalBinding : argList) {
            List<GenomeLoc> intervals = intervalBinding.getIntervals(this);
            if (intervals.isEmpty()) {
                logger.warn("The interval file " + intervalBinding.getSource() + " contains no intervals that could be parsed.");
            }
            allIntervals = IntervalUtils.mergeListsBySetOperator(intervals, allIntervals, rule);
        }
        return IntervalUtils.sortAndMergeIntervals(this.genomeLocParser, allIntervals, this.argCollection.intervalMerging);
    }

    public void addInput(ArgumentSource argumentSource, Object value) {
        this.inputs.put(argumentSource, value);
    }

    public void addOutput(Stub<?> stub) {
        this.outputs.add(stub);
    }

    public Tags getTags(Object key) {
        return this.parsingEngine.getTags(key);
    }

    protected void initializeDataSources() {
        logger.info("Strictness is " + (Object)((Object)this.argCollection.strictnessLevel));
        BAQ.DEFAULT_GOP = this.argCollection.BAQGOP;
        this.validateSuppliedReference();
        this.setReferenceDataSource(this.argCollection.referenceFile);
        this.validateSuppliedReads();
        this.readsDataSource = this.createReadsDataSource(this.argCollection, this.genomeLocParser, this.referenceDataSource.getReference());
        for (ReadFilter filter : this.filters) {
            filter.initialize(this);
        }
        this.rodDataSources = this.getReferenceOrderedDataSources(this.referenceMetaDataFiles, this.referenceDataSource.getReference().getSequenceDictionary(), this.genomeLocParser, this.argCollection.unsafe);
    }

    private void initializeSampleDB() {
        SampleDBBuilder sampleDBBuilder = new SampleDBBuilder(this, this.argCollection.pedigreeValidationType);
        sampleDBBuilder.addSamplesFromSAMHeader(this.getSAMFileHeader());
        sampleDBBuilder.addSamplesFromSampleNames(SampleUtils.getUniqueSamplesFromRods(this));
        sampleDBBuilder.addSamplesFromPedigreeFiles(this.argCollection.pedigreeFiles);
        sampleDBBuilder.addSamplesFromPedigreeStrings(this.argCollection.pedigreeStrings);
        this.sampleDB = sampleDBBuilder.getFinalSampleDB();
    }

    public SAMReaderID getReaderIDForRead(SAMRecord read) {
        return this.getReadsDataSource().getReaderID(read);
    }

    public File getSourceFileForReaderID(SAMReaderID id) {
        return this.getReadsDataSource().getSAMFile(id);
    }

    private void validateSourcesAgainstReference(SAMDataSource reads, ReferenceSequenceFile reference, Collection<ReferenceOrderedDataSource> rods, RMDTrackBuilder manager) {
        if (reads.isEmpty() && (rods == null || rods.isEmpty()) || reference == null) {
            return;
        }
        SAMSequenceDictionary referenceDictionary = reference.getSequenceDictionary();
        if (!reads.isEmpty()) {
            SAMSequenceDictionary readsDictionary = reads.getHeader().getSequenceDictionary();
            if (readsDictionary.size() == 0) {
                logger.info("Reads file is unmapped.  Skipping validation against reference.");
                return;
            }
            SequenceDictionaryUtils.validateDictionaries(logger, this.getArguments().unsafe, "reads", readsDictionary, "reference", referenceDictionary);
        }
        for (ReferenceOrderedDataSource rod : rods) {
            manager.validateTrackSequenceDictionary(rod.getName(), rod.getSequenceDictionary(), referenceDictionary);
        }
    }

    private SAMDataSource createReadsDataSource(GATKArgumentCollection argCollection, GenomeLocParser genomeLocParser, IndexedFastaSequenceFile refReader) {
        DownsamplingMethod method = this.getDownsamplingMethod();
        this.setDownsamplingMethod(method);
        if (this.getWalkerBAQApplicationTime() == BAQ.ApplicationTime.FORBIDDEN && argCollection.BAQMode != BAQ.CalculationMode.OFF) {
            throw new UserException.BadArgumentValue("baq", "Walker cannot accept BAQ'd base qualities, and yet BAQ mode " + (Object)((Object)argCollection.BAQMode) + " was requested.");
        }
        return new SAMDataSource(this.samReaderIDs, this.threadAllocation, argCollection.numberOfBAMFileHandles, genomeLocParser, argCollection.useOriginalBaseQualities, argCollection.strictnessLevel, argCollection.readBufferSize, method, new ValidationExclusion(Arrays.asList(argCollection.unsafe)), this.filters, this.includeReadsWithDeletionAtLoci(), this.getWalkerBAQApplicationTime() == BAQ.ApplicationTime.ON_INPUT ? argCollection.BAQMode : BAQ.CalculationMode.OFF, this.getWalkerBAQQualityMode(), refReader, this.getBaseRecalibration(), argCollection.defaultBaseQualities);
    }

    public void setReferenceDataSource(File refFile) {
        this.referenceDataSource = new ReferenceDataSource(refFile);
        this.genomeLocParser = new GenomeLocParser(this.referenceDataSource.getReference());
    }

    private List<ReferenceOrderedDataSource> getReferenceOrderedDataSources(Collection<RMDTriplet> referenceMetaDataFiles, SAMSequenceDictionary sequenceDictionary, GenomeLocParser genomeLocParser, ValidationExclusion.TYPE validationExclusionType) {
        RMDTrackBuilder builder = new RMDTrackBuilder(sequenceDictionary, genomeLocParser, validationExclusionType);
        ArrayList<ReferenceOrderedDataSource> dataSources = new ArrayList<ReferenceOrderedDataSource>();
        for (RMDTriplet fileDescriptor : referenceMetaDataFiles) {
            dataSources.add(new ReferenceOrderedDataSource(fileDescriptor, builder, sequenceDictionary, genomeLocParser, this.flashbackData()));
        }
        this.validateSourcesAgainstReference(this.readsDataSource, this.referenceDataSource.getReference(), dataSources, builder);
        return dataSources;
    }

    public SAMFileHeader getSAMFileHeader() {
        return this.readsDataSource.getHeader();
    }

    public SAMFileHeader getSAMFileHeader(SAMReaderID reader) {
        return this.readsDataSource.getHeader(reader);
    }

    public List<SAMFileHeader> getSAMFileHeaders() {
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        for (SAMReaderID id : this.getReadsDataSource().getReaderIDs()) {
            headers.add(this.getReadsDataSource().getHeader(id));
        }
        return headers;
    }

    public SAMSequenceDictionary getMasterSequenceDictionary() {
        return this.getReferenceDataSource().getReference().getSequenceDictionary();
    }

    public SAMDataSource getReadsDataSource() {
        return this.readsDataSource;
    }

    public void setArguments(GATKArgumentCollection argCollection) {
        this.argCollection = argCollection;
    }

    public GATKArgumentCollection getArguments() {
        return this.argCollection;
    }

    public GenomeLocSortedSet getIntervals() {
        return this.intervals;
    }

    public Collection<ReadFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<ReadFilter> filters) {
        this.filters = filters;
    }

    protected FilterManager getFilterManager() {
        return this.filterManager;
    }

    protected Map<ArgumentSource, Object> getInputs() {
        return this.inputs;
    }

    protected Collection<Stub<?>> getOutputs() {
        return this.outputs;
    }

    public List<ReferenceOrderedDataSource> getRodDataSources() {
        return this.rodDataSources;
    }

    public ReadMetrics getCumulativeMetrics() {
        return this.readsDataSource == null ? null : this.readsDataSource.getCumulativeReadMetrics();
    }

    public SampleDB getSampleDB() {
        return this.sampleDB;
    }

    public Map<String, String> getApproximateCommandLineArguments(Object ... argumentProviders) {
        return CommandLineUtils.getApproximateCommandLineArguments(this.parsingEngine, argumentProviders);
    }

    public String createApproximateCommandLineArgumentString(Object ... argumentProviders) {
        return CommandLineUtils.createApproximateCommandLineArgumentString(this.parsingEngine, argumentProviders);
    }
}

