/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.analyzecovariates;

import java.util.ArrayList;
import org.broadinstitute.sting.gatk.walkers.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.collections.NestedHashMap;

public class AnalysisDataManager {
    private NestedHashMap dataCollapsedReadGroup;
    private ArrayList<NestedHashMap> dataCollapsedByCovariate;

    AnalysisDataManager() {
    }

    AnalysisDataManager(int numCovariates) {
        this.dataCollapsedReadGroup = new NestedHashMap();
        this.dataCollapsedByCovariate = new ArrayList();
        for (int iii = 0; iii < numCovariates - 1; ++iii) {
            this.dataCollapsedByCovariate.add(new NestedHashMap());
        }
    }

    public final void addToAllTables(Object[] key, RecalDatum fullDatum, int IGNORE_QSCORES_LESS_THAN) {
        RecalDatum collapsedDatum;
        int qscore = Integer.parseInt(key[1].toString());
        Object[] readGroupCollapsedKey = new Object[1];
        Object[] covariateCollapsedKey = new Object[2];
        if (qscore >= IGNORE_QSCORES_LESS_THAN) {
            readGroupCollapsedKey[0] = key[0];
            collapsedDatum = (RecalDatum)this.dataCollapsedReadGroup.get(readGroupCollapsedKey);
            if (collapsedDatum == null) {
                this.dataCollapsedReadGroup.put((Object)new RecalDatum(fullDatum), readGroupCollapsedKey);
            } else {
                collapsedDatum.combine(fullDatum);
            }
        }
        for (int iii = 0; iii < this.dataCollapsedByCovariate.size(); ++iii) {
            if (iii != 0 && qscore < IGNORE_QSCORES_LESS_THAN) continue;
            covariateCollapsedKey[0] = key[0];
            Object theCovariateElement = key[iii + 1];
            if (theCovariateElement == null) continue;
            covariateCollapsedKey[1] = theCovariateElement;
            collapsedDatum = (RecalDatum)this.dataCollapsedByCovariate.get(iii).get(covariateCollapsedKey);
            if (collapsedDatum == null) {
                this.dataCollapsedByCovariate.get(iii).put((Object)new RecalDatum(fullDatum), covariateCollapsedKey);
                continue;
            }
            collapsedDatum.combine(fullDatum);
        }
    }

    public final NestedHashMap getCollapsedTable(int covariate) {
        if (covariate == 0) {
            return this.dataCollapsedReadGroup;
        }
        return this.dataCollapsedByCovariate.get(covariate - 1);
    }
}

