/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends FilterInputStream {
    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public boolean readBoolean() throws IOException {
        int bool = this.in.read();
        if (bool == -1) {
            throw new EOFException();
        }
        return bool != 0;
    }

    public byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return temp;
    }

    public short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (short)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (byte2 << 24 >> 16) + (byte1 << 24 >> 24);
    }

    public char readChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1) {
            throw new EOFException();
        }
        return (char)((byte2 << 24 >>> 16) + (byte1 << 24 >>> 24));
    }

    public int readInt() throws IOException {
        byte[] bytes = new byte[4];
        this.readFully(bytes);
        byte byte1 = bytes[0];
        byte byte2 = bytes[1];
        byte byte3 = bytes[2];
        byte byte4 = bytes[3];
        if (byte4 == -1) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 24 >>> 8) + (byte2 << 24 >>> 16) + (byte1 << 24 >>> 24);
    }

    public long readLong() throws IOException {
        byte[] bytes = new byte[8];
        this.readFully(bytes);
        long byte1 = bytes[0];
        long byte2 = bytes[1];
        long byte3 = bytes[2];
        long byte4 = bytes[3];
        long byte5 = bytes[4];
        long byte6 = bytes[5];
        long byte7 = bytes[6];
        long byte8 = bytes[7];
        if (byte8 == -1L) {
            throw new EOFException();
        }
        return (byte8 << 56) + (byte7 << 56 >>> 8) + (byte6 << 56 >>> 16) + (byte5 << 56 >>> 24) + (byte4 << 56 >>> 32) + (byte3 << 56 >>> 40) + (byte2 << 56 >>> 48) + (byte1 << 56 >>> 56);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public String readString() throws IOException {
        byte b;
        ByteArrayOutputStream bis = new ByteArrayOutputStream(100);
        while ((b = (byte)this.in.read()) != 0) {
            bis.write(b);
        }
        return new String(bis.toByteArray());
    }

    private void readFully(byte[] b) throws IOException {
        int count;
        int len = b.length;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int n = 0; n < len; n += count) {
            count = this.read(b, n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
    }
}

