/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.vcf.SortingVCFWriter;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeader;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFUtils;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.GenotypesContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContextBuilder;

@Reference(window=@Window(start=-200, stop=200))
public class LeftAlignVariants
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VCFWriter baseWriter = null;
    private SortingVCFWriter writer;

    @Override
    public void initialize() {
        String trackName = this.variantCollection.variants.getName();
        Set<String> samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(trackName));
        Map<String, VCFHeader> vcfHeaders = VCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(trackName));
        Set<VCFHeaderLine> headerLines = vcfHeaders.get(trackName).getMetaData();
        this.baseWriter.writeHeader(new VCFHeader(headerLines, samples));
        this.writer = new SortingVCFWriter(this.baseWriter, 200);
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        int changedSites = 0;
        for (VariantContext vc : VCs) {
            changedSites += this.alignAndWrite(vc, ref);
        }
        return changedSites;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        this.writer.close();
        System.out.println(result + " variants were aligned");
    }

    private int alignAndWrite(VariantContext vc, ReferenceContext ref) {
        if (vc.isBiallelic() && vc.isIndel() && !vc.isComplexIndel()) {
            return this.writeLeftAlignedIndel(vc, ref);
        }
        this.writer.add(vc);
        return 0;
    }

    private int writeLeftAlignedIndel(VariantContext vc, ReferenceContext ref) {
        byte[] refSeq = ref.getBases();
        int indelLength = vc.isSimpleDeletion() ? vc.getReference().length() : vc.getAlternateAllele(0).length();
        if (indelLength > 200) {
            this.writer.add(vc);
            return 0;
        }
        int originalIndex = ref.getLocus().getStart() - ref.getWindow().getStart() + 1;
        byte[] originalIndel = LeftAlignVariants.makeHaplotype(vc, refSeq, originalIndex, indelLength);
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>();
        elements.add(new CigarElement(originalIndex, CigarOperator.M));
        elements.add(new CigarElement(indelLength, vc.isSimpleDeletion() ? CigarOperator.D : CigarOperator.I));
        elements.add(new CigarElement(refSeq.length - originalIndex, CigarOperator.M));
        Cigar originalCigar = new Cigar(elements);
        Cigar newCigar = AlignmentUtils.leftAlignIndel(originalCigar, refSeq, originalIndel, 0, 0);
        if (!newCigar.equals(originalCigar) && newCigar.numCigarElements() > 1) {
            int difference = originalIndex - newCigar.getCigarElement(0).getLength();
            VariantContext newVC = new VariantContextBuilder(vc).start(vc.getStart() - difference).stop(vc.getEnd() - difference).make();
            int indelIndex = originalIndex - difference;
            byte[] newBases = new byte[indelLength];
            System.arraycopy(vc.isSimpleDeletion() ? refSeq : originalIndel, indelIndex, newBases, 0, indelLength);
            Allele newAllele = Allele.create(newBases, vc.isSimpleDeletion());
            newVC = LeftAlignVariants.updateAllele(newVC, newAllele, refSeq[indelIndex - 1]);
            this.writer.add(newVC);
            return 1;
        }
        this.writer.add(vc);
        return 0;
    }

    private static byte[] makeHaplotype(VariantContext vc, byte[] ref, int indexOfRef, int indelLength) {
        byte[] hap = new byte[ref.length + indelLength * (vc.isSimpleDeletion() ? -1 : 1)];
        System.arraycopy(ref, 0, hap, 0, indexOfRef);
        int currentPos = indexOfRef;
        if (vc.isSimpleDeletion()) {
            indexOfRef += indelLength;
        } else {
            System.arraycopy(vc.getAlternateAllele(0).getBases(), 0, hap, currentPos, indelLength);
            currentPos += indelLength;
        }
        System.arraycopy(ref, indexOfRef, hap, currentPos, ref.length - indexOfRef);
        return hap;
    }

    public static VariantContext updateAllele(VariantContext vc, Allele newAllele, Byte refBaseForIndel) {
        HashMap<Allele, Allele> alleleMap = new HashMap<Allele, Allele>(vc.getAlleles().size());
        if (newAllele.isReference()) {
            alleleMap.put(vc.getReference(), newAllele);
            alleleMap.put(vc.getAlternateAllele(0), vc.getAlternateAllele(0));
        } else {
            alleleMap.put(vc.getReference(), vc.getReference());
            alleleMap.put(vc.getAlternateAllele(0), newAllele);
        }
        GenotypesContext newGenotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                Allele newA = (Allele)alleleMap.get(allele);
                if (newA == null) {
                    newA = Allele.NO_CALL;
                }
                newAlleles.add(newA);
            }
            newGenotypes.add(Genotype.modifyAlleles(genotype, newAlleles));
        }
        return new VariantContextBuilder(vc).alleles(alleleMap.values()).genotypes(newGenotypes).referenceBaseForIndel(refBaseForIndel).make();
    }
}

