/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.bqsr;

import java.util.BitSet;
import org.broadinstitute.sting.gatk.walkers.bqsr.CovariateValues;
import org.broadinstitute.sting.gatk.walkers.bqsr.EventType;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class ReadCovariates {
    private final BitSet[][] mismatchesKeySet;
    private final BitSet[][] insertionsKeySet;
    private final BitSet[][] deletionsKeySet;
    private int nextCovariateIndex;

    public ReadCovariates(int readLength, int numberOfCovariates) {
        this.mismatchesKeySet = new BitSet[readLength][numberOfCovariates];
        this.insertionsKeySet = new BitSet[readLength][numberOfCovariates];
        this.deletionsKeySet = new BitSet[readLength][numberOfCovariates];
        this.nextCovariateIndex = 0;
    }

    public void addCovariate(CovariateValues covariate) {
        this.transposeCovariateValues(this.mismatchesKeySet, covariate.getMismatches());
        this.transposeCovariateValues(this.insertionsKeySet, covariate.getInsertions());
        this.transposeCovariateValues(this.deletionsKeySet, covariate.getDeletions());
        ++this.nextCovariateIndex;
    }

    public BitSet[] getKeySet(int readPosition, EventType errorModel) {
        switch (errorModel) {
            case BASE_SUBSTITUTION: {
                return this.getMismatchesKeySet(readPosition);
            }
            case BASE_INSERTION: {
                return this.getInsertionsKeySet(readPosition);
            }
            case BASE_DELETION: {
                return this.getDeletionsKeySet(readPosition);
            }
        }
        throw new ReviewedStingException("Unrecognized Base Recalibration type: " + (Object)((Object)errorModel));
    }

    public BitSet[] getMismatchesKeySet(int readPosition) {
        return this.mismatchesKeySet[readPosition];
    }

    public BitSet[] getInsertionsKeySet(int readPosition) {
        return this.insertionsKeySet[readPosition];
    }

    public BitSet[] getDeletionsKeySet(int readPosition) {
        return this.deletionsKeySet[readPosition];
    }

    private void transposeCovariateValues(BitSet[][] keySet, BitSet[] covariateValues) {
        for (int i = 0; i < covariateValues.length; ++i) {
            keySet[i][this.nextCovariateIndex] = covariateValues[i];
        }
    }

    protected BitSet[][] getMismatchesKeySet() {
        return this.mismatchesKeySet;
    }

    protected BitSet[][] getInsertionsKeySet() {
        return this.insertionsKeySet;
    }

    protected BitSet[][] getDeletionsKeySet() {
        return this.deletionsKeySet;
    }
}

