/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.iterators;

import java.util.Collection;
import java.util.LinkedList;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.iterators.ReadSelector;

class AllReadsSelector
implements ReadSelector {
    private Collection<SAMRecord> reads = new LinkedList<SAMRecord>();
    private long readsSeen = 0L;
    private int downsamplingExtent = 0;

    AllReadsSelector() {
    }

    @Override
    public void submitRead(SAMRecord read) {
        this.reads.add(read);
        ++this.readsSeen;
    }

    @Override
    public void notifyReadRejected(SAMRecord read) {
        ++this.readsSeen;
        this.downsamplingExtent = Math.max(this.downsamplingExtent, read.getAlignmentEnd());
    }

    @Override
    public void complete() {
    }

    @Override
    public long getNumReadsSeen() {
        return this.readsSeen;
    }

    @Override
    public long getNumReadsSelected() {
        return this.readsSeen;
    }

    @Override
    public int getDownsamplingExtent() {
        return this.downsamplingExtent;
    }

    @Override
    public Collection<SAMRecord> getSelectedReads() {
        return this.reads;
    }

    @Override
    public void reset() {
        this.reads.clear();
        this.readsSeen = 0L;
        this.downsamplingExtent = 0;
    }
}

