/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.io.stubs;

import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.broadinstitute.sting.commandline.ArgumentDefinition;
import org.broadinstitute.sting.commandline.ArgumentIOType;
import org.broadinstitute.sting.commandline.ArgumentMatches;
import org.broadinstitute.sting.commandline.ArgumentSource;
import org.broadinstitute.sting.commandline.ArgumentTypeDescriptor;
import org.broadinstitute.sting.commandline.MissingArgumentValueException;
import org.broadinstitute.sting.commandline.ParsingEngine;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.io.stubs.VCFWriterStub;
import org.broadinstitute.sting.utils.codecs.vcf.VCFWriter;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class VCFWriterArgumentTypeDescriptor
extends ArgumentTypeDescriptor {
    public static final String NO_HEADER_ARG_NAME = "NO_HEADER";
    public static final String SITES_ONLY_ARG_NAME = "sites_only";
    public static final HashSet<String> SUPPORTED_ZIPPED_SUFFIXES = new HashSet();
    private final GenomeAnalysisEngine engine;
    private final OutputStream defaultOutputStream;
    private final Collection<Object> argumentSources;

    public VCFWriterArgumentTypeDescriptor(GenomeAnalysisEngine engine, OutputStream defaultOutputStream, Collection<Object> argumentSources) {
        this.engine = engine;
        this.defaultOutputStream = defaultOutputStream;
        this.argumentSources = argumentSources;
    }

    @Override
    public boolean supports(Class type) {
        return VCFWriter.class.equals((Object)type);
    }

    @Override
    public List<ArgumentDefinition> createArgumentDefinitions(ArgumentSource source) {
        return Arrays.asList(this.createDefaultArgumentDefinition(source), this.createNoHeaderArgumentDefinition(), this.createSitesOnlyArgumentDefinition());
    }

    @Override
    public boolean createsTypeDefault(ArgumentSource source) {
        return source.isRequired();
    }

    @Override
    public String typeDefaultDocString(ArgumentSource source) {
        return "stdout";
    }

    @Override
    public Object createTypeDefault(ParsingEngine parsingEngine, ArgumentSource source, Type type) {
        if (!source.isRequired()) {
            throw new ReviewedStingException("BUG: tried to create type default for argument type descriptor that can't support a type default.");
        }
        VCFWriterStub stub = new VCFWriterStub(this.engine, this.defaultOutputStream, false, this.argumentSources, false, false);
        this.engine.addOutput(stub);
        return stub;
    }

    @Override
    public Object parse(ParsingEngine parsingEngine, ArgumentSource source, Type type, ArgumentMatches matches) {
        File writerFile;
        ArgumentDefinition defaultArgumentDefinition = this.createDefaultArgumentDefinition(source);
        String writerFileName = this.getArgumentValue(defaultArgumentDefinition, matches);
        File file = writerFile = writerFileName != null ? new File(writerFileName) : null;
        if (writerFile == null && !source.isRequired()) {
            throw new MissingArgumentValueException(defaultArgumentDefinition);
        }
        boolean compress = VCFWriterArgumentTypeDescriptor.isCompressed(writerFileName);
        boolean skipWritingHeader = this.argumentIsPresent(this.createNoHeaderArgumentDefinition(), matches);
        boolean doNotWriteGenotypes = this.argumentIsPresent(this.createSitesOnlyArgumentDefinition(), matches);
        VCFWriterStub stub = writerFile != null ? new VCFWriterStub(this.engine, writerFile, compress, this.argumentSources, skipWritingHeader, doNotWriteGenotypes) : new VCFWriterStub(this.engine, this.defaultOutputStream, compress, this.argumentSources, skipWritingHeader, doNotWriteGenotypes);
        parsingEngine.addTags(stub, this.getArgumentTags(matches));
        this.engine.addOutput(stub);
        return stub;
    }

    private ArgumentDefinition createNoHeaderArgumentDefinition() {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, NO_HEADER_ARG_NAME, NO_HEADER_ARG_NAME, "Don't output the usual VCF header tag with the command line. FOR DEBUGGING PURPOSES ONLY. This option is required in order to pass integration tests.", false, true, false, true, null, null, null, null);
    }

    private ArgumentDefinition createSitesOnlyArgumentDefinition() {
        return new ArgumentDefinition(ArgumentIOType.ARGUMENT, Boolean.TYPE, SITES_ONLY_ARG_NAME, SITES_ONLY_ARG_NAME, "Just output sites without genotypes (i.e. only the first 8 columns of the VCF)", false, true, false, true, null, null, null, null);
    }

    public static boolean isCompressed(String writerFileName) {
        return writerFileName != null && SUPPORTED_ZIPPED_SUFFIXES.contains(VCFWriterArgumentTypeDescriptor.getFileSuffix(writerFileName));
    }

    private static String getFileSuffix(String fileName) {
        int indexOfLastDot = fileName.lastIndexOf(".");
        if (indexOfLastDot == -1) {
            return "";
        }
        return fileName.substring(indexOfLastDot).toLowerCase();
    }

    static {
        SUPPORTED_ZIPPED_SUFFIXES.add(".gz");
        SUPPORTED_ZIPPED_SUFFIXES.add(".gzip");
    }
}

