/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.alignment.bwa;

import java.io.File;
import java.io.IOException;
import net.sf.samtools.SAMSequenceDictionary;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.StringUtil;
import org.broadinstitute.sting.alignment.reference.bwt.AMBWriter;
import org.broadinstitute.sting.alignment.reference.bwt.ANNWriter;
import org.broadinstitute.sting.alignment.reference.bwt.BWT;
import org.broadinstitute.sting.alignment.reference.bwt.BWTWriter;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArray;
import org.broadinstitute.sting.alignment.reference.bwt.SuffixArrayWriter;
import org.broadinstitute.sting.alignment.reference.packing.PackUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;

public class BWTFiles {
    public final File annFile;
    public final File ambFile;
    public final File pacFile;
    public final File rpacFile;
    public final File forwardBWTFile;
    public final File forwardSAFile;
    public final File reverseBWTFile;
    public final File reverseSAFile;
    public final boolean autogenerated;

    public BWTFiles(String prefix) {
        if (prefix == null) {
            throw new ReviewedStingException("Prefix must not be null.");
        }
        this.annFile = new File(prefix + ".ann");
        this.ambFile = new File(prefix + ".amb");
        this.pacFile = new File(prefix + ".pac");
        this.rpacFile = new File(prefix + ".rpac");
        this.forwardBWTFile = new File(prefix + ".bwt");
        this.forwardSAFile = new File(prefix + ".sa");
        this.reverseBWTFile = new File(prefix + ".rbwt");
        this.reverseSAFile = new File(prefix + ".rsa");
        this.autogenerated = false;
    }

    private BWTFiles(File annFile, File ambFile, File pacFile, File forwardBWTFile, File forwardSAFile, File rpacFile, File reverseBWTFile, File reverseSAFile) {
        this.annFile = annFile;
        this.ambFile = ambFile;
        this.pacFile = pacFile;
        this.forwardBWTFile = forwardBWTFile;
        this.forwardSAFile = forwardSAFile;
        this.rpacFile = rpacFile;
        this.reverseBWTFile = reverseBWTFile;
        this.reverseSAFile = reverseSAFile;
        this.autogenerated = true;
    }

    public void close() {
        if (this.autogenerated) {
            boolean success = true;
            success = this.annFile.delete();
            success &= this.ambFile.delete();
            success &= this.pacFile.delete();
            success &= this.forwardBWTFile.delete();
            success &= this.forwardSAFile.delete();
            success &= this.rpacFile.delete();
            success &= this.reverseBWTFile.delete();
            if (!(success &= this.reverseSAFile.delete())) {
                throw new ReviewedStingException("Unable to clean up autogenerated representation");
            }
        }
    }

    public static BWTFiles createFromReferenceSequence(byte[] referenceSequence) {
        File rsaFile;
        File rbwtFile;
        File rpacFile;
        File saFile;
        File bwtFile;
        File pacFile;
        File ambFile;
        File annFile;
        byte[] normalizedReferenceSequence = new byte[referenceSequence.length];
        System.arraycopy(referenceSequence, 0, normalizedReferenceSequence, 0, referenceSequence.length);
        BWTFiles.normalizeReferenceSequence(normalizedReferenceSequence);
        try {
            annFile = File.createTempFile("bwt", ".ann");
            ambFile = File.createTempFile("bwt", ".amb");
            SAMSequenceDictionary dictionary = new SAMSequenceDictionary();
            dictionary.addSequence(new SAMSequenceRecord("autogenerated", normalizedReferenceSequence.length));
            ANNWriter annWriter = new ANNWriter(annFile);
            annWriter.write(dictionary);
            annWriter.close();
            AMBWriter ambWriter = new AMBWriter(ambFile);
            ambWriter.writeEmpty(dictionary);
            ambWriter.close();
            pacFile = File.createTempFile("bwt", ".pac");
            bwtFile = File.createTempFile("bwt", ".bwt");
            saFile = File.createTempFile("bwt", ".sa");
            BWTFiles.writeEncodedReferenceSequence(normalizedReferenceSequence, pacFile, bwtFile, saFile);
            byte[] reverseReferenceSequence = Utils.reverse(normalizedReferenceSequence);
            rpacFile = File.createTempFile("bwt", ".rpac");
            rbwtFile = File.createTempFile("bwt", ".rbwt");
            rsaFile = File.createTempFile("bwt", ".rsa");
            BWTFiles.writeEncodedReferenceSequence(reverseReferenceSequence, rpacFile, rbwtFile, rsaFile);
        }
        catch (IOException ex) {
            throw new ReviewedStingException("Unable to write autogenerated reference sequence to temporary files");
        }
        annFile.deleteOnExit();
        ambFile.deleteOnExit();
        pacFile.deleteOnExit();
        bwtFile.deleteOnExit();
        saFile.deleteOnExit();
        rpacFile.deleteOnExit();
        rbwtFile.deleteOnExit();
        rsaFile.deleteOnExit();
        return new BWTFiles(annFile, ambFile, pacFile, bwtFile, saFile, rpacFile, rbwtFile, rsaFile);
    }

    private static void writeEncodedReferenceSequence(byte[] referenceSequence, File pacFile, File bwtFile, File suffixArrayFile) throws IOException {
        PackUtils.writeReferenceSequence(pacFile, referenceSequence);
        BWT bwt = BWT.createFromReferenceSequence(referenceSequence);
        BWTWriter bwtWriter = new BWTWriter(bwtFile);
        bwtWriter.write(bwt);
        bwtWriter.close();
        SuffixArray suffixArray = SuffixArray.createFromReferenceSequence(referenceSequence);
        SuffixArrayWriter suffixArrayWriter = new SuffixArrayWriter(suffixArrayFile);
        suffixArrayWriter.write(suffixArray);
        suffixArrayWriter.close();
    }

    private static void normalizeReferenceSequence(byte[] referenceSequence) {
        StringUtil.toUpperCase(referenceSequence);
        for (byte base : referenceSequence) {
            if (base == 65 || base == 67 || base == 71 || base == 84) continue;
            throw new ReviewedStingException(String.format("Base type %c is not supported when building references on-the-fly", Character.valueOf((char)base)));
        }
    }
}

