/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import net.sf.picard.util.Log;
import net.sf.samtools.SAMRecord;

public class ProgressLogger {
    private final Log log;
    private final int n;
    private final String verb;
    private final long startTime = System.currentTimeMillis();
    private final NumberFormat fmt = new DecimalFormat("#,###");
    private final NumberFormat timeFmt = new DecimalFormat("00");
    private long processed = 0L;
    private long lastStartTime = this.startTime;

    public ProgressLogger(Log log, int n, String verb) {
        this.log = log;
        this.n = n;
        this.verb = verb;
    }

    public ProgressLogger(Log log, int n) {
        this(log, n, "Processed");
    }

    public ProgressLogger(Log log) {
        this(log, 1000000);
    }

    public synchronized boolean record(SAMRecord rec) {
        if (++this.processed % (long)this.n == 0L) {
            long now = System.currentTimeMillis();
            long lastPeriodSeconds = (now - this.lastStartTime) / 1000L;
            this.lastStartTime = now;
            long seconds = (System.currentTimeMillis() - this.startTime) / 1000L;
            String elapsed = this.formatElapseTime(seconds);
            String period = this.pad(this.fmt.format(lastPeriodSeconds), 4);
            String processed = this.pad(this.fmt.format(this.processed), 13);
            String readInfo = rec.getReferenceIndex() == -1 ? "*/*" : rec.getReferenceName() + ":" + this.fmt.format(rec.getAlignmentStart());
            this.log.info(this.verb, " ", processed, " records.  Elapsed time: ", elapsed, "s.  Time for last ", this.fmt.format(this.n), ": ", period, "s.  Last read position: ", readInfo);
            return true;
        }
        return false;
    }

    public boolean record(SAMRecord ... recs) {
        boolean triggered = false;
        for (SAMRecord rec : recs) {
            triggered = this.record(rec) || triggered;
        }
        return triggered;
    }

    public long getCount() {
        return this.processed;
    }

    public long getElapsedSeconds() {
        return (System.currentTimeMillis() - this.startTime) / 1000L;
    }

    private String pad(String in, int length) {
        while (in.length() < length) {
            in = " " + in;
        }
        return in;
    }

    private String formatElapseTime(long seconds) {
        long s = seconds % 60L;
        long allMinutes = seconds / 60L;
        long m = allMinutes % 60L;
        long h = allMinutes / 60L;
        return this.timeFmt.format(h) + ":" + this.timeFmt.format(m) + ":" + this.timeFmt.format(s);
    }
}

